/*
 * Decompiled with CFR 0.152.
 */
package org.coode.oppl.querymatching;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.coode.oppl.ConstraintVisitorEx;
import org.coode.oppl.InCollectionConstraint;
import org.coode.oppl.InequalityConstraint;
import org.coode.oppl.NAFConstraint;
import org.coode.oppl.OWLObjectInstantiator;
import org.coode.oppl.RegExpConstraint;
import org.coode.oppl.Variable;
import org.coode.oppl.function.ValueComputationParameters;
import org.coode.oppl.log.Logging;
import org.coode.oppl.utils.ArgCheck;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLObjectVisitorEx;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLRuntimeException;

public class ConstraintChecker
implements ConstraintVisitorEx<Boolean> {
    private final ValueComputationParameters parameters;
    private final OWLObjectInstantiator instantiator;

    public ConstraintChecker(ValueComputationParameters parameters) {
        this.parameters = ArgCheck.checkNotNull(parameters, "parameters");
        this.instantiator = new OWLObjectInstantiator(this.getParameters());
    }

    public ValueComputationParameters getParameters() {
        return this.parameters;
    }

    @Override
    public Boolean visit(InequalityConstraint c) {
        OWLObject expression = c.getExpression();
        OWLObject instantiatedObject = (OWLObject)expression.accept((OWLObjectVisitorEx)this.instantiator);
        Variable<?> variable = c.getVariable();
        OWLObject assignedValue = this.getParameters().getBindingNode().getAssignmentValue(variable, this.getParameters());
        return !assignedValue.equals(instantiatedObject);
    }

    @Override
    public Boolean visit(InCollectionConstraint<? extends OWLObject> c) {
        Set<? extends OWLObject> collection = c.getCollection();
        OWLObject assignedValue = this.getParameters().getBindingNode().getAssignmentValue(c.getVariable(), this.getParameters());
        HashSet<Object> instantiatedObjects = new HashSet<Object>(collection.size());
        for (OWLObject oWLObject : collection) {
            instantiatedObjects.add(oWLObject.accept((OWLObjectVisitorEx)this.instantiator));
        }
        return instantiatedObjects.contains(assignedValue);
    }

    @Override
    public Boolean visit(RegExpConstraint c) {
        return c.matches(this.getParameters());
    }

    @Override
    public Boolean visit(NAFConstraint nafConstraint) {
        OWLAxiom instantiatedAxiom = (OWLAxiom)nafConstraint.getAxiom().accept((OWLObjectVisitorEx)this.instantiator);
        boolean toReturn = false;
        try {
            if (this.getParameters().getConstraintSystem().getReasoner() != null && nafConstraint.getAxiom().isLogicalAxiom()) {
                toReturn = !this.getParameters().getConstraintSystem().getReasoner().isEntailed(instantiatedAxiom);
            } else {
                boolean found = false;
                Iterator iterator = this.getParameters().getConstraintSystem().getOntologyManager().getOntologies().iterator();
                while (!found && iterator.hasNext()) {
                    OWLOntology ontology = (OWLOntology)iterator.next();
                    found = ontology.containsAxiom(instantiatedAxiom);
                }
                toReturn = !found;
            }
        }
        catch (OWLRuntimeException e) {
            Logging.getQueryLogger().log("OWLReasonerException caught whilst checking the constraint ", nafConstraint, this.getParameters().getConstraintSystem(), (Object)e);
        }
        return toReturn;
    }
}

