/*
 * Decompiled with CFR 0.152.
 */
package org.coode.oppl;

import org.coode.oppl.IndividualVariableScope;
import org.coode.oppl.SubClassVariableScope;
import org.coode.oppl.SuperClassVariableScope;
import org.coode.oppl.exceptions.NullReasonerException;
import org.coode.oppl.exceptions.OPPLException;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassAssertionAxiom;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.model.OWLRuntimeException;
import org.semanticweb.owlapi.model.OWLSubClassOfAxiom;
import org.semanticweb.owlapi.reasoner.OWLReasoner;

public class VariableScopeChecker {
    private final OWLOntologyManager ontologyManager;
    private final OWLReasoner reasoner;

    public VariableScopeChecker(OWLOntologyManager ontologyManager, OWLReasoner reasoner) throws OPPLException {
        if (reasoner == null) {
            throw new NullReasonerException();
        }
        this.ontologyManager = ontologyManager;
        this.reasoner = reasoner;
    }

    protected boolean check(OWLClass owlCass, SubClassVariableScope scope) {
        OWLClassExpression description = scope.getClassExpression();
        OWLSubClassOfAxiom axiom = this.getOntologyManager().getOWLDataFactory().getOWLSubClassOfAxiom((OWLClassExpression)owlCass, description);
        return this.getReasoner().isEntailed((OWLAxiom)axiom);
    }

    protected boolean check(OWLClass owlCass, SuperClassVariableScope scope) throws OWLRuntimeException {
        OWLClassExpression description = scope.getClassExpression();
        OWLSubClassOfAxiom axiom = this.getOntologyManager().getOWLDataFactory().getOWLSubClassOfAxiom(description, (OWLClassExpression)owlCass);
        return this.getReasoner().isEntailed((OWLAxiom)axiom);
    }

    protected boolean check(OWLIndividual individual, IndividualVariableScope scope) throws OWLRuntimeException {
        OWLClassExpression description = scope.getClassExpression();
        OWLClassAssertionAxiom axiom = this.getOntologyManager().getOWLDataFactory().getOWLClassAssertionAxiom(description, individual);
        return this.getReasoner().isEntailed((OWLAxiom)axiom);
    }

    public OWLReasoner getReasoner() {
        return this.reasoner;
    }

    public OWLOntologyManager getOntologyManager() {
        return this.ontologyManager;
    }
}

