/*
 * Decompiled with CFR 0.152.
 */
package org.coode.oppl;

import org.coode.oppl.OPPLFactory;
import org.coode.oppl.OPPLParser;
import org.coode.oppl.utils.ArgCheck;
import org.coode.parsers.ErrorListener;
import org.coode.parsers.factory.SymbolTableFactory;
import org.coode.parsers.oppl.OPPLSymbolTable;
import org.coode.parsers.oppl.factory.SimpleSymbolTableFactory;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.reasoner.OWLReasoner;

public class ParserFactory
implements OPPLParser.AbstractParserFactory {
    private final OWLOntologyManager ontologyManager;
    private final OWLOntology ontology;
    private final OWLReasoner reasoner;

    public ParserFactory(OWLOntologyManager ontologyManager, OWLOntology ontology, OWLReasoner reasoner) {
        this.ontologyManager = ArgCheck.checkNotNull(ontologyManager, "ontologyManager");
        this.ontology = ArgCheck.checkNotNull(ontology, "ontology");
        this.reasoner = reasoner;
    }

    @Override
    public OPPLParser build(ErrorListener errorListener) {
        SimpleSymbolTableFactory symbolTableFactory = new SimpleSymbolTableFactory(this.getOntologyManager());
        return this.build(errorListener, symbolTableFactory);
    }

    public OPPLParser build(ErrorListener errorListener, SymbolTableFactory<OPPLSymbolTable> symbolTableFactory) {
        return new OPPLParser(this.getOPPLFactory(), errorListener, symbolTableFactory);
    }

    @Override
    public OPPLFactory getOPPLFactory() {
        return new OPPLFactory(this.getOntologyManager(), this.getOntology(), this.getReasoner());
    }

    public OWLOntologyManager getOntologyManager() {
        return this.ontologyManager;
    }

    public OWLOntology getOntology() {
        return this.ontology;
    }

    public OWLReasoner getReasoner() {
        return this.reasoner;
    }
}

