/*
 * Decompiled with CFR 0.152.
 */
package org.coode.oppl;

import java.util.ArrayList;
import org.coode.oppl.OPPLAbstractFactory;
import org.coode.oppl.entity.OWLEntityCreationException;
import org.coode.oppl.entity.OWLEntityCreationSet;
import org.coode.oppl.entity.OWLEntityFactory;
import org.semanticweb.owlapi.model.AddAxiom;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLAnnotationAssertionAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLAnnotationSubject;
import org.semanticweb.owlapi.model.OWLAnnotationValue;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDeclarationAxiom;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLObjectProperty;

public class EntityFactory
implements OWLEntityFactory {
    private final OPPLAbstractFactory factory;
    private static final char[] forbiddenCharacters = new char[]{'\'', '>', '<', '`', '\"'};

    public EntityFactory(OPPLAbstractFactory f) {
        this.factory = f;
    }

    private IRI buildIRI(String shortName) {
        IRI ontologyIRI = this.factory.getOntology().getOntologyID().getOntologyIRI();
        return ontologyIRI == null ? IRI.create((String)String.format("%s#%s", this.factory.getDefaultOntologyIRI().toString(), shortName)) : IRI.create((String)String.format("%s#%s", ontologyIRI.toString(), shortName));
    }

    private String buildFragment(String label) {
        StringBuilder b = new StringBuilder(label);
        for (int i = 0; i < b.length(); ++i) {
            char c = b.charAt(i);
            if (Character.isLetterOrDigit(c) || c == '_') continue;
            b.setCharAt(i, '_');
        }
        return b.toString().replaceAll("[_]+", "_");
    }

    private String buildLabelString(String label) {
        String toReturn = label.trim();
        for (char c : forbiddenCharacters) {
            toReturn = toReturn.replace(c + "", "");
        }
        return toReturn;
    }

    @Override
    public OWLEntityCreationSet<OWLClass> createOWLClass(String shortName, IRI baseIRI) throws OWLEntityCreationException {
        return this.createOWLEntity(OWLClass.class, shortName, baseIRI);
    }

    @Override
    public OWLEntityCreationSet<OWLDataProperty> createOWLDataProperty(String shortName, IRI baseIRI) throws OWLEntityCreationException {
        return this.createOWLEntity(OWLDataProperty.class, shortName, baseIRI);
    }

    @Override
    public <T extends OWLEntity> OWLEntityCreationSet<T> createOWLEntity(Class<T> type, String shortName, IRI baseIRI) throws OWLEntityCreationException {
        String label = this.buildLabelString(shortName);
        String realShortName = this.buildFragment(label);
        IRI anIRI = this.buildIRI(realShortName);
        T entity = this.getOWLEntity(type, anIRI);
        OWLDeclarationAxiom declarationAxiom = this.factory.getOWLDataFactory().getOWLDeclarationAxiom(entity);
        ArrayList<AddAxiom> changes = new ArrayList<AddAxiom>();
        changes.add(new AddAxiom(this.factory.getOntology(), (OWLAxiom)declarationAxiom));
        if (!realShortName.equals(shortName)) {
            OWLAnnotationProperty rdfsLabel = this.factory.getOWLDataFactory().getRDFSLabel();
            OWLAnnotation owlAnnotation = this.factory.getOWLDataFactory().getOWLAnnotation(rdfsLabel, (OWLAnnotationValue)this.factory.getOWLDataFactory().getOWLLiteral(label));
            OWLAnnotationAssertionAxiom owlAnnotationAssertionAxiom = this.factory.getOWLDataFactory().getOWLAnnotationAssertionAxiom((OWLAnnotationSubject)entity.getIRI(), owlAnnotation);
            AddAxiom extraChange = new AddAxiom(this.factory.getOntology(), (OWLAxiom)owlAnnotationAssertionAxiom);
            changes.add(extraChange);
        }
        return new OWLEntityCreationSet<T>(entity, changes);
    }

    @Override
    public OWLEntityCreationSet<OWLNamedIndividual> createOWLIndividual(String shortName, IRI baseIRI) throws OWLEntityCreationException {
        return this.createOWLEntity(OWLNamedIndividual.class, shortName, baseIRI);
    }

    @Override
    public OWLEntityCreationSet<OWLObjectProperty> createOWLObjectProperty(String shortName, IRI baseIRI) throws OWLEntityCreationException {
        return this.createOWLEntity(OWLObjectProperty.class, shortName, baseIRI);
    }

    @Override
    public OWLEntityCreationSet<OWLAnnotationProperty> createOWLAnnotationProperty(String shortName, IRI baseIRI) throws OWLEntityCreationException {
        return this.createOWLEntity(OWLAnnotationProperty.class, shortName, baseIRI);
    }

    private <T extends OWLEntity> T getOWLEntity(Class<T> type, IRI IRI2) {
        if (OWLClass.class.isAssignableFrom(type)) {
            return (T)this.factory.getOWLDataFactory().getOWLClass(IRI2);
        }
        if (OWLObjectProperty.class.isAssignableFrom(type)) {
            return (T)this.factory.getOWLDataFactory().getOWLObjectProperty(IRI2);
        }
        if (OWLDataProperty.class.isAssignableFrom(type)) {
            return (T)this.factory.getOWLDataFactory().getOWLDataProperty(IRI2);
        }
        if (OWLNamedIndividual.class.isAssignableFrom(type)) {
            return (T)this.factory.getOWLDataFactory().getOWLNamedIndividual(IRI2);
        }
        return null;
    }

    private <T extends OWLEntity> boolean isValidNewID(IRI baseIRI) {
        return baseIRI.equals((Object)this.factory.getOntology().getOntologyID().getOntologyIRI());
    }

    @Override
    public <T extends OWLEntity> OWLEntityCreationSet<T> preview(Class<T> type, String shortName, IRI baseIRI) throws OWLEntityCreationException {
        return this.createOWLEntity(type, shortName, baseIRI);
    }

    @Override
    public void tryCreate(Class<? extends OWLEntity> type, String shortName, IRI baseIRI) throws OWLEntityCreationException {
        if (!this.isValidNewID(baseIRI)) {
            throw new OWLEntityCreationException("Invalid name: " + shortName + "for an " + type.getName());
        }
    }
}

