/*
 * Decompiled with CFR 0.152.
 */
package org.coode.parsers.oppl;

import org.coode.oppl.entity.OWLEntityCreationException;
import org.coode.oppl.entity.OWLEntityFactory;
import org.coode.oppl.utils.ArgCheck;
import org.coode.parsers.ErrorListener;
import org.coode.parsers.ManchesterOWLSyntaxTree;
import org.coode.parsers.OWLEntitySymbol;
import org.coode.parsers.OWLType;
import org.coode.parsers.Type;
import org.coode.parsers.TypeVistorAdapter;
import org.coode.parsers.oppl.CreateOnDemand;
import org.coode.parsers.oppl.OPPLSymbolTable;
import org.coode.parsers.oppl.OPPLSyntaxTree;
import org.coode.parsers.oppl.TypesEnforcer;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLEntity;

public class DefaultTypeEnforcer
implements TypesEnforcer {
    private final OPPLSymbolTable symbolTable;
    private final OWLEntityFactory entityFactory;
    private final ErrorListener errorListener;

    public DefaultTypeEnforcer(OPPLSymbolTable symbolTable, OWLEntityFactory entityFactory, ErrorListener listener) {
        this.symbolTable = ArgCheck.checkNotNull(symbolTable, "symbolTable");
        this.entityFactory = ArgCheck.checkNotNull(entityFactory, "entityFactory");
        this.errorListener = ArgCheck.checkNotNull(listener, "listener");
    }

    @Override
    public void enforceAllValueRestrictionTypes(ManchesterOWLSyntaxTree parentExpression, ManchesterOWLSyntaxTree propertyExpression, ManchesterOWLSyntaxTree filler) {
        this.enforceQualifiedRestrictionTypes(parentExpression, propertyExpression, filler);
    }

    private void enforceQualifiedRestrictionTypes(ManchesterOWLSyntaxTree parentExpression, final ManchesterOWLSyntaxTree propertyExpression, ManchesterOWLSyntaxTree filler) {
        ArgCheck.checkNotNull(propertyExpression, "propertyExpression");
        ArgCheck.checkNotNull(filler, "filler");
        if (filler.getEvalType() != null) {
            if (filler.getEvalType() == CreateOnDemand.get() && propertyExpression.getEvalType() == CreateOnDemand.get()) {
                this.getErrorListener().incompatibleSymbols(parentExpression, propertyExpression, filler);
            }
            if (filler.getEvalType() == CreateOnDemand.get()) {
                this.enforceType(propertyExpression, OWLType.OWL_OBJECT_PROPERTY);
            } else {
                filler.getEvalType().accept(new TypeVistorAdapter(){

                    @Override
                    public void visitOWLType(OWLType owlType) {
                        if (OWLType.isClassExpression(owlType)) {
                            DefaultTypeEnforcer.this.enforceType(propertyExpression, OWLType.OWL_OBJECT_PROPERTY);
                        }
                        if (owlType == OWLType.OWL_DATA_TYPE) {
                            DefaultTypeEnforcer.this.enforceType(propertyExpression, OWLType.OWL_DATA_PROPERTY);
                        }
                    }
                });
            }
        }
    }

    @Override
    public void enforceConjunctionTypes(ManchesterOWLSyntaxTree parentExpression, ManchesterOWLSyntaxTree ... conjuncts) {
        this.enforceNaryClassExpressionTypes(conjuncts);
    }

    private void enforceNaryClassExpressionTypes(ManchesterOWLSyntaxTree ... classExpressions) {
        for (ManchesterOWLSyntaxTree classExpression : classExpressions) {
            this.enforceType(classExpression, OWLType.OWL_CLASS);
        }
    }

    @Override
    public void enforceDifferentIndividualsAxiomTypes(ManchesterOWLSyntaxTree parentExpression, OPPLSyntaxTree anIndividual, OPPLSyntaxTree anotherIndividual) {
        this.enforceBinaryIndividualAxiomType(anIndividual, anotherIndividual);
    }

    private void enforceBinaryIndividualAxiomType(OPPLSyntaxTree anIndividual, OPPLSyntaxTree anotherIndividual) {
        this.enforceType((ManchesterOWLSyntaxTree)anIndividual, OWLType.OWL_INDIVIDUAL);
        this.enforceType((ManchesterOWLSyntaxTree)anotherIndividual, OWLType.OWL_INDIVIDUAL);
    }

    @Override
    public void enforceDisjointWithAxiomTypes(ManchesterOWLSyntaxTree parentExpression, ManchesterOWLSyntaxTree lhs, ManchesterOWLSyntaxTree rhs) {
        this.enforceBinaryAxiomTypes(ArgCheck.checkNotNull(parentExpression, "parentExpression"), ArgCheck.checkNotNull(lhs, "lhs"), ArgCheck.checkNotNull(rhs, "rhs"));
    }

    private void enforceBinaryAxiomTypes(ManchesterOWLSyntaxTree parentExpression, ManchesterOWLSyntaxTree lhs, ManchesterOWLSyntaxTree rhs) {
        ArgCheck.checkNotNull(parentExpression, "parentExpression");
        ArgCheck.checkNotNull(lhs, "lhs");
        ArgCheck.checkNotNull(rhs, "rhs");
        if (lhs.getEvalType() == CreateOnDemand.get() && rhs.getEvalType() == CreateOnDemand.get()) {
            this.getErrorListener().incompatibleSymbols(parentExpression, lhs, rhs);
        } else {
            if (rhs.getEvalType() == CreateOnDemand.get()) {
                this.enforceType(lhs, rhs);
            }
            if (lhs.getEvalType() == CreateOnDemand.get()) {
                this.enforceType(rhs, lhs);
            }
        }
    }

    private void enforceType(ManchesterOWLSyntaxTree from, ManchesterOWLSyntaxTree to) {
        ArgCheck.checkNotNull(from, "from");
        ArgCheck.checkNotNull(to, "to");
        if (OWLType.isObjectPropertyExpression(from.getEvalType())) {
            this.enforceType(to, OWLType.OWL_OBJECT_PROPERTY);
        }
        if (OWLType.isClassExpression(from.getEvalType())) {
            this.enforceType(to, OWLType.OWL_CLASS);
        }
        if (OWLType.OWL_DATA_PROPERTY == from.getEvalType()) {
            this.enforceType(to, OWLType.OWL_DATA_PROPERTY);
        }
    }

    @Override
    public void enforceDisjunctionTypes(ManchesterOWLSyntaxTree parentExpression, ManchesterOWLSyntaxTree ... disjuncts) {
        this.enforceNaryClassExpressionTypes(disjuncts);
    }

    @Override
    public void enforceDomainAxiomTypes(ManchesterOWLSyntaxTree parentExpression, OPPLSyntaxTree p, ManchesterOWLSyntaxTree classDescription) {
        ArgCheck.checkNotNull(parentExpression, "parentExpression");
        ArgCheck.checkNotNull(p, "p");
        ArgCheck.checkNotNull(classDescription, "classDescription");
        if (p.getEvalType() == CreateOnDemand.get()) {
            this.getErrorListener().illegalToken(p, "Cannot decide whether " + p.getText() + " is a data or an object type property");
        } else {
            this.enforceType(classDescription, OWLType.OWL_CLASS);
        }
    }

    @Override
    public void enforceEquivalentToAxiomTypes(ManchesterOWLSyntaxTree parentExpression, ManchesterOWLSyntaxTree lhs, ManchesterOWLSyntaxTree rhs) {
        this.enforceBinaryAxiomTypes(ArgCheck.checkNotNull(parentExpression, "parentExpression"), ArgCheck.checkNotNull(lhs, "lhs"), ArgCheck.checkNotNull(rhs, "rhs"));
    }

    @Override
    public void enforceExactCardinalityRestrictionTypes(ManchesterOWLSyntaxTree parentExpression, ManchesterOWLSyntaxTree propertyExpression, ManchesterOWLSyntaxTree filler) {
        this.enforceCardinalityRestrictionTypes(parentExpression, propertyExpression, filler);
    }

    private void enforceCardinalityRestrictionTypes(ManchesterOWLSyntaxTree parentExpression, ManchesterOWLSyntaxTree propertyExpression, ManchesterOWLSyntaxTree filler) {
        ArgCheck.checkNotNull(parentExpression, "parentExpression");
        ArgCheck.checkNotNull(propertyExpression, "propertyExpression");
        if (filler == null) {
            if (propertyExpression.getEvalType() == CreateOnDemand.get()) {
                this.getErrorListener().illegalToken(propertyExpression, "Cannot decide whether " + propertyExpression.getText() + " is a data or an object property");
            }
        } else if (filler.getEvalType() == CreateOnDemand.get() && propertyExpression.getEvalType() == CreateOnDemand.get()) {
            this.getErrorListener().incompatibleSymbols(parentExpression, propertyExpression, filler);
        } else if (propertyExpression.getEvalType() == CreateOnDemand.get()) {
            this.enforceType(propertyExpression, OWLType.OWL_OBJECT_PROPERTY);
        } else if (filler.getEvalType() == CreateOnDemand.get()) {
            this.enforceType(filler, OWLType.OWL_CLASS);
        }
    }

    @Override
    public void enforceFunctionalPropertyAxiomTypes(ManchesterOWLSyntaxTree parentExpression, OPPLSyntaxTree p) {
        this.enforceType((ManchesterOWLSyntaxTree)p, OWLType.OWL_OBJECT_PROPERTY);
    }

    @Override
    public void enforceInverseFunctionalPropertyAxiomTypes(ManchesterOWLSyntaxTree parentExpression, OPPLSyntaxTree p) {
        this.enforceType((ManchesterOWLSyntaxTree)p, OWLType.OWL_OBJECT_PROPERTY);
    }

    @Override
    public void enforceInverseObjectPropertyTypes(ManchesterOWLSyntaxTree parentExpression, ManchesterOWLSyntaxTree p) {
        this.enforceType(p, OWLType.OWL_OBJECT_PROPERTY);
    }

    @Override
    public void enforceIrreflexivePropertyAxiomTypes(ManchesterOWLSyntaxTree parentExpression, OPPLSyntaxTree p) {
        this.enforceType((ManchesterOWLSyntaxTree)p, OWLType.OWL_OBJECT_PROPERTY);
    }

    @Override
    public void enforceIverserOfAxiomTypes(ManchesterOWLSyntaxTree parentExpression, OPPLSyntaxTree p, OPPLSyntaxTree anotherProperty) {
        this.enforceBinaryAxiomTypes(parentExpression, p, anotherProperty);
    }

    @Override
    public void enforceMaxCardinalityRestrictionTypes(ManchesterOWLSyntaxTree parentExpression, ManchesterOWLSyntaxTree propertyExpression, ManchesterOWLSyntaxTree filler) {
        this.enforceCardinalityRestrictionTypes(parentExpression, propertyExpression, filler);
    }

    @Override
    public void enforceMinCardinalityRestrictionTypes(ManchesterOWLSyntaxTree parentExpression, ManchesterOWLSyntaxTree propertyExpression, ManchesterOWLSyntaxTree filler) {
        this.enforceCardinalityRestrictionTypes(parentExpression, propertyExpression, filler);
    }

    @Override
    public void enforceNegatedAssertionTypes(ManchesterOWLSyntaxTree parentExpression, ManchesterOWLSyntaxTree assertion) {
    }

    @Override
    public void enforceNegatedClassExpression(ManchesterOWLSyntaxTree parentExpression, ManchesterOWLSyntaxTree classExpression) {
    }

    @Override
    public void enforceOneOfTypes(ManchesterOWLSyntaxTree parentExpression, ManchesterOWLSyntaxTree ... individuals) {
        ArgCheck.checkNotNull(individuals, "individuals");
        for (ManchesterOWLSyntaxTree individual : individuals) {
            this.enforceType(individual, OWLType.OWL_INDIVIDUAL);
        }
    }

    protected void enforceType(ManchesterOWLSyntaxTree t, OWLType type) {
        ArgCheck.checkNotNull(t, "t");
        ArgCheck.checkNotNull(type, "type");
        String name = t.getToken().getText();
        if (t.getEvalType() == CreateOnDemand.get()) {
            OWLClass entity = null;
            String newEntityName = name.replace("!", "");
            switch (type) {
                case OWL_CLASS: {
                    try {
                        entity = this.getOWLEntityFactory().createOWLClass(newEntityName, null).getOWLEntity();
                    }
                    catch (OWLEntityCreationException e) {
                        this.errorListener.illegalToken(t, "Unable to create an OWL Class for " + name + " because of " + e.getMessage());
                    }
                    break;
                }
                case OWL_OBJECT_PROPERTY: {
                    try {
                        entity = this.getOWLEntityFactory().createOWLObjectProperty(newEntityName, null).getOWLEntity();
                    }
                    catch (OWLEntityCreationException e) {
                        this.errorListener.illegalToken(t, "Unable to create an OWL Object property for " + name + " because of " + e.getMessage());
                    }
                    break;
                }
                case OWL_DATA_PROPERTY: {
                    try {
                        entity = this.getOWLEntityFactory().createOWLDataProperty(newEntityName, null).getOWLEntity();
                    }
                    catch (OWLEntityCreationException e) {
                        this.errorListener.illegalToken(t, "Unable to create an OWL Data property for " + name + " because of " + e.getMessage());
                    }
                    break;
                }
                case OWL_INDIVIDUAL: {
                    try {
                        entity = this.getOWLEntityFactory().createOWLIndividual(newEntityName, null).getOWLEntity();
                    }
                    catch (OWLEntityCreationException e) {
                        this.errorListener.illegalToken(t, "Unable to create an OWL Individual for " + name + " because of " + e.getMessage());
                    }
                    break;
                }
            }
            if (entity != null) {
                this.getSymbolTable().define(t.getToken(), new OWLEntitySymbol(name, (OWLEntity)entity));
            }
        }
    }

    @Override
    public void enforcePropertyChainTypes(ManchesterOWLSyntaxTree parentExpression, ManchesterOWLSyntaxTree ... propertyExpressions) {
        ArgCheck.checkNotNull(parentExpression, "parentExpression");
        ArgCheck.checkNotNull(propertyExpressions, "propertyExpressions");
        for (ManchesterOWLSyntaxTree propertyExpression : propertyExpressions) {
            this.enforceType(propertyExpression, OWLType.OWL_OBJECT_PROPERTY);
        }
    }

    @Override
    public void enforceRangeAxiomTypes(ManchesterOWLSyntaxTree parentExpression, final OPPLSyntaxTree p, ManchesterOWLSyntaxTree range) {
        ArgCheck.checkNotNull(parentExpression, "parentExpression");
        ArgCheck.checkNotNull(p, "p");
        ArgCheck.checkNotNull(range, "range");
        Type evalType = range.getEvalType();
        if (evalType == CreateOnDemand.get()) {
            this.enforceType((ManchesterOWLSyntaxTree)p, OWLType.OWL_OBJECT_PROPERTY);
        } else if (evalType != null) {
            evalType.accept(new TypeVistorAdapter(){

                @Override
                public void visitOWLType(OWLType owlType) {
                    if (OWLType.isClassExpression(owlType)) {
                        DefaultTypeEnforcer.this.enforceType((ManchesterOWLSyntaxTree)p, OWLType.OWL_OBJECT_PROPERTY);
                    }
                    if (owlType == OWLType.OWL_DATA_TYPE) {
                        DefaultTypeEnforcer.this.enforceType((ManchesterOWLSyntaxTree)p, OWLType.OWL_DATA_PROPERTY);
                    }
                }
            });
        }
    }

    @Override
    public void enforceReflexivePropertyAxiomTypes(ManchesterOWLSyntaxTree parentExpression, OPPLSyntaxTree p) {
        this.enforceType((ManchesterOWLSyntaxTree)p, OWLType.OWL_OBJECT_PROPERTY);
    }

    @Override
    public void enforceRoleAssertionAxiomTypes(ManchesterOWLSyntaxTree parentExpression, OPPLSyntaxTree subject, ManchesterOWLSyntaxTree property, ManchesterOWLSyntaxTree object) {
        this.enforceType((ManchesterOWLSyntaxTree)subject, OWLType.OWL_INDIVIDUAL);
        if (object.getEvalType() == CreateOnDemand.get()) {
            this.enforceType(object, OWLType.OWL_INDIVIDUAL);
            this.enforceType(property, OWLType.OWL_OBJECT_PROPERTY);
        } else if (object.getEvalType() == OWLType.OWL_INDIVIDUAL) {
            this.enforceType(property, OWLType.OWL_OBJECT_PROPERTY);
        } else if (object.getEvalType() == OWLType.OWL_CONSTANT) {
            this.enforceType(property, OWLType.OWL_DATA_PROPERTY);
        }
    }

    @Override
    public void enforceSameIndividualsAxiomTypes(ManchesterOWLSyntaxTree parentExpression, OPPLSyntaxTree anIndividual, OPPLSyntaxTree anotherIndividual) {
        this.enforceBinaryIndividualAxiomType(anIndividual, anotherIndividual);
    }

    @Override
    public void enforceSomeValueRestrictionTypes(ManchesterOWLSyntaxTree parentExpression, ManchesterOWLSyntaxTree propertyExpression, ManchesterOWLSyntaxTree filler) {
        this.enforceQualifiedRestrictionTypes(parentExpression, propertyExpression, filler);
    }

    @Override
    public void enforceSubClassOfAxiomTypes(ManchesterOWLSyntaxTree parentExpression, ManchesterOWLSyntaxTree subClass, ManchesterOWLSyntaxTree superClass) {
        this.enforceBinaryAxiomTypes(parentExpression, subClass, superClass);
    }

    @Override
    public void enforceSubPropertyAxiomTypes(ManchesterOWLSyntaxTree parentExpression, ManchesterOWLSyntaxTree aProperty, ManchesterOWLSyntaxTree anotherProperty) {
        this.enforceBinaryAxiomTypes(ArgCheck.checkNotNull(parentExpression, "parentExpression"), ArgCheck.checkNotNull(aProperty, "aProperty"), ArgCheck.checkNotNull(anotherProperty, "anotherProperty"));
    }

    @Override
    public void enforceSymmetricPropertyAxiomTypes(ManchesterOWLSyntaxTree parentExpression, OPPLSyntaxTree p) {
        this.enforceType((ManchesterOWLSyntaxTree)p, OWLType.OWL_OBJECT_PROPERTY);
    }

    @Override
    public void enforceTransitivePropertyAxiomTypes(ManchesterOWLSyntaxTree parentExpression, OPPLSyntaxTree p) {
        this.enforceType((ManchesterOWLSyntaxTree)p, OWLType.OWL_OBJECT_PROPERTY);
    }

    @Override
    public void enforceTypeAssertionAxiomTypes(ManchesterOWLSyntaxTree parentExpression, ManchesterOWLSyntaxTree classDescription, OPPLSyntaxTree subject) {
        ArgCheck.checkNotNull(parentExpression, "parentExpression");
        this.enforceType((ManchesterOWLSyntaxTree)ArgCheck.checkNotNull(subject, "subject"), OWLType.OWL_INDIVIDUAL);
        this.enforceType(ArgCheck.checkNotNull(classDescription, "classDescription"), OWLType.OWL_CLASS);
    }

    @Override
    public void enforceValueRestrictionTypes(ManchesterOWLSyntaxTree parentExpression, final ManchesterOWLSyntaxTree propertyExpression, ManchesterOWLSyntaxTree value) {
        ArgCheck.checkNotNull(parentExpression, "parentExpression");
        ArgCheck.checkNotNull(propertyExpression, "propertyExpression");
        ArgCheck.checkNotNull(value, "value");
        if (value.getEvalType() == CreateOnDemand.get() && propertyExpression.getEvalType() == CreateOnDemand.get()) {
            this.getErrorListener().incompatibleSymbols(parentExpression, propertyExpression, value);
        } else if (value.getEvalType() == CreateOnDemand.get()) {
            this.enforceType(propertyExpression, OWLType.OWL_OBJECT_PROPERTY);
        } else {
            value.getEvalType().accept(new TypeVistorAdapter(){

                @Override
                public void visitOWLType(OWLType owlType) {
                    if (OWLType.isClassExpression(owlType)) {
                        DefaultTypeEnforcer.this.enforceType(propertyExpression, OWLType.OWL_OBJECT_PROPERTY);
                    }
                    if (owlType == OWLType.OWL_DATA_TYPE) {
                        DefaultTypeEnforcer.this.enforceType(propertyExpression, OWLType.OWL_DATA_PROPERTY);
                    }
                }
            });
        }
    }

    public OPPLSymbolTable getSymbolTable() {
        return this.symbolTable;
    }

    public OWLEntityFactory getOWLEntityFactory() {
        return this.entityFactory;
    }

    public ErrorListener getErrorListener() {
        return this.errorListener;
    }
}

