/*
 * Decompiled with CFR 0.152.
 */
package org.coode.parsers;

import org.coode.oppl.utils.ArgCheck;
import org.coode.parsers.OWLType;
import org.coode.parsers.Symbol;
import org.coode.parsers.SymbolVisitor;
import org.coode.parsers.SymbolVisitorEx;
import org.semanticweb.owlapi.model.OWLEntity;

public class OWLEntitySymbol
extends Symbol {
    private final OWLEntity entity;

    public OWLEntitySymbol(String name, OWLEntity entity) {
        super(name, OWLType.get(entity));
        this.entity = ArgCheck.checkNotNull(entity, "entity");
    }

    public OWLEntity getEntity() {
        return this.entity;
    }

    @Override
    public void accept(SymbolVisitor visitor) {
        visitor.visitOWLEntity(this);
    }

    @Override
    public <O> O accept(SymbolVisitorEx<O> visitor) {
        return visitor.visitOWLEntity(this);
    }

    public String toString() {
        return "Symbol name: " + this.getName() + " OWL Entity " + this.getEntity().toString();
    }
}

