/*
 * Decompiled with CFR 0.152.
 */
package org.coode.oppl.utils;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.coode.oppl.utils.ArgCheck;
import org.coode.oppl.utils.OWLPrimitiveSelector;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLAnnotationAssertionAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLAsymmetricObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLCardinalityRestriction;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassAssertionAxiom;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataAllValuesFrom;
import org.semanticweb.owlapi.model.OWLDataComplementOf;
import org.semanticweb.owlapi.model.OWLDataExactCardinality;
import org.semanticweb.owlapi.model.OWLDataHasValue;
import org.semanticweb.owlapi.model.OWLDataMaxCardinality;
import org.semanticweb.owlapi.model.OWLDataMinCardinality;
import org.semanticweb.owlapi.model.OWLDataOneOf;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDataPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLDataPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLDataPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLDataSomeValuesFrom;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLDeclarationAxiom;
import org.semanticweb.owlapi.model.OWLDifferentIndividualsAxiom;
import org.semanticweb.owlapi.model.OWLDisjointClassesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointDataPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointUnionAxiom;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLEquivalentClassesAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentDataPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLFunctionalDataPropertyAxiom;
import org.semanticweb.owlapi.model.OWLFunctionalObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLHasValueRestriction;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLInverseFunctionalObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLInverseObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLIrreflexiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLNaryBooleanClassExpression;
import org.semanticweb.owlapi.model.OWLNaryClassAxiom;
import org.semanticweb.owlapi.model.OWLNaryIndividualAxiom;
import org.semanticweb.owlapi.model.OWLNaryPropertyAxiom;
import org.semanticweb.owlapi.model.OWLNegativeDataPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLNegativeObjectPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLObjectAllValuesFrom;
import org.semanticweb.owlapi.model.OWLObjectComplementOf;
import org.semanticweb.owlapi.model.OWLObjectExactCardinality;
import org.semanticweb.owlapi.model.OWLObjectHasSelf;
import org.semanticweb.owlapi.model.OWLObjectHasValue;
import org.semanticweb.owlapi.model.OWLObjectIntersectionOf;
import org.semanticweb.owlapi.model.OWLObjectInverseOf;
import org.semanticweb.owlapi.model.OWLObjectMaxCardinality;
import org.semanticweb.owlapi.model.OWLObjectMinCardinality;
import org.semanticweb.owlapi.model.OWLObjectOneOf;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLObjectPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLObjectPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLObjectSomeValuesFrom;
import org.semanticweb.owlapi.model.OWLObjectUnionOf;
import org.semanticweb.owlapi.model.OWLObjectVisitorEx;
import org.semanticweb.owlapi.model.OWLPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLQuantifiedRestriction;
import org.semanticweb.owlapi.model.OWLReflexiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLSameIndividualAxiom;
import org.semanticweb.owlapi.model.OWLSubClassOfAxiom;
import org.semanticweb.owlapi.model.OWLSubDataPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubObjectPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubPropertyAxiom;
import org.semanticweb.owlapi.model.OWLSubPropertyChainOfAxiom;
import org.semanticweb.owlapi.model.OWLSymmetricObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLTransitiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLUnaryPropertyAxiom;
import org.semanticweb.owlapi.model.SWRLRule;
import org.semanticweb.owlapi.util.OWLObjectVisitorExAdapter;

public final class OWLObjectExtractor<O extends OWLObject>
extends OWLObjectVisitorExAdapter<Set<O>>
implements OWLObjectVisitorEx<Set<O>> {
    private final OWLObjectVisitorEx<Boolean> selector;

    private OWLObjectExtractor(OWLObjectVisitorEx<Boolean> selector) {
        super(Collections.emptySet());
        this.selector = ArgCheck.checkNotNull(selector, "selector");
    }

    public Set<O> visit(OWLDeclarationAxiom axiom) {
        return this.visitPrimitive((OWLObject)axiom.getEntity());
    }

    public Set<O> visit(OWLAnnotationAssertionAxiom axiom) {
        HashSet toReturn = new HashSet();
        toReturn.addAll((Collection)axiom.getSubject().accept((OWLObjectVisitorEx)this));
        toReturn.addAll((Collection)axiom.getAnnotation().accept((OWLObjectVisitorEx)this));
        return toReturn;
    }

    public Set<O> visit(OWLAnnotation annotation) {
        HashSet toReturn = new HashSet();
        toReturn.addAll((Collection)annotation.getProperty().accept((OWLObjectVisitorEx)this));
        toReturn.addAll((Collection)annotation.getValue().accept((OWLObjectVisitorEx)this));
        return toReturn;
    }

    public Set<O> visit(OWLSubClassOfAxiom axiom) {
        HashSet toReturn = new HashSet();
        toReturn.addAll((Collection)axiom.getSubClass().accept((OWLObjectVisitorEx)this));
        toReturn.addAll((Collection)axiom.getSuperClass().accept((OWLObjectVisitorEx)this));
        return toReturn;
    }

    public Set<O> visit(OWLNegativeObjectPropertyAssertionAxiom axiom) {
        return this.visitOWLPropertyAssertionAxiom((OWLPropertyAssertionAxiom<?, ?>)axiom);
    }

    private Set<O> visitOWLPropertyAssertionAxiom(OWLPropertyAssertionAxiom<?, ?> axiom) {
        HashSet toReturn = new HashSet();
        toReturn.addAll((Collection)axiom.getProperty().accept((OWLObjectVisitorEx)this));
        toReturn.addAll((Collection)axiom.getSubject().accept((OWLObjectVisitorEx)this));
        toReturn.addAll((Collection)axiom.getObject().accept((OWLObjectVisitorEx)this));
        return toReturn;
    }

    public Set<O> visit(OWLAsymmetricObjectPropertyAxiom axiom) {
        return this.visitCharacteristicAxiom((OWLUnaryPropertyAxiom<?>)axiom);
    }

    private Set<O> visitCharacteristicAxiom(OWLUnaryPropertyAxiom<?> axiom) {
        return (Set)axiom.getProperty().accept((OWLObjectVisitorEx)this);
    }

    public Set<O> visit(OWLReflexiveObjectPropertyAxiom axiom) {
        return this.visitCharacteristicAxiom((OWLUnaryPropertyAxiom<?>)axiom);
    }

    public Set<O> visit(OWLDisjointClassesAxiom axiom) {
        return this.visitOWLNAryClassAxiom((OWLNaryClassAxiom)axiom);
    }

    private Set<O> visitOWLNAryClassAxiom(OWLNaryClassAxiom axiom) {
        HashSet toReturn = new HashSet();
        for (OWLClassExpression owlDescription : axiom.getClassExpressions()) {
            toReturn.addAll((Collection)owlDescription.accept((OWLObjectVisitorEx)this));
        }
        return toReturn;
    }

    public Set<O> visit(OWLDataPropertyDomainAxiom axiom) {
        return this.visitOWLPropertyDomainAxiom((OWLPropertyDomainAxiom<?>)axiom);
    }

    private Set<O> visitOWLPropertyDomainAxiom(OWLPropertyDomainAxiom<?> axiom) {
        HashSet toReturn = new HashSet();
        toReturn.addAll((Collection)axiom.getProperty().accept((OWLObjectVisitorEx)this));
        toReturn.addAll((Collection)axiom.getDomain().accept((OWLObjectVisitorEx)this));
        return toReturn;
    }

    public Set<O> visit(OWLObjectPropertyDomainAxiom axiom) {
        return this.visitOWLPropertyDomainAxiom((OWLPropertyDomainAxiom<?>)axiom);
    }

    public Set<O> visit(OWLEquivalentObjectPropertiesAxiom axiom) {
        return this.visitOWLNaryPropertyAxiom((OWLNaryPropertyAxiom<?>)axiom);
    }

    private Set<O> visitOWLNaryPropertyAxiom(OWLNaryPropertyAxiom<?> axiom) {
        HashSet toReturn = new HashSet();
        for (OWLObject p : axiom.getProperties()) {
            toReturn.addAll((Collection)p.accept((OWLObjectVisitorEx)this));
        }
        return toReturn;
    }

    public Set<O> visit(OWLNegativeDataPropertyAssertionAxiom axiom) {
        return this.visitOWLPropertyAssertionAxiom((OWLPropertyAssertionAxiom<?, ?>)axiom);
    }

    public Set<O> visit(OWLDifferentIndividualsAxiom axiom) {
        return this.visitOWLNaryIndividualAxiom((OWLNaryIndividualAxiom)axiom);
    }

    private Set<O> visitOWLNaryIndividualAxiom(OWLNaryIndividualAxiom axiom) {
        HashSet toReturn = new HashSet();
        for (OWLIndividual individual : axiom.getIndividuals()) {
            toReturn.addAll((Collection)individual.accept((OWLObjectVisitorEx)this));
        }
        return toReturn;
    }

    public Set<O> visit(OWLDisjointDataPropertiesAxiom axiom) {
        return this.visitOWLNaryPropertyAxiom((OWLNaryPropertyAxiom<?>)axiom);
    }

    public Set<O> visit(OWLDisjointObjectPropertiesAxiom axiom) {
        return this.visitOWLNaryPropertyAxiom((OWLNaryPropertyAxiom<?>)axiom);
    }

    public Set<O> visit(OWLObjectPropertyRangeAxiom axiom) {
        return this.visitOWLPropertyRangeAxiom((OWLPropertyRangeAxiom<?, ?>)axiom);
    }

    private Set<O> visitOWLPropertyRangeAxiom(OWLPropertyRangeAxiom<?, ?> axiom) {
        HashSet toReturn = new HashSet();
        toReturn.addAll((Collection)axiom.getProperty().accept((OWLObjectVisitorEx)this));
        toReturn.addAll((Collection)axiom.getRange().accept((OWLObjectVisitorEx)this));
        return toReturn;
    }

    public Set<O> visit(OWLObjectPropertyAssertionAxiom axiom) {
        return this.visitOWLPropertyAssertionAxiom((OWLPropertyAssertionAxiom<?, ?>)axiom);
    }

    public Set<O> visit(OWLFunctionalObjectPropertyAxiom axiom) {
        return this.visitCharacteristicAxiom((OWLUnaryPropertyAxiom<?>)axiom);
    }

    public Set<O> visit(OWLSubObjectPropertyOfAxiom axiom) {
        return this.visitOWLSubPropertyAxiom((OWLSubPropertyAxiom<?>)axiom);
    }

    private Set<O> visitOWLSubPropertyAxiom(OWLSubPropertyAxiom<?> axiom) {
        HashSet toReturn = new HashSet();
        toReturn.addAll((Collection)axiom.getSubProperty().accept((OWLObjectVisitorEx)this));
        toReturn.addAll((Collection)axiom.getSuperProperty().accept((OWLObjectVisitorEx)this));
        return toReturn;
    }

    public Set<O> visit(OWLDisjointUnionAxiom axiom) {
        HashSet toReturn = new HashSet();
        for (OWLClassExpression owlDescription : axiom.getClassExpressions()) {
            toReturn.addAll((Collection)owlDescription.accept((OWLObjectVisitorEx)this));
        }
        return toReturn;
    }

    public Set<O> visit(OWLSymmetricObjectPropertyAxiom axiom) {
        return this.visitCharacteristicAxiom((OWLUnaryPropertyAxiom<?>)axiom);
    }

    public Set<O> visit(OWLDataPropertyRangeAxiom axiom) {
        return this.visitOWLPropertyRangeAxiom((OWLPropertyRangeAxiom<?, ?>)axiom);
    }

    public Set<O> visit(OWLFunctionalDataPropertyAxiom axiom) {
        return this.visitCharacteristicAxiom((OWLUnaryPropertyAxiom<?>)axiom);
    }

    public Set<O> visit(OWLEquivalentDataPropertiesAxiom axiom) {
        return this.visitOWLNaryPropertyAxiom((OWLNaryPropertyAxiom<?>)axiom);
    }

    public Set<O> visit(OWLClassAssertionAxiom axiom) {
        HashSet toReturn = new HashSet();
        toReturn.addAll((Collection)axiom.getClassExpression().accept((OWLObjectVisitorEx)this));
        toReturn.addAll((Collection)axiom.getIndividual().accept((OWLObjectVisitorEx)this));
        return toReturn;
    }

    public Set<O> visit(OWLEquivalentClassesAxiom axiom) {
        return this.visitOWLNAryClassAxiom((OWLNaryClassAxiom)axiom);
    }

    public Set<O> visit(OWLDataPropertyAssertionAxiom axiom) {
        return this.visitOWLPropertyAssertionAxiom((OWLPropertyAssertionAxiom<?, ?>)axiom);
    }

    public Set<O> visit(OWLTransitiveObjectPropertyAxiom axiom) {
        return this.visitCharacteristicAxiom((OWLUnaryPropertyAxiom<?>)axiom);
    }

    public Set<O> visit(OWLIrreflexiveObjectPropertyAxiom axiom) {
        return this.visitCharacteristicAxiom((OWLUnaryPropertyAxiom<?>)axiom);
    }

    public Set<O> visit(OWLSubDataPropertyOfAxiom axiom) {
        return this.visitOWLSubPropertyAxiom((OWLSubPropertyAxiom<?>)axiom);
    }

    public Set<O> visit(OWLInverseFunctionalObjectPropertyAxiom axiom) {
        return this.visitCharacteristicAxiom((OWLUnaryPropertyAxiom<?>)axiom);
    }

    public Set<O> visit(OWLSameIndividualAxiom axiom) {
        return this.visitOWLNaryIndividualAxiom((OWLNaryIndividualAxiom)axiom);
    }

    public Set<O> visit(OWLSubPropertyChainOfAxiom axiom) {
        HashSet toReturn = new HashSet();
        toReturn.addAll((Collection)axiom.getSuperProperty().accept((OWLObjectVisitorEx)this));
        for (OWLObject owlObject : axiom.getPropertyChain()) {
            toReturn.addAll((Collection)owlObject.accept((OWLObjectVisitorEx)this));
        }
        return toReturn;
    }

    public Set<O> visit(OWLInverseObjectPropertiesAxiom axiom) {
        return this.visitOWLNaryPropertyAxiom((OWLNaryPropertyAxiom<?>)axiom);
    }

    public Set<O> visit(SWRLRule rule) {
        return Collections.emptySet();
    }

    public Set<O> visit(OWLClass desc) {
        return this.visitPrimitive((OWLObject)desc);
    }

    public Set<O> visit(OWLAnnotationProperty property) {
        return this.visitPrimitive((OWLObject)property);
    }

    private Set<O> visitPrimitive(OWLObject owlObject) {
        HashSet<OWLObject> toReturn = new HashSet<OWLObject>();
        if (((Boolean)owlObject.accept(this.getSelector())).booleanValue()) {
            toReturn.add(owlObject);
        }
        return toReturn;
    }

    public Set<O> visit(OWLObjectIntersectionOf desc) {
        return this.visitOWLNaryBooleanExpression((OWLNaryBooleanClassExpression)desc);
    }

    private Set<O> visitOWLNaryBooleanExpression(OWLNaryBooleanClassExpression desc) {
        HashSet toReturn = new HashSet();
        for (OWLObject owlObject : desc.getOperands()) {
            toReturn.addAll((Collection)owlObject.accept((OWLObjectVisitorEx)this));
        }
        return toReturn;
    }

    public Set<O> visit(OWLObjectUnionOf desc) {
        return this.visitOWLNaryBooleanExpression((OWLNaryBooleanClassExpression)desc);
    }

    public Set<O> visit(OWLObjectComplementOf desc) {
        return (Set)desc.getOperand().accept((OWLObjectVisitorEx)this);
    }

    public Set<O> visit(OWLObjectSomeValuesFrom desc) {
        return this.visitOWLQuantifiedRestriction((OWLQuantifiedRestriction<?, ?, ?>)desc);
    }

    private Set<O> visitOWLQuantifiedRestriction(OWLQuantifiedRestriction<?, ?, ?> desc) {
        HashSet toReturn = new HashSet();
        toReturn.addAll((Collection)desc.getProperty().accept((OWLObjectVisitorEx)this));
        toReturn.addAll((Collection)desc.getFiller().accept((OWLObjectVisitorEx)this));
        return toReturn;
    }

    public Set<O> visit(OWLObjectAllValuesFrom desc) {
        return this.visitOWLQuantifiedRestriction((OWLQuantifiedRestriction<?, ?, ?>)desc);
    }

    public Set<O> visit(OWLObjectHasValue desc) {
        return this.visitOWLValueRestriction((OWLHasValueRestriction<?, ?, ?>)desc);
    }

    private Set<O> visitOWLValueRestriction(OWLHasValueRestriction<?, ?, ?> desc) {
        HashSet toReturn = new HashSet();
        toReturn.addAll((Collection)desc.getProperty().accept((OWLObjectVisitorEx)this));
        toReturn.addAll((Collection)desc.getValue().accept((OWLObjectVisitorEx)this));
        return toReturn;
    }

    public Set<O> visit(OWLObjectMinCardinality desc) {
        return this.visitOWLCardinalityRestriction((OWLCardinalityRestriction<?, ?, ?>)desc);
    }

    public Set<O> visit(OWLObjectExactCardinality desc) {
        return this.visitOWLCardinalityRestriction((OWLCardinalityRestriction<?, ?, ?>)desc);
    }

    public Set<O> visit(OWLObjectMaxCardinality desc) {
        return this.visitOWLCardinalityRestriction((OWLCardinalityRestriction<?, ?, ?>)desc);
    }

    private Set<O> visitOWLCardinalityRestriction(OWLCardinalityRestriction<?, ?, ?> desc) {
        HashSet toReturn = new HashSet();
        toReturn.addAll((Collection)desc.getProperty().accept((OWLObjectVisitorEx)this));
        if (desc.getFiller() != null) {
            toReturn.addAll((Collection)desc.getFiller().accept((OWLObjectVisitorEx)this));
        }
        return toReturn;
    }

    public Set<O> visit(OWLObjectHasSelf desc) {
        return (Set)((OWLObjectPropertyExpression)desc.getProperty()).accept((OWLObjectVisitorEx)this);
    }

    public Set<O> visit(OWLObjectOneOf desc) {
        HashSet toReturn = new HashSet();
        for (OWLObject owlObject : desc.getIndividuals()) {
            toReturn.addAll((Collection)owlObject.accept((OWLObjectVisitorEx)this));
        }
        return toReturn;
    }

    public Set<O> visit(OWLDataSomeValuesFrom desc) {
        return this.visitOWLQuantifiedRestriction((OWLQuantifiedRestriction<?, ?, ?>)desc);
    }

    public Set<O> visit(OWLDataAllValuesFrom desc) {
        return this.visitOWLQuantifiedRestriction((OWLQuantifiedRestriction<?, ?, ?>)desc);
    }

    public Set<O> visit(OWLDataHasValue desc) {
        return this.visitOWLValueRestriction((OWLHasValueRestriction<?, ?, ?>)desc);
    }

    public Set<O> visit(OWLDataMinCardinality desc) {
        return this.visitOWLCardinalityRestriction((OWLCardinalityRestriction<?, ?, ?>)desc);
    }

    public Set<O> visit(OWLDataExactCardinality desc) {
        return this.visitOWLCardinalityRestriction((OWLCardinalityRestriction<?, ?, ?>)desc);
    }

    public Set<O> visit(OWLDataMaxCardinality desc) {
        return this.visitOWLCardinalityRestriction((OWLCardinalityRestriction<?, ?, ?>)desc);
    }

    public Set<O> visit(OWLDatatype node) {
        return this.visitPrimitive((OWLObject)node);
    }

    public Set<O> visit(OWLDataComplementOf node) {
        return (Set)node.getDataRange().accept((OWLObjectVisitorEx)this);
    }

    public Set<O> visit(OWLDataOneOf node) {
        HashSet toReturn = new HashSet();
        for (OWLObject owlObject : node.getValues()) {
            toReturn.addAll((Collection)owlObject.accept((OWLObjectVisitorEx)this));
        }
        return toReturn;
    }

    public Set<O> visit(OWLLiteral node) {
        return this.visitPrimitive((OWLObject)node);
    }

    public Set<O> visit(OWLObjectProperty property) {
        return this.visitPrimitive((OWLObject)property);
    }

    public Set<O> visit(OWLObjectInverseOf property) {
        return (Set)property.getInverse().accept((OWLObjectVisitorEx)this);
    }

    public Set<O> visit(OWLDataProperty property) {
        return this.visitPrimitive((OWLObject)property);
    }

    public Set<O> visit(OWLNamedIndividual individual) {
        return this.visitPrimitive((OWLObject)individual);
    }

    public OWLObjectVisitorEx<Boolean> getSelector() {
        return this.selector;
    }

    public static Set<OWLClass> getAllClasses(OWLObject owlObject) {
        return OWLObjectExtractor.getAll(owlObject, OWLPrimitiveSelector.getAllOWLClassSelector());
    }

    public static Set<OWLObjectProperty> getAllOWLObjectProperties(OWLObject owlObject) {
        return OWLObjectExtractor.getAll(owlObject, OWLPrimitiveSelector.getAllOWLObjectPropertySelector());
    }

    public static Set<OWLDataProperty> getAllOWLDataProperties(OWLObject owlObject) {
        return OWLObjectExtractor.getAll(owlObject, OWLPrimitiveSelector.getAllOWLDataPropertySelector());
    }

    public static Set<OWLNamedIndividual> getAllOWLIndividuals(OWLObject owlObject) {
        return OWLObjectExtractor.getAll(owlObject, OWLPrimitiveSelector.getAllOWLIndividualSelector());
    }

    public static Set<OWLDatatype> getAllOWLDatatypes(OWLObject owlObject) {
        return OWLObjectExtractor.getAll(owlObject, OWLPrimitiveSelector.getAllOWLDatatypeSelector());
    }

    public static Set<OWLLiteral> getAllOWLLiterals(OWLObject owlObject) {
        return OWLObjectExtractor.getAll(owlObject, OWLPrimitiveSelector.getAllOWLConstantSelector());
    }

    public static Set<OWLEntity> getAllOWLEntities(OWLObject owlObject) {
        return OWLObjectExtractor.getAll(owlObject, OWLPrimitiveSelector.getAllOWLEntitySelector());
    }

    public static Set<OWLObject> getAllOWLPrimitives(OWLObject owlObject) {
        return OWLObjectExtractor.getAll(owlObject, OWLPrimitiveSelector.getAllPrimitiveSelector());
    }

    public static Set<OWLAnnotationProperty> getAllAnnotationProperties(OWLObject owlObject) {
        return OWLObjectExtractor.getAll(owlObject, OWLPrimitiveSelector.getAllOWLAnnotationPropertySelector());
    }

    private static <T extends OWLObject> Set<T> getAll(OWLObject owlObject, OWLObjectVisitorEx<Boolean> extractor) {
        return (Set)owlObject.accept(new OWLObjectExtractor(extractor));
    }
}

