/*
 * Decompiled with CFR 0.152.
 */
package org.coode.oppl.queryplanner;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.coode.oppl.AbstractConstraint;
import org.coode.oppl.ConstraintSystem;
import org.coode.oppl.ExecutionMonitor;
import org.coode.oppl.bindingtree.BindingNode;
import org.coode.oppl.exceptions.RuntimeExceptionHandler;
import org.coode.oppl.function.SimpleValueComputationParameters;
import org.coode.oppl.querymatching.ConstraintChecker;
import org.coode.oppl.queryplanner.AbstractQueryPlannerItem;
import org.coode.oppl.queryplanner.QueryPlannerVisitor;
import org.coode.oppl.queryplanner.QueryPlannerVisitorEx;
import org.coode.oppl.utils.ArgCheck;

public class ConstraintQueryPlannerItem
extends AbstractQueryPlannerItem {
    private final AbstractConstraint constraint;

    public ConstraintQueryPlannerItem(ConstraintSystem constraintSystem, AbstractConstraint constraint) {
        super(constraintSystem);
        this.constraint = ArgCheck.checkNotNull(constraint, "constraint");
    }

    @Override
    public Set<BindingNode> match(Collection<? extends BindingNode> currentLeaves, ExecutionMonitor executionMonitor, RuntimeExceptionHandler runtimeExceptionHandler) {
        HashSet<BindingNode> toReturn = new HashSet<BindingNode>(currentLeaves.size());
        Iterator<? extends BindingNode> it = currentLeaves.iterator();
        while (!executionMonitor.isCancelled() && it.hasNext()) {
            BindingNode leaf = it.next();
            boolean holdingLeaf = this.checkConstraint(leaf, this.getConstraint(), runtimeExceptionHandler);
            if (holdingLeaf) continue;
            it.remove();
        }
        if (executionMonitor.isCancelled()) {
            toReturn = null;
        }
        if (toReturn != null) {
            toReturn.addAll(currentLeaves);
        }
        return toReturn;
    }

    private boolean checkConstraint(BindingNode leaf, AbstractConstraint c, RuntimeExceptionHandler runtimeExceptionHandler) {
        boolean hold = true;
        SimpleValueComputationParameters parameters = new SimpleValueComputationParameters(this.getConstraintSystem(), leaf, runtimeExceptionHandler);
        ConstraintChecker constraintChecker = new ConstraintChecker(parameters);
        hold = c.accept(constraintChecker);
        return hold;
    }

    @Override
    public void accept(QueryPlannerVisitor visitor) {
        visitor.visitConstraintQueryPlannerItem(this);
    }

    @Override
    public <O> O accept(QueryPlannerVisitorEx<O> visitor) {
        return visitor.visitConstraintQueryPlannerItem(this);
    }

    public AbstractConstraint getConstraint() {
        return this.constraint;
    }

    public String toString() {
        return this.getConstraint().render(this.getConstraintSystem());
    }
}

