/*
 * Decompiled with CFR 0.152.
 */
package org.coode.oppl.function;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.coode.oppl.ConstraintSystem;
import org.coode.oppl.function.AbstractOPPLFunction;
import org.coode.oppl.function.Aggregandum;
import org.coode.oppl.function.ClassIntersectionAggregation;
import org.coode.oppl.function.ClassUnionAggregation;
import org.coode.oppl.function.OPPLFunction;
import org.coode.oppl.function.OPPLFunctionVisitor;
import org.coode.oppl.function.OPPLFunctionVisitorEx;
import org.coode.oppl.function.StringConcatAggregation;
import org.coode.oppl.function.ValueComputation;
import org.coode.oppl.function.ValueComputationParameters;
import org.coode.oppl.utils.ArgCheck;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.util.ShortFormProvider;

public abstract class Aggregation<O, I>
extends AbstractOPPLFunction<O>
implements OPPLFunction<O> {
    protected final List<Aggregandum<I>> toAggregate = new ArrayList<Aggregandum<I>>();

    public Aggregation(Collection<? extends Aggregandum<I>> toAggregate) {
        this.toAggregate.addAll(ArgCheck.checkNotNull(toAggregate, "toAggregate"));
        if (toAggregate.isEmpty()) {
            throw new IllegalArgumentException("The collection of elements to aggregate cannot be null");
        }
    }

    protected abstract O aggregate(ValueComputationParameters var1);

    public List<Aggregandum<I>> getToAggregate() {
        return new ArrayList<Aggregandum<I>>(this.toAggregate);
    }

    @Override
    public <P> P accept(OPPLFunctionVisitorEx<P> visitor) {
        return visitor.visitAggregation(this);
    }

    @Override
    public void accept(OPPLFunctionVisitor visitor) {
        visitor.visitAggregation(this);
    }

    @Override
    public ValueComputation<O> getValueComputation(final ValueComputationParameters parameters) {
        return new ValueComputation<O>(){

            @Override
            public O compute(OPPLFunction<? extends O> opplFunction) {
                return Aggregation.this.aggregate(parameters);
            }
        };
    }

    public static Aggregation<String, String> buildStringConcatenation(Collection<? extends Aggregandum<String>> a) {
        return new StringConcatAggregation(a);
    }

    public static Aggregation<OWLClassExpression, Collection<? extends OWLClassExpression>> buildClassExpressionIntersection(Collection<? extends Aggregandum<Collection<? extends OWLClassExpression>>> a, OWLDataFactory dataFactory) {
        return new ClassIntersectionAggregation(a, dataFactory);
    }

    public static Aggregation<OWLClassExpression, Collection<? extends OWLClassExpression>> buildClassExpressionUnion(Collection<? extends Aggregandum<Collection<? extends OWLClassExpression>>> a, OWLDataFactory dataFactory) {
        return new ClassUnionAggregation(a, dataFactory);
    }

    protected String renderAggregation(ConstraintSystem constraintSystem, String prefix, String openDelimiter, String separator, String closedDelimiter) {
        Iterator<Aggregandum<I>> i = this.toAggregate.iterator();
        StringBuilder sb = new StringBuilder();
        sb.append(String.format("%s%s", prefix, openDelimiter));
        while (i.hasNext()) {
            Aggregandum<I> aggregation = i.next();
            Iterator<OPPLFunction<I>> iterator = aggregation.getOPPLFunctions().iterator();
            while (iterator.hasNext()) {
                OPPLFunction<I> opplFunction = iterator.next();
                sb.append(opplFunction.render(constraintSystem));
                if (!iterator.hasNext()) continue;
                sb.append(separator);
            }
            if (!i.hasNext()) continue;
            sb.append(separator);
        }
        sb.append(closedDelimiter);
        return sb.toString();
    }

    protected String renderAggregation(ShortFormProvider shortFormProvider, String prefix, String openDelimiter, String separator, String closedDelimiter) {
        Iterator<Aggregandum<I>> i = this.toAggregate.iterator();
        StringBuilder sb = new StringBuilder();
        sb.append(String.format("%s%s", prefix, openDelimiter));
        while (i.hasNext()) {
            Aggregandum<I> aggregation = i.next();
            Iterator<OPPLFunction<I>> iterator = aggregation.getOPPLFunctions().iterator();
            while (iterator.hasNext()) {
                OPPLFunction<I> opplFunction = iterator.next();
                sb.append(opplFunction.render(shortFormProvider));
                if (!iterator.hasNext()) continue;
                sb.append(separator);
            }
            if (!i.hasNext()) continue;
            sb.append(separator);
        }
        sb.append(closedDelimiter);
        return sb.toString();
    }
}

