/*
 * Decompiled with CFR 0.152.
 */
package org.coode.oppl.bindingtree;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import org.coode.oppl.ConstraintSystem;
import org.coode.oppl.Renderable;
import org.coode.oppl.Variable;
import org.coode.oppl.VariableVisitor;
import org.coode.oppl.VariableVisitorEx;
import org.coode.oppl.bindingtree.Assignment;
import org.coode.oppl.bindingtree.BindingVisitor;
import org.coode.oppl.bindingtree.BindingVisitorEx;
import org.coode.oppl.entity.OWLEntityRenderer;
import org.coode.oppl.function.ValueComputationParameters;
import org.coode.oppl.generated.GeneratedVariable;
import org.coode.oppl.generated.RegexpGeneratedVariable;
import org.coode.oppl.utils.ArgCheck;
import org.coode.oppl.variabletypes.InputVariable;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLObject;

public class BindingNode
implements Renderable {
    private static final BindingNode EMPTY_BINDING_NODE = new BindingNode();
    protected final Set<Assignment> assignments = new HashSet<Assignment>();
    protected final Set<Variable<?>> unassignedVariables = new LinkedHashSet();
    protected final VariableInspector unassignedVariablesUpdater = new VariableInspector(this.unassignedVariables);

    public BindingNode(Collection<Assignment> assignments, Collection<? extends Variable<?>> unassignedVariables) {
        this.assignments.addAll(assignments);
        this.unassignedVariables.addAll(unassignedVariables);
    }

    public BindingNode(Assignment ... assignments) {
        for (Assignment a : assignments) {
            this.assignments.add(a);
        }
    }

    public BindingNode(Collection<? extends Variable<?>> unassignedVariables) {
        this.unassignedVariables.addAll(unassignedVariables);
    }

    public BindingNode(Assignment assignment) {
        this.assignments.add(assignment);
    }

    public BindingNode(BindingNode bindingNode) {
        this(bindingNode.assignments, bindingNode.unassignedVariables);
    }

    protected BindingNode() {
    }

    public void accept(BindingVisitor visitor) {
        visitor.visit(this);
    }

    public <O> O accept(BindingVisitorEx<O> visitor) {
        return visitor.visit(this);
    }

    public boolean isLeaf() {
        return this.unassignedVariables.isEmpty();
    }

    public String toString() {
        return this.assignments + "\n" + (this.unassignedVariables.isEmpty() ? "" : this.unassignedVariables);
    }

    @Override
    public String render(ConstraintSystem cs) {
        boolean first = true;
        StringBuilder b = new StringBuilder();
        OWLEntityRenderer entityRenderer = cs.getOPPLFactory().getOWLEntityRenderer(cs);
        for (Assignment assignment : this.assignments) {
            String assignmentRendering;
            OWLObject value = assignment.getAssignment();
            String string = assignmentRendering = value instanceof OWLEntity ? entityRenderer.render((OWLEntity)value) : value.toString();
            if (!first) {
                b.append(", ");
            }
            first = false;
            b.append(assignment.getAssignedVariable().getName()).append(" = ").append(assignmentRendering);
        }
        if (!this.unassignedVariables.isEmpty()) {
            b.append(" ").append(this.unassignedVariables);
        }
        return b.toString();
    }

    public OWLObject getAssignmentValue(Variable<?> variable, ValueComputationParameters parameters) {
        return variable.accept(new AssignmentFinder(parameters, this));
    }

    public void addAssignment(final Assignment assignment) {
        assignment.getAssignedVariable().accept(new VariableVisitor(){

            @Override
            public <P extends OWLObject> void visit(RegexpGeneratedVariable<P> regExpGenerated) {
                BindingNode.this.assignments.add(assignment);
                BindingNode.this.unassignedVariables.remove(assignment.getAssignedVariable());
            }

            @Override
            public <P extends OWLObject> void visit(GeneratedVariable<P> v) {
            }

            @Override
            public <P extends OWLObject> void visit(InputVariable<P> v) {
                BindingNode.this.assignments.add(assignment);
                BindingNode.this.unassignedVariables.remove(assignment.getAssignedVariable());
            }
        });
    }

    public Set<Variable<?>> getAssignedVariables() {
        HashSet toReturn = new HashSet();
        for (Assignment assignment : this.assignments) {
            toReturn.add(assignment.getAssignedVariable());
        }
        return toReturn;
    }

    public boolean containsAssignedVariable(Variable<?> v) {
        for (Assignment assignment : this.assignments) {
            if (!assignment.getAssignedVariable().equals(v)) continue;
            return true;
        }
        return false;
    }

    public Collection<Assignment> getAssignments() {
        return new ArrayList<Assignment>(this.assignments);
    }

    public Set<Variable<?>> getUnassignedVariables() {
        return new LinkedHashSet(this.unassignedVariables);
    }

    public void addUnassignedVariable(Variable<?> v) {
        v.accept(this.unassignedVariablesUpdater);
    }

    public boolean isEmpty() {
        return this.assignments.isEmpty() && this.unassignedVariables.isEmpty();
    }

    public static BindingNode getEmptyBindingNode() {
        return EMPTY_BINDING_NODE;
    }

    public static BindingNode createNewEmptyBindingNode() {
        return new BindingNode();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.assignments.hashCode();
        result = 31 * result + this.unassignedVariables.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BindingNode other = (BindingNode)obj;
        return this.assignments.equals(other.assignments) && this.unassignedVariables.equals(other.unassignedVariables);
    }

    public boolean agreesWith(BindingNode bindingNode) {
        ArgCheck.checkNotNull(bindingNode, "bindingNode");
        return bindingNode.assignments.containsAll(this.assignments);
    }

    private static class VariableInspector
    implements VariableVisitor {
        private final Set<Variable<?>> toUpdate;

        public VariableInspector(Set<Variable<?>> toUpdate) {
            this.toUpdate = toUpdate;
        }

        @Override
        public <P extends OWLObject> void visit(InputVariable<P> v) {
            this.toUpdate.add(v);
        }

        @Override
        public <P extends OWLObject> void visit(GeneratedVariable<P> v) {
        }

        @Override
        public <P extends OWLObject> void visit(RegexpGeneratedVariable<P> regExpGenerated) {
        }
    }

    private static class AssignmentFinder
    implements VariableVisitorEx<OWLObject> {
        private final BindingNode node;
        private final ValueComputationParameters parameters;

        AssignmentFinder(ValueComputationParameters parameters, BindingNode node) {
            this.parameters = parameters;
            this.node = node;
        }

        @Override
        public <O extends OWLObject> OWLObject visit(InputVariable<O> v) {
            return this.findAssignment(v);
        }

        public OWLObject findAssignment(Variable<?> v) {
            Iterator<Assignment> iterator = this.node.assignments.iterator();
            boolean found = false;
            OWLObject toReturn = null;
            while (!found && iterator.hasNext()) {
                Assignment assignment = iterator.next();
                found = assignment.getAssignedVariable().equals(v);
                if (!found) continue;
                toReturn = assignment.getAssignment();
            }
            return toReturn;
        }

        @Override
        public <O extends OWLObject> OWLObject visit(GeneratedVariable<O> v) {
            return (OWLObject)v.getOPPLFunction().compute(this.parameters);
        }

        @Override
        public <O extends OWLObject> OWLObject visit(RegexpGeneratedVariable<O> v) {
            return this.findAssignment(v);
        }
    }
}

