/*
 * Decompiled with CFR 0.152.
 */
package org.coode.oppl;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.coode.oppl.AbstractConstraint;
import org.coode.oppl.ConstraintSystem;
import org.coode.oppl.ConstraintVisitor;
import org.coode.oppl.ConstraintVisitorEx;
import org.coode.oppl.Variable;
import org.coode.oppl.function.OPPLFunction;
import org.coode.oppl.function.ValueComputationParameters;
import org.coode.oppl.rendering.ManchesterSyntaxRenderer;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLObjectVisitor;
import org.semanticweb.owlapi.util.ShortFormProvider;

public class RegExpConstraint
implements AbstractConstraint {
    private final Variable<?> variable;
    private final OPPLFunction<Pattern> expression;
    private final ConstraintSystem constraintSystem;

    public RegExpConstraint(Variable<?> variable, OPPLFunction<Pattern> exp, ConstraintSystem cs) {
        this.variable = variable;
        this.constraintSystem = cs;
        this.expression = exp;
    }

    @Override
    public <O> O accept(ConstraintVisitorEx<O> visitor) {
        return visitor.visit(this);
    }

    public Variable<?> getVariable() {
        return this.variable;
    }

    public boolean matches(ValueComputationParameters parameters) {
        OWLObject assignmentValue = parameters.getBindingNode().getAssignmentValue(this.getVariable(), parameters);
        boolean found = false;
        if (assignmentValue != null) {
            Pattern p = this.getExpression().compute(parameters);
            ManchesterSyntaxRenderer renderer = parameters.getConstraintSystem().getOPPLFactory().getManchesterSyntaxRenderer(this.getConstraintSystem());
            assignmentValue.accept((OWLObjectVisitor)renderer);
            Matcher matcher = p.matcher(renderer.toString());
            found = matcher.matches();
        }
        return found;
    }

    @Override
    public String render(ShortFormProvider shortFormProvider) {
        return this.variable.getName() + " Match(" + this.getExpression().render(shortFormProvider) + ")";
    }

    public String toString() {
        return this.variable.getName() + " Match(" + this.getExpression().render(this.getConstraintSystem()) + ")";
    }

    @Override
    public String render(ConstraintSystem cs) {
        return this.toString();
    }

    @Override
    public void accept(ConstraintVisitor visitor) {
        visitor.visitInCollectionConstraint(this);
    }

    public ConstraintSystem getConstraintSystem() {
        return this.constraintSystem;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.expression == null ? 0 : this.expression.hashCode());
        result = 31 * result + (this.variable == null ? 0 : this.variable.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RegExpConstraint other = (RegExpConstraint)obj;
        if (this.expression == null ? other.expression != null : !this.expression.equals(other.expression)) {
            return false;
        }
        return !(this.variable == null ? other.variable != null : !this.variable.equals(other.variable));
    }

    public OPPLFunction<Pattern> getExpression() {
        return this.expression;
    }
}

