/*
 * Decompiled with CFR 0.152.
 */
package org.coode.oppl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.coode.oppl.Variable;
import org.coode.oppl.bindingtree.BindingNode;
import org.coode.oppl.function.ValueComputationParameters;
import org.coode.oppl.utils.ArgCheck;
import org.semanticweb.owlapi.model.OWLAsymmetricObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassAssertionAxiom;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataAllValuesFrom;
import org.semanticweb.owlapi.model.OWLDataComplementOf;
import org.semanticweb.owlapi.model.OWLDataExactCardinality;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLDataHasValue;
import org.semanticweb.owlapi.model.OWLDataMaxCardinality;
import org.semanticweb.owlapi.model.OWLDataMinCardinality;
import org.semanticweb.owlapi.model.OWLDataOneOf;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDataPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLDataPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLDataPropertyExpression;
import org.semanticweb.owlapi.model.OWLDataPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLDataRange;
import org.semanticweb.owlapi.model.OWLDataSomeValuesFrom;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLDatatypeRestriction;
import org.semanticweb.owlapi.model.OWLDeclarationAxiom;
import org.semanticweb.owlapi.model.OWLDifferentIndividualsAxiom;
import org.semanticweb.owlapi.model.OWLDisjointClassesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointDataPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointUnionAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentClassesAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentDataPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLFunctionalDataPropertyAxiom;
import org.semanticweb.owlapi.model.OWLFunctionalObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLInverseFunctionalObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLInverseObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLIrreflexiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLNegativeDataPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLNegativeObjectPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLObjectAllValuesFrom;
import org.semanticweb.owlapi.model.OWLObjectComplementOf;
import org.semanticweb.owlapi.model.OWLObjectExactCardinality;
import org.semanticweb.owlapi.model.OWLObjectHasSelf;
import org.semanticweb.owlapi.model.OWLObjectHasValue;
import org.semanticweb.owlapi.model.OWLObjectIntersectionOf;
import org.semanticweb.owlapi.model.OWLObjectInverseOf;
import org.semanticweb.owlapi.model.OWLObjectMaxCardinality;
import org.semanticweb.owlapi.model.OWLObjectMinCardinality;
import org.semanticweb.owlapi.model.OWLObjectOneOf;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLObjectPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLObjectPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLObjectSomeValuesFrom;
import org.semanticweb.owlapi.model.OWLObjectUnionOf;
import org.semanticweb.owlapi.model.OWLObjectVisitorEx;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLReflexiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLSameIndividualAxiom;
import org.semanticweb.owlapi.model.OWLSubClassOfAxiom;
import org.semanticweb.owlapi.model.OWLSubDataPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubObjectPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubPropertyChainOfAxiom;
import org.semanticweb.owlapi.model.OWLSymmetricObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLTransitiveObjectPropertyAxiom;
import org.semanticweb.owlapi.util.OWLObjectVisitorExAdapter;

public class OWLObjectAbstractor
extends OWLObjectVisitorExAdapter<OWLObject>
implements OWLObjectVisitorEx<OWLObject> {
    private final ValueComputationParameters parameters;
    private final Set<Variable<?>> variables = new HashSet();
    private final Set<BindingNode> bindingNodes = new HashSet<BindingNode>();
    private final OWLDataFactory df;

    public OWLObjectAbstractor(Collection<? extends Variable<?>> variables, ValueComputationParameters parameters) {
        this(variables, parameters, parameters.getConstraintSystem().getLeaves());
    }

    protected OWLObject getDefaultReturnValue(OWLObject object) {
        return object;
    }

    public OWLObjectAbstractor(Collection<? extends Variable<?>> variables, ValueComputationParameters parameters, Collection<? extends BindingNode> bindingNodes) {
        this.variables.addAll(ArgCheck.checkNotNull(variables, "variables"));
        this.parameters = ArgCheck.checkNotNull(parameters, "parameters");
        if (bindingNodes != null) {
            this.bindingNodes.addAll(bindingNodes);
        }
        this.df = parameters.getConstraintSystem().getOntologyManager().getOWLDataFactory();
    }

    private <T extends OWLObject> T abs(T property) {
        return (T)((OWLObject)property.accept((OWLObjectVisitorEx)this));
    }

    private <T extends OWLObject> Set<T> abs(Collection<T> c) {
        HashSet<OWLObject> values = new HashSet<OWLObject>();
        for (OWLObject v : c) {
            values.add(this.abs(v));
        }
        return values;
    }

    private Variable<?> getAbstractingVariable(OWLObject owlObject) {
        boolean found = false;
        Iterator<Variable<?>> it = this.variables.iterator();
        Variable<?> toReturn = null;
        Variable<?> aVariable = null;
        while (!found && it.hasNext()) {
            aVariable = it.next();
            Iterator<BindingNode> bindingNodesIterator = this.getBindingNodes().iterator();
            while (!found && bindingNodesIterator.hasNext()) {
                BindingNode bindingNode = bindingNodesIterator.next();
                found = bindingNode.getAssignmentValue(aVariable, this.getParameters()).equals(owlObject);
            }
        }
        if (found) {
            toReturn = aVariable;
        }
        return toReturn;
    }

    public OWLObject visit(OWLAsymmetricObjectPropertyAxiom axiom) {
        return this.df.getOWLAsymmetricObjectPropertyAxiom((OWLObjectPropertyExpression)this.abs(axiom.getProperty()));
    }

    public OWLClassExpression visit(OWLClass desc) {
        OWLClass toReturn = desc;
        Variable<?> v = this.getAbstractingVariable((OWLObject)desc);
        if (v != null) {
            toReturn = this.df.getOWLClass(v.getIRI());
        }
        return toReturn;
    }

    public OWLObject visit(OWLClassAssertionAxiom axiom) {
        return this.df.getOWLClassAssertionAxiom(this.abs(axiom.getClassExpression()), this.abs(axiom.getIndividual()));
    }

    public OWLObject visit(OWLDataAllValuesFrom desc) {
        return this.df.getOWLDataAllValuesFrom((OWLDataPropertyExpression)this.abs(desc.getProperty()), (OWLDataRange)this.abs(desc.getFiller()));
    }

    public OWLObject visit(OWLDataComplementOf node) {
        return this.df.getOWLDataComplementOf(this.abs(node.getDataRange()));
    }

    public OWLObject visit(OWLDataExactCardinality desc) {
        int cardinality = desc.getCardinality();
        return this.df.getOWLDataExactCardinality(cardinality, (OWLDataPropertyExpression)this.abs(desc.getProperty()), (OWLDataRange)this.abs(desc.getFiller()));
    }

    public OWLObject visit(OWLDataMaxCardinality desc) {
        int cardinality = desc.getCardinality();
        return this.df.getOWLDataMaxCardinality(cardinality, (OWLDataPropertyExpression)this.abs(desc.getProperty()), (OWLDataRange)this.abs(desc.getFiller()));
    }

    public OWLObject visit(OWLDataMinCardinality desc) {
        int cardinality = desc.getCardinality();
        return this.df.getOWLDataMinCardinality(cardinality, (OWLDataPropertyExpression)this.abs(desc.getProperty()), (OWLDataRange)this.abs(desc.getFiller()));
    }

    public OWLObject visit(OWLDataOneOf node) {
        return this.df.getOWLDataOneOf(this.abs(node.getValues()));
    }

    public OWLObject visit(OWLDataProperty property) {
        OWLDataProperty toReturn = property;
        Variable<?> v = this.getAbstractingVariable((OWLObject)property);
        if (v != null) {
            toReturn = this.df.getOWLDataProperty(v.getIRI());
        }
        return toReturn;
    }

    public OWLObject visit(OWLDataPropertyAssertionAxiom axiom) {
        return this.df.getOWLDataPropertyAssertionAxiom((OWLDataPropertyExpression)this.abs(axiom.getProperty()), this.abs(axiom.getSubject()), (OWLLiteral)this.abs(axiom.getObject()));
    }

    public OWLObject visit(OWLDataPropertyDomainAxiom axiom) {
        return this.df.getOWLDataPropertyDomainAxiom((OWLDataPropertyExpression)this.abs(axiom.getProperty()), this.abs(axiom.getDomain()));
    }

    public OWLObject visit(OWLDataPropertyRangeAxiom axiom) {
        return this.df.getOWLDataPropertyRangeAxiom((OWLDataPropertyExpression)this.abs(axiom.getProperty()), (OWLDataRange)this.abs(axiom.getRange()));
    }

    public OWLObject visit(OWLDatatypeRestriction node) {
        return this.df.getOWLDatatypeRestriction(this.abs(node.getDatatype()), node.getFacetRestrictions());
    }

    public OWLObject visit(OWLDataSomeValuesFrom desc) {
        return this.df.getOWLDataSomeValuesFrom((OWLDataPropertyExpression)this.abs(desc.getProperty()), (OWLDataRange)this.abs(desc.getFiller()));
    }

    public OWLObject visit(OWLSubDataPropertyOfAxiom axiom) {
        return this.df.getOWLSubDataPropertyOfAxiom((OWLDataPropertyExpression)this.abs(axiom.getSubProperty()), (OWLDataPropertyExpression)this.abs(axiom.getSuperProperty()));
    }

    public OWLObject visit(OWLDatatype node) {
        return node;
    }

    public OWLObject visit(OWLDataHasValue desc) {
        return this.df.getOWLDataHasValue((OWLDataPropertyExpression)this.abs(desc.getProperty()), (OWLLiteral)this.abs(desc.getValue()));
    }

    public OWLObject visit(OWLDeclarationAxiom axiom) {
        return axiom;
    }

    public OWLObject visit(OWLDifferentIndividualsAxiom axiom) {
        return this.df.getOWLDifferentIndividualsAxiom(this.abs(axiom.getIndividuals()));
    }

    public OWLObject visit(OWLDisjointClassesAxiom axiom) {
        return this.df.getOWLDisjointClassesAxiom(this.abs(axiom.getClassExpressions()));
    }

    public OWLObject visit(OWLDisjointDataPropertiesAxiom axiom) {
        return this.df.getOWLDisjointDataPropertiesAxiom(this.abs(axiom.getProperties()));
    }

    public OWLObject visit(OWLDisjointObjectPropertiesAxiom axiom) {
        return this.df.getOWLDisjointObjectPropertiesAxiom(this.abs(axiom.getProperties()));
    }

    public OWLObject visit(OWLDisjointUnionAxiom axiom) {
        return this.df.getOWLDisjointUnionAxiom(this.abs(axiom.getOWLClass()), this.abs(axiom.getClassExpressions()));
    }

    public OWLObject visit(OWLEquivalentClassesAxiom axiom) {
        return this.df.getOWLEquivalentClassesAxiom(this.abs(axiom.getClassExpressions()));
    }

    public OWLObject visit(OWLEquivalentDataPropertiesAxiom axiom) {
        return this.df.getOWLEquivalentDataPropertiesAxiom(this.abs(axiom.getProperties()));
    }

    public OWLObject visit(OWLEquivalentObjectPropertiesAxiom axiom) {
        return this.df.getOWLEquivalentObjectPropertiesAxiom(this.abs(axiom.getProperties()));
    }

    public OWLObject visit(OWLFunctionalDataPropertyAxiom axiom) {
        return this.df.getOWLFunctionalDataPropertyAxiom((OWLDataPropertyExpression)this.abs(axiom.getProperty()));
    }

    public OWLObject visit(OWLFunctionalObjectPropertyAxiom axiom) {
        return this.df.getOWLFunctionalObjectPropertyAxiom((OWLObjectPropertyExpression)this.abs(axiom.getProperty()));
    }

    public OWLObject visit(OWLNamedIndividual individual) {
        OWLNamedIndividual toReturn = individual;
        Variable<?> v = this.getAbstractingVariable((OWLObject)individual);
        if (v != null) {
            toReturn = this.df.getOWLNamedIndividual(v.getIRI());
        }
        return toReturn;
    }

    public OWLObject visit(OWLInverseFunctionalObjectPropertyAxiom axiom) {
        return this.df.getOWLInverseFunctionalObjectPropertyAxiom((OWLObjectPropertyExpression)this.abs(axiom.getProperty()));
    }

    public OWLObject visit(OWLInverseObjectPropertiesAxiom axiom) {
        return this.df.getOWLInverseObjectPropertiesAxiom(this.abs(axiom.getFirstProperty()), this.abs(axiom.getSecondProperty()));
    }

    public OWLObject visit(OWLIrreflexiveObjectPropertyAxiom axiom) {
        return this.df.getOWLIrreflexiveObjectPropertyAxiom((OWLObjectPropertyExpression)this.abs(axiom.getProperty()));
    }

    public OWLObject visit(OWLNegativeDataPropertyAssertionAxiom axiom) {
        return this.df.getOWLNegativeDataPropertyAssertionAxiom((OWLDataPropertyExpression)this.abs(axiom.getProperty()), this.abs(axiom.getSubject()), (OWLLiteral)this.abs(axiom.getObject()));
    }

    public OWLObject visit(OWLNegativeObjectPropertyAssertionAxiom axiom) {
        return this.df.getOWLNegativeObjectPropertyAssertionAxiom((OWLObjectPropertyExpression)this.abs(axiom.getProperty()), this.abs(axiom.getSubject()), (OWLIndividual)this.abs(axiom.getObject()));
    }

    public OWLClassExpression visit(OWLObjectAllValuesFrom desc) {
        return this.df.getOWLObjectAllValuesFrom((OWLObjectPropertyExpression)this.abs(desc.getProperty()), (OWLClassExpression)this.abs(desc.getFiller()));
    }

    public OWLClassExpression visit(OWLObjectComplementOf desc) {
        return this.df.getOWLObjectComplementOf(this.abs(desc.getOperand()));
    }

    public OWLObject visit(OWLObjectExactCardinality desc) {
        int cardinality = desc.getCardinality();
        return this.df.getOWLObjectExactCardinality(cardinality, (OWLObjectPropertyExpression)this.abs(desc.getProperty()), (OWLClassExpression)this.abs(desc.getFiller()));
    }

    public OWLClassExpression visit(OWLObjectIntersectionOf desc) {
        return this.df.getOWLObjectIntersectionOf(this.abs(desc.getOperands()));
    }

    public OWLObject visit(OWLObjectMaxCardinality desc) {
        int cardinality = desc.getCardinality();
        return this.df.getOWLObjectMaxCardinality(cardinality, (OWLObjectPropertyExpression)this.abs(desc.getProperty()), (OWLClassExpression)this.abs(desc.getFiller()));
    }

    public OWLObject visit(OWLObjectMinCardinality desc) {
        int cardinality = desc.getCardinality();
        return this.df.getOWLObjectMinCardinality(cardinality, (OWLObjectPropertyExpression)this.abs(desc.getProperty()), (OWLClassExpression)this.abs(desc.getFiller()));
    }

    public OWLObject visit(OWLObjectOneOf desc) {
        return this.df.getOWLObjectOneOf(this.abs(desc.getIndividuals()));
    }

    public OWLObject visit(OWLObjectProperty property) {
        OWLObjectProperty toReturn = property;
        Variable<?> v = this.getAbstractingVariable((OWLObject)property);
        if (v != null) {
            toReturn = this.df.getOWLObjectProperty(v.getIRI());
        }
        return toReturn;
    }

    public OWLObject visit(OWLObjectPropertyAssertionAxiom axiom) {
        return this.df.getOWLObjectPropertyAssertionAxiom((OWLObjectPropertyExpression)this.abs(axiom.getProperty()), this.abs(axiom.getSubject()), (OWLIndividual)this.abs(axiom.getObject()));
    }

    public OWLObject visit(OWLSubPropertyChainOfAxiom axiom) {
        List propertyChain = axiom.getPropertyChain();
        ArrayList<OWLObjectPropertyExpression> values = new ArrayList<OWLObjectPropertyExpression>();
        for (OWLObjectPropertyExpression v : propertyChain) {
            values.add(this.abs(v));
        }
        return this.df.getOWLSubPropertyChainOfAxiom(values, this.abs(axiom.getSuperProperty()));
    }

    public OWLObject visit(OWLObjectPropertyDomainAxiom axiom) {
        return this.df.getOWLObjectPropertyDomainAxiom((OWLObjectPropertyExpression)this.abs(axiom.getProperty()), this.abs(axiom.getDomain()));
    }

    public OWLObject visit(OWLObjectInverseOf property) {
        return this.df.getOWLObjectInverseOf(this.abs(property.getInverse()));
    }

    public OWLObject visit(OWLObjectPropertyRangeAxiom axiom) {
        return this.df.getOWLObjectPropertyRangeAxiom((OWLObjectPropertyExpression)this.abs(axiom.getProperty()), (OWLClassExpression)this.abs(axiom.getRange()));
    }

    public OWLObject visit(OWLObjectHasSelf desc) {
        return this.df.getOWLObjectHasSelf((OWLObjectPropertyExpression)this.abs(desc.getProperty()));
    }

    public OWLClassExpression visit(OWLObjectSomeValuesFrom desc) {
        return this.df.getOWLObjectSomeValuesFrom((OWLObjectPropertyExpression)this.abs(desc.getProperty()), (OWLClassExpression)this.abs(desc.getFiller()));
    }

    public OWLObject visit(OWLSubObjectPropertyOfAxiom axiom) {
        return this.df.getOWLSubObjectPropertyOfAxiom((OWLObjectPropertyExpression)this.abs(axiom.getSubProperty()), (OWLObjectPropertyExpression)this.abs(axiom.getSuperProperty()));
    }

    public OWLClassExpression visit(OWLObjectUnionOf desc) {
        return this.df.getOWLObjectUnionOf(this.abs(desc.getOperands()));
    }

    public OWLClassExpression visit(OWLObjectHasValue desc) {
        return this.df.getOWLObjectHasValue((OWLObjectPropertyExpression)this.abs(desc.getProperty()), (OWLIndividual)this.abs(desc.getValue()));
    }

    public OWLObject visit(OWLOntology ontology) {
        return ontology;
    }

    public OWLObject visit(OWLReflexiveObjectPropertyAxiom axiom) {
        return this.df.getOWLReflexiveObjectPropertyAxiom((OWLObjectPropertyExpression)this.abs(axiom.getProperty()));
    }

    public OWLObject visit(OWLSameIndividualAxiom axiom) {
        return this.df.getOWLSameIndividualAxiom(this.abs(axiom.getIndividuals()));
    }

    public OWLObject visit(OWLSubClassOfAxiom axiom) {
        return this.df.getOWLSubClassOfAxiom(this.abs(axiom.getSubClass()), this.abs(axiom.getSuperClass()));
    }

    public OWLObject visit(OWLSymmetricObjectPropertyAxiom axiom) {
        return this.df.getOWLSymmetricObjectPropertyAxiom((OWLObjectPropertyExpression)this.abs(axiom.getProperty()));
    }

    public OWLObject visit(OWLTransitiveObjectPropertyAxiom axiom) {
        return this.df.getOWLTransitiveObjectPropertyAxiom((OWLObjectPropertyExpression)this.abs(axiom.getProperty()));
    }

    public OWLObject visit(OWLLiteral node) {
        OWLLiteral toReturn = node;
        Variable<?> v = this.getAbstractingVariable((OWLObject)node);
        if (v != null) {
            toReturn = this.df.getOWLLiteral(v.getIRI().toString());
        }
        return toReturn;
    }

    public Set<BindingNode> getBindingNodes() {
        return this.bindingNodes;
    }

    public ValueComputationParameters getParameters() {
        return this.parameters;
    }
}

