/*
 * Decompiled with CFR 0.152.
 */
package org.coode.oppl;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.coode.oppl.ActionType;
import org.coode.oppl.ConstraintSystem;
import org.coode.oppl.PartialOWLObjectInstantiator;
import org.coode.oppl.bindingtree.BindingNode;
import org.coode.oppl.exceptions.RuntimeExceptionHandler;
import org.coode.oppl.function.SimpleValueComputationParameters;
import org.semanticweb.owlapi.model.AddAxiom;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLAxiomChange;
import org.semanticweb.owlapi.model.OWLObjectVisitorEx;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.RemoveAxiom;

public class ActionFactory {
    public static List<OWLAxiomChange> createChanges(ActionType actionType, OWLAxiom axiom, ConstraintSystem cs, OWLOntology ontology, RuntimeExceptionHandler runtimeExcpetionHandler) {
        HashSet<Object> toReturn = new HashSet<Object>();
        Set<BindingNode> leaves = cs.getLeaves();
        if (leaves != null) {
            for (BindingNode bindingNode : leaves) {
                SimpleValueComputationParameters parameters = new SimpleValueComputationParameters(cs, bindingNode, runtimeExcpetionHandler);
                PartialOWLObjectInstantiator instatiator = new PartialOWLObjectInstantiator(parameters);
                OWLAxiom instantiatedAxiom = (OWLAxiom)axiom.accept((OWLObjectVisitorEx)instatiator);
                switch (actionType) {
                    case ADD: {
                        toReturn.add(new AddAxiom(ontology, instantiatedAxiom));
                        break;
                    }
                    case REMOVE: {
                        toReturn.add(new RemoveAxiom(ontology, instantiatedAxiom));
                        break;
                    }
                }
            }
        } else if (cs.getAxiomVariables(axiom).isEmpty()) {
            switch (actionType) {
                case ADD: {
                    toReturn.add(new AddAxiom(ontology, axiom));
                    break;
                }
                case REMOVE: {
                    toReturn.add(new RemoveAxiom(ontology, axiom));
                    break;
                }
            }
        }
        return new ArrayList<OWLAxiomChange>(toReturn);
    }

    public static List<OWLAxiomChange> createChanges(ActionType actionType, OWLAxiom axiom, ConstraintSystem cs, Set<OWLOntology> ontologies, RuntimeExceptionHandler runtimeExceptionHandler) {
        ArrayList<OWLAxiomChange> toReturn = new ArrayList<OWLAxiomChange>();
        for (OWLOntology ontology : ontologies) {
            toReturn.addAll(ActionFactory.createChanges(actionType, axiom, cs, ontology, runtimeExceptionHandler));
        }
        return toReturn;
    }
}

