/*
 * Decompiled with CFR 0.152.
 */
package org.coode.parsers.oppl;

import java.net.URI;
import java.util.Collections;
import java.util.Set;
import org.coode.oppl.Variable;
import org.coode.oppl.function.AttributeName;
import org.coode.oppl.function.IRIVariableAttribute;
import org.coode.parsers.oppl.IRIVisitor;
import org.coode.parsers.oppl.IRIVisitorEx;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotationSubjectVisitor;
import org.semanticweb.owlapi.model.OWLAnnotationSubjectVisitorEx;
import org.semanticweb.owlapi.model.OWLAnnotationValueVisitor;
import org.semanticweb.owlapi.model.OWLAnnotationValueVisitorEx;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLObjectVisitor;
import org.semanticweb.owlapi.model.OWLObjectVisitorEx;

public class VariableIRI
extends IRI {
    private static final long serialVersionUID = 20100L;
    private final IRIVariableAttribute attribute;

    public IRIVariableAttribute getAttribute() {
        return this.attribute;
    }

    public VariableIRI(Variable<?> variable) {
        super(String.format("%s.%s", new Object[]{variable.getName(), AttributeName.IRI}));
        this.attribute = new IRIVariableAttribute(variable);
    }

    public void accept(OWLAnnotationSubjectVisitor visitor) {
        visitor.visit((IRI)this);
    }

    public <E> E accept(OWLAnnotationSubjectVisitorEx<E> visitor) {
        return (E)visitor.visit((IRI)this);
    }

    public Set<OWLEntity> getSignature() {
        return Collections.emptySet();
    }

    public Set<OWLClass> getClassesInSignature() {
        return Collections.emptySet();
    }

    public Set<OWLDataProperty> getDataPropertiesInSignature() {
        return Collections.emptySet();
    }

    public Set<OWLObjectProperty> getObjectPropertiesInSignature() {
        return Collections.emptySet();
    }

    public Set<OWLNamedIndividual> getIndividualsInSignature() {
        return Collections.emptySet();
    }

    public Set<OWLDatatype> getDatatypesInSignature() {
        return Collections.emptySet();
    }

    public Set<OWLClassExpression> getNestedClassExpressions() {
        return Collections.emptySet();
    }

    public void accept(OWLObjectVisitor visitor) {
        if (visitor instanceof IRIVisitor) {
            ((IRIVisitor)visitor).visitVariableIRI(this);
        } else {
            visitor.visit((IRI)this);
        }
    }

    public void accept(IRIVisitor visitor) {
        visitor.visitVariableIRI(this);
    }

    public <O> O accept(OWLObjectVisitorEx<O> visitor) {
        return (O)(visitor instanceof IRIVisitorEx ? ((IRIVisitorEx)visitor).visitVariableIRI(this) : visitor.visit((IRI)this));
    }

    public <O> O accept(IRIVisitorEx<O> visitor) {
        return visitor.visitVariableIRI(this);
    }

    public boolean isTopEntity() {
        return false;
    }

    public boolean isBottomEntity() {
        return false;
    }

    public int compareTo(OWLObject object) {
        if (object == this) {
            return 0;
        }
        if (!(object instanceof IRI)) {
            return -1;
        }
        return this.toString().compareTo(object.toString());
    }

    public void accept(OWLAnnotationValueVisitor visitor) {
        visitor.visit((IRI)this);
    }

    public <O> O accept(OWLAnnotationValueVisitorEx<O> visitor) {
        return (O)visitor.visit((IRI)this);
    }

    public URI toURI() {
        return URI.create(this.toString());
    }

    public boolean isAbsolute() {
        return false;
    }

    public String getScheme() {
        return null;
    }

    public String getStart() {
        return this.getScheme();
    }

    public IRI resolve(String s) {
        return this;
    }

    public boolean isReservedVocabulary() {
        return false;
    }

    public boolean isThing() {
        return false;
    }

    public boolean isNothing() {
        return false;
    }

    public boolean isPlainLiteral() {
        return false;
    }

    public String getFragment() {
        return this.toString();
    }

    public String toQuotedString() {
        return this.toString();
    }

    public String toString() {
        return String.format("%s.%s", new Object[]{this.getAttribute().getVariable().getName(), this.getAttribute().getAttribute()});
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.attribute == null ? 0 : this.attribute.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        VariableIRI other = (VariableIRI)((Object)obj);
        return !(this.attribute == null ? other.attribute != null : !this.attribute.equals(other.attribute));
    }
}

