/*
 * Decompiled with CFR 0.152.
 */
package org.coode.parsers.oppl;

import java.util.Set;
import org.coode.oppl.utils.ArgCheck;
import org.coode.parsers.DisposableOWLEntityChecker;
import org.coode.parsers.EntityFinder;
import org.coode.parsers.OWLEntityCheckerScope;
import org.coode.parsers.OWLEntityRenderer;
import org.coode.parsers.Scope;
import org.coode.parsers.Symbol;
import org.coode.parsers.Type;
import org.coode.parsers.oppl.CreateOnDemandIdentifier;

public class OPPLScope
implements Scope {
    private final OWLEntityCheckerScope owlEntityCheckerScope;

    public OPPLScope(DisposableOWLEntityChecker owlEntityChecker, EntityFinder entityFinder, OWLEntityRenderer owlEntityRenderer) {
        ArgCheck.checkNotNull(owlEntityChecker, "owlEntityChecker");
        ArgCheck.checkNotNull(entityFinder, "entityFinder");
        ArgCheck.checkNotNull(owlEntityRenderer, "owlEntityRenderer");
        this.owlEntityCheckerScope = new OWLEntityCheckerScope(owlEntityChecker, entityFinder, owlEntityRenderer);
    }

    @Override
    public void define(Symbol symbol) {
    }

    @Override
    public Set<Symbol> getAllSymbols() {
        return this.owlEntityCheckerScope.getAllSymbols();
    }

    @Override
    public Set<Symbol> getAllSymbols(Type type) {
        return this.owlEntityCheckerScope.getAllSymbols();
    }

    @Override
    public Scope getEnclosingScope() {
        return null;
    }

    @Override
    public String getScopeName() {
        return "global OPPL scope";
    }

    @Override
    public Set<Symbol> match(String prefix) {
        return this.owlEntityCheckerScope.match(prefix);
    }

    @Override
    public Symbol resolve(String name) {
        Symbol toReturn = this.owlEntityCheckerScope.resolve(name);
        if (toReturn == null && name.startsWith("!")) {
            toReturn = new CreateOnDemandIdentifier(name);
        }
        return toReturn;
    }

    @Override
    public void dispose() {
        this.owlEntityCheckerScope.dispose();
    }
}

