/*
 * Decompiled with CFR 0.152.
 */
package org.coode.parsers;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.coode.parsers.OWLAxiomType;
import org.coode.parsers.OWLType;
import org.coode.parsers.Type;
import org.coode.parsers.TypeVisitor;

public class AutoCompleteStrings {
    public static final String SUBCLASS_OF = "subClassOf";
    public static final String EQUIVALENT_TO = "equivalentTo";
    public static final String SUB_PROPERTY_OF = "subPropertyOf";
    public static final String SAME_AS = "sameAs";
    public static final String DIFFERENT_FROM = "differentFrom";
    public static final String INVERSE_OF = "InverseOf";
    public static final String DISJOINT_WITH = "DisjointWith";
    public static final String INVERSE_FUNCTIONAL = "InverseFunctional";
    public static final String INSTANCE_OF = "InstanceOf";
    public static final String TYPES = "types";
    public static final String AND = "and";
    public static final String OR = "or";
    public static final String NOT = "not";
    public static final String SOME = "some";
    public static final String ONLY = "only";
    public static final String MIN = "min";
    public static final String MAX = "max";
    public static final String EXACTLY = "exactly";
    public static final String VALUE = "value";
    public static final String INVERSE = "INV";
    public static final String DOMAIN = "Domain";
    public static final String RANGE = "Range";
    public static final String FUNCTIONAL = "Functional";
    public static final String SYMMETRIC = "Symmetric";
    public static final String ANTI_SYMMETRIC = "AntiSymmetric";
    public static final String REFLEXIVE = "Reflexive";
    public static final String IRREFLEXIVE = "Irreflexive";
    public static final String TRANSITIVE = "Transitive";

    public static List<String> getStandaloneClassExpressionCompletions() {
        ArrayList<String> toReturn = new ArrayList<String>(Arrays.asList(SUBCLASS_OF, EQUIVALENT_TO, DISJOINT_WITH));
        toReturn.addAll(AutoCompleteStrings.getClassExpressionCompletions());
        return toReturn;
    }

    public static List<String> getIncompleteClassExpressionCompletions(String incompleteText) {
        ArrayList<String> toReturn = new ArrayList<String>(Arrays.asList(SUBCLASS_OF, EQUIVALENT_TO, DISJOINT_WITH));
        toReturn.addAll(AutoCompleteStrings.getClassExpressionCompletions());
        AutoCompleteStrings.filter(incompleteText, toReturn);
        return toReturn;
    }

    private static void filter(String incompleteText, Collection<? extends String> c) {
        Iterator<? extends String> iterator = c.iterator();
        while (iterator.hasNext()) {
            String string = iterator.next();
            if (string.startsWith(incompleteText)) continue;
            iterator.remove();
        }
    }

    public static List<String> getStandalonePropertyCompletions() {
        ArrayList<String> toReturn = new ArrayList<String>(Arrays.asList(SUB_PROPERTY_OF, EQUIVALENT_TO, DISJOINT_WITH, INVERSE_OF));
        toReturn.addAll(AutoCompleteStrings.getPropertyCompletions());
        return toReturn;
    }

    public static List<String> getIncompletePropertyCompletions(String incompleteText) {
        ArrayList<String> toReturn = new ArrayList<String>(Arrays.asList(SUB_PROPERTY_OF, EQUIVALENT_TO, DISJOINT_WITH, INVERSE_OF));
        toReturn.addAll(AutoCompleteStrings.getPropertyCompletions());
        AutoCompleteStrings.filter(incompleteText, toReturn);
        return toReturn;
    }

    public static List<String> getPropertyCompletions() {
        ArrayList<String> toReturn = new ArrayList<String>(Arrays.asList(SOME, ONLY, MIN, MAX, EXACTLY, VALUE));
        return toReturn;
    }

    public static List<String> getClassExpressionCompletions() {
        ArrayList<String> toReturn = new ArrayList<String>(Arrays.asList(AND, OR));
        return toReturn;
    }

    public static List<String> getStandaloneIndividualCompletions() {
        ArrayList<String> toReturn = new ArrayList<String>(Arrays.asList(DIFFERENT_FROM, SAME_AS));
        return toReturn;
    }

    public static List<String> getIncompleteIndividualCompletions(String incompleteText) {
        ArrayList<String> toReturn = new ArrayList<String>(Arrays.asList(DIFFERENT_FROM, SAME_AS));
        AutoCompleteStrings.filter(incompleteText, toReturn);
        return toReturn;
    }

    public static List<String> getStandaloneExpressionCompletions(Type type) {
        final ArrayList<String> toReturn = new ArrayList<String>();
        if (type != null) {
            type.accept(new TypeVisitor(){

                @Override
                public void visitOWLType(OWLType owlType) {
                    if (OWLType.isClassExpression(owlType)) {
                        toReturn.addAll(AutoCompleteStrings.getStandaloneClassExpressionCompletions());
                    } else if (OWLType.isObjectPropertyExpression(owlType)) {
                        toReturn.addAll(AutoCompleteStrings.getStandalonePropertyCompletions());
                    } else if (owlType == OWLType.OWL_DATA_PROPERTY) {
                        toReturn.addAll(AutoCompleteStrings.getStandalonePropertyCompletions());
                    } else if (owlType == OWLType.OWL_INDIVIDUAL) {
                        toReturn.addAll(AutoCompleteStrings.getStandaloneIndividualCompletions());
                    }
                }

                @Override
                public void visitNonOWLType(Type t) {
                }

                @Override
                public void visitOWLAxiomType(OWLAxiomType owlAxiomType) {
                }
            });
        }
        return toReturn;
    }

    public static List<String> getIncompleteExpressionCompletions(final String incompleteText, Type type) {
        final ArrayList<String> toReturn = new ArrayList<String>();
        if (type != null) {
            type.accept(new TypeVisitor(){

                @Override
                public void visitOWLType(OWLType owlType) {
                    if (OWLType.isClassExpression(owlType)) {
                        toReturn.addAll(AutoCompleteStrings.getIncompleteClassExpressionCompletions(incompleteText));
                    } else if (OWLType.isObjectPropertyExpression(owlType)) {
                        toReturn.addAll(AutoCompleteStrings.getIncompletePropertyCompletions(incompleteText));
                    } else if (owlType == OWLType.OWL_DATA_PROPERTY) {
                        toReturn.addAll(AutoCompleteStrings.getIncompletePropertyCompletions(incompleteText));
                    } else if (owlType == OWLType.OWL_INDIVIDUAL) {
                        toReturn.addAll(AutoCompleteStrings.getIncompleteIndividualCompletions(incompleteText));
                    }
                }

                @Override
                public void visitOWLAxiomType(OWLAxiomType owlAxiomType) {
                }

                @Override
                public void visitNonOWLType(Type t) {
                }
            });
        }
        return toReturn;
    }

    public static List<String> getExpressionCompletions(Type type) {
        final ArrayList<String> toReturn = new ArrayList<String>();
        if (type != null) {
            type.accept(new TypeVisitor(){

                @Override
                public void visitOWLType(OWLType owlType) {
                    if (OWLType.isClassExpression(owlType)) {
                        toReturn.addAll(AutoCompleteStrings.getClassExpressionCompletions());
                    } else if (OWLType.isObjectPropertyExpression(owlType)) {
                        toReturn.addAll(AutoCompleteStrings.getPropertyCompletions());
                    } else if (owlType == OWLType.OWL_DATA_PROPERTY) {
                        toReturn.addAll(AutoCompleteStrings.getPropertyCompletions());
                    }
                }

                @Override
                public void visitOWLAxiomType(OWLAxiomType owlAxiomType) {
                }

                @Override
                public void visitNonOWLType(Type t) {
                }
            });
        }
        return toReturn;
    }
}

