/*
 * Decompiled with CFR 0.152.
 */
package org.coode.oppl.utils;

import java.util.HashSet;
import java.util.Set;
import org.coode.oppl.ConstraintSystem;
import org.coode.oppl.Variable;
import org.coode.oppl.variabletypes.ANNOTATIONPROPERTYVariableType;
import org.coode.oppl.variabletypes.CLASSVariableType;
import org.coode.oppl.variabletypes.CONSTANTVariableType;
import org.coode.oppl.variabletypes.DATAPROPERTYVariableType;
import org.coode.oppl.variabletypes.INDIVIDUALVariableType;
import org.coode.oppl.variabletypes.OBJECTPROPERTYVariableType;
import org.coode.oppl.variabletypes.VariableTypeVisitorEx;

public class OPPLVariableMatcher {
    public static Set<Variable<?>> matches(String name, ConstraintSystem constraintSystem, final boolean matchClasses, final boolean matchObjectProperties, final boolean matchDataProperties, final boolean matchIndividuals, final boolean matchConstants, final boolean matchAnnotationProperty) {
        Set<Variable<?>> variables = constraintSystem.getVariables();
        HashSet toReturn = new HashSet(variables.size());
        VariableTypeVisitorEx<Boolean> visitor = new VariableTypeVisitorEx<Boolean>(){

            @Override
            public Boolean visitCLASSVariableType(CLASSVariableType classVariableType) {
                return matchClasses;
            }

            @Override
            public Boolean visitOBJECTPROPERTYVariableType(OBJECTPROPERTYVariableType objectpropertyVariableType) {
                return matchObjectProperties;
            }

            @Override
            public Boolean visitDATAPROPERTYVariableType(DATAPROPERTYVariableType datapropertyVariableType) {
                return matchDataProperties;
            }

            @Override
            public Boolean visitINDIVIDUALVariableType(INDIVIDUALVariableType individualVariableType) {
                return matchIndividuals;
            }

            @Override
            public Boolean visitCONSTANTVariableType(CONSTANTVariableType constantVariableType) {
                return matchConstants;
            }

            @Override
            public Boolean visitANNOTATIONPROPERTYVariableType(ANNOTATIONPROPERTYVariableType annotationpropertyVariableType) {
                return matchAnnotationProperty;
            }
        };
        for (Variable<?> variable : variables) {
            if (variable == null || !variable.getName().startsWith(name) || !variable.getType().accept(visitor).booleanValue()) continue;
            toReturn.add(variable);
        }
        return toReturn;
    }
}

