/*
 * Decompiled with CFR 0.152.
 */
package org.coode.oppl.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.coode.oppl.ConstraintSystem;
import org.coode.oppl.OPPLScript;
import org.coode.oppl.bindingtree.Assignment;
import org.coode.oppl.bindingtree.BindingNode;
import org.coode.oppl.rendering.ManchesterSyntaxRenderer;
import org.coode.oppl.utils.ArgCheck;
import org.semanticweb.owlapi.model.AddAxiom;
import org.semanticweb.owlapi.model.AddImport;
import org.semanticweb.owlapi.model.AddOntologyAnnotation;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLAxiomChange;
import org.semanticweb.owlapi.model.OWLObjectVisitor;
import org.semanticweb.owlapi.model.OWLOntologyChangeVisitorEx;
import org.semanticweb.owlapi.model.RemoveAxiom;
import org.semanticweb.owlapi.model.RemoveImport;
import org.semanticweb.owlapi.model.RemoveOntologyAnnotation;
import org.semanticweb.owlapi.model.SetOntologyID;
import org.semanticweb.owlapi.util.OWLOntologyChangeVisitorAdapterEx;

public class EvaluationResults {
    private final OPPLScript opplScript;
    private final List<OWLAxiomChange> changes = new ArrayList<OWLAxiomChange>();
    private final ChangeRenderer changeRenderer;

    public EvaluationResults(OPPLScript opplScript, List<OWLAxiomChange> changes) {
        this.opplScript = ArgCheck.checkNotNull(opplScript, "opplScript");
        this.changes.addAll((Collection<OWLAxiomChange>)ArgCheck.checkNotNull(changes, "changes"));
        this.changeRenderer = new ChangeRenderer();
    }

    public OPPLScript getOpplScript() {
        return this.opplScript;
    }

    public List<OWLAxiomChange> getChanges() {
        return new ArrayList<OWLAxiomChange>(this.changes);
    }

    public String toString() {
        StringBuilder out = new StringBuilder();
        out.append(String.format("Script: %s \n Bindings ", this.getOpplScript()));
        ConstraintSystem cs = this.getOpplScript().getConstraintSystem();
        if (cs.getLeaves() != null) {
            out.append(String.format(" count %d \n", cs.getLeaves().size()));
            for (BindingNode bindingNode : cs.getLeaves()) {
                for (Assignment assignment : bindingNode.getAssignments()) {
                    ManchesterSyntaxRenderer renderer = cs.getOPPLFactory().getManchesterSyntaxRenderer(cs);
                    assignment.getAssignment().accept((OWLObjectVisitor)renderer);
                    out.append(String.format("%s = %s\n", assignment.getAssignedVariable(), renderer));
                }
            }
            out.append("\n");
        } else {
            out.append(" (none) \n");
        }
        if (!this.changes.isEmpty()) {
            out.append(String.format("Change count %d \n", this.changes.size()));
            for (OWLAxiomChange change : this.changes) {
                out.append(String.format("%s \n", change.accept((OWLOntologyChangeVisitorEx)this.changeRenderer)));
            }
        }
        return out.toString();
    }

    private final class ChangeRenderer
    extends OWLOntologyChangeVisitorAdapterEx<String> {
        public String visit(AddAxiom change) {
            return String.format("ADD %s", this.renderAxiom(change.getAxiom()));
        }

        private String renderAxiom(OWLAxiom axiom) {
            ConstraintSystem cs = EvaluationResults.this.getOpplScript().getConstraintSystem();
            ManchesterSyntaxRenderer renderer = cs.getOPPLFactory().getManchesterSyntaxRenderer(cs);
            axiom.accept((OWLObjectVisitor)renderer);
            return renderer.toString();
        }

        public String visit(RemoveAxiom change) {
            return String.format("REMOVE %s", this.renderAxiom(change.getAxiom()));
        }

        public String visit(SetOntologyID change) {
            return String.format("CHANGE ONTOLOGY ID to %s", change.getNewOntologyID());
        }

        public String visit(RemoveImport change) {
            return String.format("REMOVE IMPORT %s", change.getImportDeclaration());
        }

        public String visit(AddImport change) {
            return String.format("ADD IMPORT %s", change.getImportDeclaration());
        }

        public String visit(AddOntologyAnnotation change) {
            return String.format("ADD Ontology Annotation %s", change.getAnnotation());
        }

        public String visit(RemoveOntologyAnnotation change) {
            return String.format("REMOVE Ontology Annotation %s", change.getAnnotation());
        }
    }
}

