/*
 * Decompiled with CFR 0.152.
 */
package org.coode.oppl.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.coode.oppl.search.SearchTree;
import org.coode.oppl.utils.PermutationState;

public class CollectionPermutation<N>
extends SearchTree<PermutationState<N>> {
    private CollectionPermutation() {
    }

    @Override
    protected List<PermutationState<N>> getChildren(PermutationState<N> node) {
        ArrayList<PermutationState<N>> toReturn = new ArrayList<PermutationState<N>>();
        HashSet<N> remainder = new HashSet<N>(node.getReferenceCollection());
        remainder.removeAll(node.getSequence());
        for (Object n : remainder) {
            ArrayList<N> newSequence = new ArrayList<N>(node.getSequence());
            newSequence.add(n);
            toReturn.add(new PermutationState<N>(node.getReferenceCollection(), newSequence));
        }
        return toReturn;
    }

    @Override
    protected boolean goalReached(PermutationState<N> node) {
        return node.isGoal();
    }

    public static <O> Set<List<O>> getAllPermutations(Collection<O> collection) {
        CollectionPermutation<PermutationState<O>> setPermutation = new CollectionPermutation<PermutationState<O>>();
        HashSet<List<O>> toReturn = new HashSet<List<O>>();
        ArrayList solutions = new ArrayList();
        setPermutation.exhaustiveSearchTree(new PermutationState<O>(collection, new ArrayList()), solutions);
        for (List list : solutions) {
            toReturn.add(((PermutationState)list.get(list.size() - 1)).getSequence());
        }
        return toReturn;
    }
}

