/*
 * Decompiled with CFR 0.152.
 */
package org.coode.oppl.similarity;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.coode.oppl.similarity.HashFunction;
import org.coode.oppl.utils.OWLObjectExtractor;
import org.coode.oppl.utils.PrimeNumbersUtils;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLObject;

public class SymbolBasedHashFunction
implements HashFunction {
    private final Map<OWLEntity, Integer> entityHashCodes = new HashMap<OWLEntity, Integer>();
    private final Map<OWLLiteral, Integer> owlConstantHashCodes = new HashMap<OWLLiteral, Integer>();
    private int maxPrime = 1;

    @Override
    public int getHashCode(OWLObject owlObject) {
        Set<OWLEntity> entities = OWLObjectExtractor.getAllOWLEntities(owlObject);
        int toReturn = 1;
        for (OWLEntity owlEntity : entities) {
            toReturn *= this.createHashCode(owlEntity);
        }
        Set<OWLLiteral> allOWLConstants = OWLObjectExtractor.getAllOWLLiterals(owlObject);
        for (OWLLiteral owlConstant : allOWLConstants) {
            toReturn *= this.createHashCode(owlConstant);
        }
        return toReturn;
    }

    protected int createHashCode(OWLLiteral constant) {
        return this.createHashCode(constant, this.owlConstantHashCodes);
    }

    protected int createHashCode(OWLEntity owlEntity) {
        return this.createHashCode(owlEntity, this.entityHashCodes);
    }

    private <O> int createHashCode(O key, Map<O, Integer> map) {
        int toReturn = PrimeNumbersUtils.getNextPrime(this.getMaxPrime());
        map.put(key, toReturn);
        this.setMaxPrime(toReturn);
        return toReturn;
    }

    public int getMaxPrime() {
        return this.maxPrime;
    }

    private void setMaxPrime(int maxPrime) {
        this.maxPrime = maxPrime;
    }
}

