/*
 * Decompiled with CFR 0.152.
 */
package org.coode.oppl.similarity;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.coode.oppl.similarity.SimilarityMeasure;
import org.coode.oppl.utils.ArgCheck;

public class ProgressiveSimilarityMeasure<O>
implements SimilarityMeasure<O> {
    private final List<SimilarityMeasure<O>> measureList = new ArrayList<SimilarityMeasure<O>>();

    public ProgressiveSimilarityMeasure(List<? extends SimilarityMeasure<O>> measures) {
        this.measureList.addAll((Collection)ArgCheck.checkNotNull(measures, "measures"));
        if (measures.isEmpty()) {
            throw new IllegalArgumentException("The measure list cannot be empty");
        }
    }

    @Override
    public boolean isSymmetric() {
        boolean notSymmetric = false;
        Iterator<SimilarityMeasure<O>> iterator = this.measureList.iterator();
        while (iterator.hasNext() && !notSymmetric) {
            SimilarityMeasure<O> similarityMeasure = iterator.next();
            notSymmetric = !similarityMeasure.isSymmetric();
        }
        return !notSymmetric;
    }

    @Override
    public double compare(O anObject, O anotherObject) {
        double toReturn = 1.0;
        boolean found = false;
        Iterator<SimilarityMeasure<O>> iterator = this.measureList.iterator();
        while (!found && iterator.hasNext()) {
            SimilarityMeasure<O> similarityMeasure = iterator.next();
            found = (toReturn *= similarityMeasure.compare(anObject, anotherObject)) != 1.0;
        }
        return toReturn;
    }

    public final List<SimilarityMeasure<O>> getMeasureList() {
        return new ArrayList<SimilarityMeasure<O>>(this.measureList);
    }
}

