/*
 * Decompiled with CFR 0.152.
 */
package org.coode.oppl.search;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.coode.oppl.ConstraintSystem;
import org.coode.oppl.PartialOWLObjectInstantiator;
import org.coode.oppl.Variable;
import org.coode.oppl.VariableScope;
import org.coode.oppl.bindingtree.Assignment;
import org.coode.oppl.bindingtree.BindingNode;
import org.coode.oppl.exceptions.RuntimeExceptionHandler;
import org.coode.oppl.function.SimpleValueComputationParameters;
import org.coode.oppl.function.ValueComputationParameters;
import org.coode.oppl.search.AssignableValueExtractor;
import org.coode.oppl.search.OPPLOWLAxiomSearchNode;
import org.coode.oppl.search.SearchTree;
import org.coode.oppl.utils.AbstractVariableVisitorExAdapter;
import org.coode.oppl.utils.ArgCheck;
import org.coode.oppl.utils.OWLObjectExtractor;
import org.coode.oppl.variabletypes.ANNOTATIONPROPERTYVariableType;
import org.coode.oppl.variabletypes.CLASSVariableType;
import org.coode.oppl.variabletypes.CONSTANTVariableType;
import org.coode.oppl.variabletypes.DATAPROPERTYVariableType;
import org.coode.oppl.variabletypes.INDIVIDUALVariableType;
import org.coode.oppl.variabletypes.InputVariable;
import org.coode.oppl.variabletypes.OBJECTPROPERTYVariableType;
import org.coode.oppl.variabletypes.VariableTypeVisitorEx;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotationAssertionAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLAnnotationSubject;
import org.semanticweb.owlapi.model.OWLAnnotationSubjectVisitor;
import org.semanticweb.owlapi.model.OWLAnonymousIndividual;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLAxiomVisitor;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLEntityVisitor;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLObjectVisitorEx;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLRuntimeException;
import org.semanticweb.owlapi.util.OWLAxiomVisitorAdapter;

public class OPPLAssertedSingleOWLAxiomSearchTree
extends SearchTree<OPPLOWLAxiomSearchNode> {
    protected final ConstraintSystem constraintSystem;
    protected final RuntimeExceptionHandler runtimeExceptionHandler;
    protected final OWLAxiom targetAxiom;
    protected final Set<OWLClass> allClasses = new HashSet<OWLClass>();
    protected final Set<OWLObjectProperty> allObjectProperties = new HashSet<OWLObjectProperty>();
    protected final Set<OWLDataProperty> allDataProperties = new HashSet<OWLDataProperty>();
    protected final Set<OWLIndividual> allIndividuals = new HashSet<OWLIndividual>();
    protected final Set<OWLLiteral> allConstants = new HashSet<OWLLiteral>();
    protected final Set<OWLAnnotationProperty> allAnnotationProperties = new HashSet<OWLAnnotationProperty>();
    private final VariableTypeVisitorEx<Set<? extends OWLObject>> assignableValuesVisitor = new VariableTypeVisitorEx<Set<? extends OWLObject>>(){

        @Override
        public Set<? extends OWLObject> visitCLASSVariableType(CLASSVariableType classVariableType) {
            return OPPLAssertedSingleOWLAxiomSearchTree.this.allClasses;
        }

        @Override
        public Set<? extends OWLObject> visitOBJECTPROPERTYVariableType(OBJECTPROPERTYVariableType objectpropertyVariableType) {
            return OPPLAssertedSingleOWLAxiomSearchTree.this.allObjectProperties;
        }

        @Override
        public Set<? extends OWLObject> visitDATAPROPERTYVariableType(DATAPROPERTYVariableType datapropertyVariableType) {
            return OPPLAssertedSingleOWLAxiomSearchTree.this.allDataProperties;
        }

        @Override
        public Set<? extends OWLObject> visitINDIVIDUALVariableType(INDIVIDUALVariableType individualVariableType) {
            return OPPLAssertedSingleOWLAxiomSearchTree.this.allIndividuals;
        }

        @Override
        public Set<? extends OWLObject> visitCONSTANTVariableType(CONSTANTVariableType constantVariableType) {
            return OPPLAssertedSingleOWLAxiomSearchTree.this.allConstants;
        }

        @Override
        public Set<? extends OWLObject> visitANNOTATIONPROPERTYVariableType(ANNOTATIONPROPERTYVariableType annotationpropertyVariableType) {
            return OPPLAssertedSingleOWLAxiomSearchTree.this.allAnnotationProperties;
        }
    };

    public OPPLAssertedSingleOWLAxiomSearchTree(OWLAxiom targetAxiom, ConstraintSystem constraintSystem, RuntimeExceptionHandler runtimeExceptionHandler) {
        this.constraintSystem = ArgCheck.checkNotNull(constraintSystem, "constraintSystem");
        this.runtimeExceptionHandler = ArgCheck.checkNotNull(runtimeExceptionHandler, "runtimeExceptionHandler");
        this.targetAxiom = targetAxiom;
        this.initAssignableValues();
    }

    @Override
    protected List<OPPLOWLAxiomSearchNode> getChildren(OPPLOWLAxiomSearchNode node) {
        ArrayList<OPPLOWLAxiomSearchNode> toReturn = new ArrayList<OPPLOWLAxiomSearchNode>();
        Set<Variable<?>> variables = node.getBinding().getUnassignedVariables();
        BindingNode binding = node.getBinding();
        SimpleValueComputationParameters parameters = new SimpleValueComputationParameters(this.getConstraintSystem(), binding, this.getRuntimeExceptionHandler());
        if (!variables.isEmpty()) {
            Variable<?> variable = variables.iterator().next();
            HashSet<? extends OWLObject> values = new HashSet<OWLObject>(this.getAssignableValues(variable, parameters));
            for (OWLObject oWLObject : values) {
                Assignment assignment = new Assignment(variable, oWLObject);
                BindingNode childBinding = new BindingNode(binding);
                childBinding.addAssignment(assignment);
                SimpleValueComputationParameters childParameters = new SimpleValueComputationParameters(this.getConstraintSystem(), childBinding, this.getRuntimeExceptionHandler());
                PartialOWLObjectInstantiator instantiator = new PartialOWLObjectInstantiator(childParameters);
                OWLAxiom instantiatedAxiom = (OWLAxiom)node.getAxiom().accept((OWLObjectVisitorEx)instantiator);
                OPPLOWLAxiomSearchNode child = new OPPLOWLAxiomSearchNode(instantiatedAxiom, childBinding);
                toReturn.add(child);
            }
        }
        return toReturn;
    }

    @Override
    protected boolean goalReached(OPPLOWLAxiomSearchNode start) {
        return this.targetAxiom.getAxiomWithoutAnnotations().equals(start.getAxiom());
    }

    private Collection<? extends OWLObject> getAssignableValues(Variable<?> variable, ValueComputationParameters parameters) {
        HashSet toReturn = new HashSet();
        toReturn.addAll(variable.accept(new AssignableValueExtractor(this.assignableValuesVisitor, parameters)));
        Iterator iterator = toReturn.iterator();
        while (iterator.hasNext()) {
            final OWLObject owlObject = (OWLObject)iterator.next();
            boolean inScope = variable.accept(new AbstractVariableVisitorExAdapter<Boolean>(Boolean.valueOf(true)){

                @Override
                public <P extends OWLObject> Boolean visit(InputVariable<P> v) {
                    VariableScope<?> variableScope = v.getVariableScope();
                    try {
                        return variableScope == null || variableScope.check(owlObject);
                    }
                    catch (OWLRuntimeException e) {
                        OPPLAssertedSingleOWLAxiomSearchTree.this.getRuntimeExceptionHandler().handleOWLRuntimeException(e);
                        return false;
                    }
                }
            });
            if (inScope) continue;
            iterator.remove();
        }
        return toReturn;
    }

    private void initAssignableValues() {
        this.extractFromLogicAxiom();
        this.getTargetAxiom().accept((OWLAxiomVisitor)new OWLAxiomVisitorAdapter(){

            protected void handleDefault(OWLAxiom owlObject) {
                OPPLAssertedSingleOWLAxiomSearchTree.this.extractFromLogicAxiom();
            }

            public void visit(OWLAnnotationAssertionAxiom axiom) {
                OPPLAssertedSingleOWLAxiomSearchTree.this.extractFromLogicAxiom();
                OWLAnnotationSubject subject = axiom.getSubject();
                subject.accept(new OWLAnnotationSubjectVisitor(){

                    public void visit(OWLAnonymousIndividual individual) {
                    }

                    public void visit(IRI iri) {
                        Set ontologies = OPPLAssertedSingleOWLAxiomSearchTree.this.getConstraintSystem().getOntologyManager().getOntologies();
                        for (OWLOntology ontology : ontologies) {
                            Set entitiesInSignature = ontology.getEntitiesInSignature(iri);
                            for (OWLEntity entity : entitiesInSignature) {
                                entity.accept(new OWLEntityVisitor(){

                                    public void visit(OWLAnnotationProperty property) {
                                    }

                                    public void visit(OWLDatatype datatype) {
                                    }

                                    public void visit(OWLNamedIndividual individual) {
                                        OPPLAssertedSingleOWLAxiomSearchTree.this.allIndividuals.add((OWLIndividual)individual);
                                    }

                                    public void visit(OWLDataProperty property) {
                                        OPPLAssertedSingleOWLAxiomSearchTree.this.allDataProperties.add(property);
                                    }

                                    public void visit(OWLObjectProperty property) {
                                        OPPLAssertedSingleOWLAxiomSearchTree.this.allObjectProperties.add(property);
                                    }

                                    public void visit(OWLClass cls) {
                                        OPPLAssertedSingleOWLAxiomSearchTree.this.allClasses.add(cls);
                                    }
                                });
                            }
                        }
                    }
                });
            }
        });
    }

    protected void extractFromLogicAxiom() {
        this.allClasses.addAll(OWLObjectExtractor.getAllClasses((OWLObject)this.getTargetAxiom()));
        this.allDataProperties.addAll(OWLObjectExtractor.getAllOWLDataProperties((OWLObject)this.getTargetAxiom()));
        this.allObjectProperties.addAll(OWLObjectExtractor.getAllOWLObjectProperties((OWLObject)this.getTargetAxiom()));
        this.allIndividuals.addAll(OWLObjectExtractor.getAllOWLIndividuals((OWLObject)this.getTargetAxiom()));
        this.allConstants.addAll(OWLObjectExtractor.getAllOWLLiterals((OWLObject)this.getTargetAxiom()));
        this.allAnnotationProperties.addAll(OWLObjectExtractor.getAllAnnotationProperties((OWLObject)this.getTargetAxiom()));
    }

    public ConstraintSystem getConstraintSystem() {
        return this.constraintSystem;
    }

    @Override
    public boolean exhaustiveSearchTree(OPPLOWLAxiomSearchNode start, List<List<OPPLOWLAxiomSearchNode>> solutions) {
        ArgCheck.checkNotNull(start, "start");
        ArgCheck.checkNotNull(solutions, "solutions");
        boolean found = false;
        if (this.getTargetAxiom().getAxiomType().equals(start.getAxiom().getAxiomType())) {
            found = super.exhaustiveSearchTree(start, solutions);
        }
        return found;
    }

    public OWLAxiom getTargetAxiom() {
        return this.targetAxiom;
    }

    public RuntimeExceptionHandler getRuntimeExceptionHandler() {
        return this.runtimeExceptionHandler;
    }
}

