/*
 * Decompiled with CFR 0.152.
 */
package org.coode.oppl.generated;

import org.coode.oppl.ConstraintSystem;
import org.coode.oppl.Variable;
import org.coode.oppl.VariableVisitor;
import org.coode.oppl.VariableVisitorEx;
import org.coode.oppl.function.OPPLFunction;
import org.coode.oppl.utils.ArgCheck;
import org.coode.oppl.variabletypes.VariableType;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLObject;

public class GeneratedVariable<O extends OWLObject>
implements Variable<O> {
    private final OPPLFunction<? extends O> opplFunction;
    private final String name;
    private final IRI iri;
    private final VariableType<O> type;

    protected GeneratedVariable(String name, VariableType<O> type, OPPLFunction<? extends O> opplFunction) {
        this.name = ArgCheck.checkNotNull(name, "name");
        this.type = ArgCheck.checkNotNull(type, "type");
        this.opplFunction = ArgCheck.checkNotNull(opplFunction, "opplFunction");
        this.iri = IRI.create((String)("http://www.coode.org/oppl/variablemansyntax#" + this.getName()));
    }

    @Override
    public String render(ConstraintSystem constraintSystem) {
        return String.format("%s:%s = %s", this.getName(), this.getType(), this.getOPPLFunction().render(constraintSystem));
    }

    public String toString() {
        return String.format("%s:%s", this.getName(), this.getType());
    }

    public OPPLFunction<? extends O> getOPPLFunction() {
        return this.opplFunction;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public IRI getIRI() {
        return this.iri;
    }

    @Override
    public VariableType<O> getType() {
        return this.type;
    }

    @Override
    public void accept(VariableVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T accept(VariableVisitorEx<T> visitor) {
        return visitor.visit(this);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GeneratedVariable other = (GeneratedVariable)obj;
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        return !(this.type == null ? other.type != null : !this.type.equals(other.type));
    }

    public static <P extends OWLObject> GeneratedVariable<P> getGeneratedVariable(String name, VariableType<P> type, OPPLFunction<? extends P> opplFunction) {
        return new GeneratedVariable<P>(name, type, opplFunction);
    }
}

