/*
 * Decompiled with CFR 0.152.
 */
package org.coode.oppl.function;

import org.coode.oppl.ConstraintSystem;
import org.coode.oppl.Variable;
import org.coode.oppl.function.AbstractOPPLFunction;
import org.coode.oppl.function.AttributeName;
import org.coode.oppl.function.OPPLFunction;
import org.coode.oppl.utils.ArgCheck;
import org.semanticweb.owlapi.util.ShortFormProvider;

public abstract class VariableAttribute<O>
extends AbstractOPPLFunction<O>
implements OPPLFunction<O> {
    private final Variable<?> variable;
    private final AttributeName attribute;

    public VariableAttribute(Variable<?> variable, AttributeName attribute) {
        this.variable = ArgCheck.checkNotNull(variable, "variable");
        this.attribute = ArgCheck.checkNotNull(attribute, "attribute");
    }

    public Variable<?> getVariable() {
        return this.variable;
    }

    public AttributeName getAttribute() {
        return this.attribute;
    }

    public String toString() {
        return String.format("%s.%s", new Object[]{this.getVariable().getName(), this.getAttribute()});
    }

    @Override
    public String render(ConstraintSystem constraintSystem) {
        return this.toString();
    }

    @Override
    public String render(ShortFormProvider shortFormProvider) {
        return this.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.attribute == null ? 0 : this.attribute.hashCode());
        result = 31 * result + (this.variable == null ? 0 : this.variable.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        VariableAttribute other = (VariableAttribute)obj;
        if (this.attribute != other.attribute) {
            return false;
        }
        return !(this.variable == null ? other.variable != null : !this.variable.equals(other.variable));
    }
}

