/*
 * Decompiled with CFR 0.152.
 */
package org.coode.oppl.function;

import java.util.regex.Matcher;
import org.coode.oppl.ConstraintSystem;
import org.coode.oppl.Variable;
import org.coode.oppl.exceptions.RuntimeExceptionHandler;
import org.coode.oppl.function.AttributeName;
import org.coode.oppl.function.OPPLFunction;
import org.coode.oppl.function.OPPLFunctionVisitor;
import org.coode.oppl.function.OPPLFunctionVisitorEx;
import org.coode.oppl.function.ValueComputation;
import org.coode.oppl.function.ValueComputationParameters;
import org.coode.oppl.function.VariableAttribute;
import org.coode.oppl.generated.RegexpGeneratedVariable;
import org.coode.oppl.rendering.ManchesterSyntaxRenderer;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLObjectVisitor;
import org.semanticweb.owlapi.util.ShortFormProvider;

public class GroupVariableAttribute<O extends OWLObject>
extends VariableAttribute<String> {
    protected final int index;
    private final RegexpGeneratedVariable<O> regexpGeneratedVariable;

    public GroupVariableAttribute(RegexpGeneratedVariable<O> variable, int index) {
        super(variable, AttributeName.GROUPS);
        if (index < 0) {
            throw new IllegalArgumentException(String.format("Invalid index %d", index));
        }
        this.index = index;
        this.regexpGeneratedVariable = variable;
    }

    public int getIndex() {
        return this.index;
    }

    @Override
    public void accept(OPPLFunctionVisitor visitor) {
        visitor.visitGroupVariableAttribute(this);
    }

    @Override
    public <P> P accept(OPPLFunctionVisitorEx<P> visitor) {
        return visitor.visitGroupVariableAttribute(this);
    }

    @Override
    public ValueComputation<String> getValueComputation(final ValueComputationParameters parameters) {
        return new ValueComputation<String>(){

            @Override
            public String compute(OPPLFunction<? extends String> opplFunction) {
                String toReturn = null;
                OWLObject assignmentValue = parameters.getBindingNode().getAssignmentValue(GroupVariableAttribute.this.getVariable(), parameters);
                if (assignmentValue != null) {
                    ManchesterSyntaxRenderer renderer = parameters.getConstraintSystem().getOPPLFactory().getManchesterSyntaxRenderer(parameters.getConstraintSystem());
                    assignmentValue.accept((OWLObjectVisitor)renderer);
                    Matcher matcher = GroupVariableAttribute.this.getRegexpGeneratedVariable().getPatternGeneratingOPPLFunction().compute(parameters).matcher(renderer.toString());
                    if (matcher.matches() && matcher.groupCount() >= GroupVariableAttribute.this.index) {
                        toReturn = matcher.group(GroupVariableAttribute.this.index);
                    }
                }
                return toReturn;
            }
        };
    }

    @Override
    public String toString() {
        return String.format("%s.%s(%d)", new Object[]{this.getVariable().getName(), this.getAttribute(), this.getIndex()});
    }

    @Override
    public String render(ConstraintSystem constraintSystem) {
        return this.toString();
    }

    @Override
    public String render(ShortFormProvider shortFormProvider) {
        return this.toString();
    }

    public RegexpGeneratedVariable<O> getRegexpGeneratedVariable() {
        return this.regexpGeneratedVariable;
    }

    public static <P extends OWLObject> GroupVariableAttribute<P> getGroupVariableAttribute(RegexpGeneratedVariable<P> variable, int index) {
        return new GroupVariableAttribute<P>(variable, index);
    }

    public OPPLFunction<String> replace(Variable<?> v, OWLObject owlObject, ConstraintSystem constraintSystem, RuntimeExceptionHandler handler) {
        return this;
    }
}

