/*
 * Decompiled with CFR 0.152.
 */
package org.coode.oppl.function;

import java.util.Collection;
import java.util.HashSet;
import org.coode.oppl.ConstraintSystem;
import org.coode.oppl.function.Aggregandum;
import org.coode.oppl.function.Aggregation;
import org.coode.oppl.function.OPPLFunction;
import org.coode.oppl.function.ValueComputationParameters;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.util.ShortFormProvider;

class ClassIntersectionAggregation
extends Aggregation<OWLClassExpression, Collection<? extends OWLClassExpression>> {
    private final OWLDataFactory dataFactory;

    ClassIntersectionAggregation(Collection<? extends Aggregandum<Collection<? extends OWLClassExpression>>> toAggregate, OWLDataFactory dataFactory) {
        super(toAggregate);
        this.dataFactory = dataFactory;
    }

    @Override
    protected OWLClassExpression aggregate(ValueComputationParameters parameters) {
        HashSet operands = new HashSet();
        for (Aggregandum aggregandum : this.toAggregate) {
            for (OPPLFunction opplFunction : aggregandum.getOPPLFunctions()) {
                Collection compute = (Collection)opplFunction.compute(parameters);
                if (compute == null) continue;
                operands.addAll(compute);
            }
        }
        return operands.isEmpty() ? null : this.dataFactory.getOWLObjectIntersectionOf(operands);
    }

    @Override
    public String render(ConstraintSystem constraintSystem) {
        return this.renderAggregation(constraintSystem, "createIntersection", "(", ", ", ")");
    }

    @Override
    public String render(ShortFormProvider shortFormProvider) {
        return this.renderAggregation(shortFormProvider, "createIntersection", "(", ", ", ")");
    }
}

