/*
 * Decompiled with CFR 0.152.
 */
package org.coode.oppl.bindingtree;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.coode.oppl.Variable;
import org.coode.oppl.bindingtree.Assignment;
import org.coode.oppl.bindingtree.BindingNode;
import org.coode.oppl.utils.ArgCheck;
import org.semanticweb.owlapi.model.OWLObject;

public class AssignmentMap
implements Map<Variable<?>, Set<OWLObject>> {
    private final Map<Variable<?>, Set<OWLObject>> delegate = new HashMap();
    private final Set<BindingNode> bindingNodes = new HashSet<BindingNode>();

    public AssignmentMap(AssignmentMap assignmentMap) {
        ArgCheck.checkNotNull(assignmentMap, "assignmentMap");
        this.bindingNodes.addAll(assignmentMap.bindingNodes);
        this.delegate.putAll(assignmentMap.delegate);
    }

    public AssignmentMap(Collection<? extends BindingNode> bindingNodes) {
        if (bindingNodes == null || bindingNodes.isEmpty()) {
            return;
        }
        this.bindingNodes.addAll(bindingNodes);
        for (BindingNode bindingNode : bindingNodes) {
            for (Assignment assignment : bindingNode.getAssignments()) {
                Variable<?> assignedVariable = assignment.getAssignedVariable();
                OWLObject assignedValue = assignment.getAssignment();
                HashSet<OWLObject> previousAssignements = this.get(assignedVariable);
                if (previousAssignements == null) {
                    previousAssignements = new HashSet<OWLObject>();
                    this.put(assignedVariable, (Set<OWLObject>)previousAssignements);
                }
                previousAssignements.add(assignedValue);
            }
        }
    }

    @Override
    public int size() {
        return this.delegate.size();
    }

    @Override
    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.delegate.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.delegate.containsValue(value);
    }

    @Override
    public Set<OWLObject> get(Object key) {
        return this.delegate.get(key);
    }

    @Override
    public Set<OWLObject> put(Variable<?> key, Set<OWLObject> value) {
        return this.delegate.put(key, value);
    }

    @Override
    public Set<OWLObject> remove(Object key) {
        return this.delegate.remove(key);
    }

    @Override
    public void putAll(Map<? extends Variable<?>, ? extends Set<OWLObject>> arg0) {
        this.delegate.putAll(arg0);
    }

    @Override
    public void clear() {
        this.delegate.clear();
    }

    @Override
    public Set<Variable<?>> keySet() {
        return this.delegate.keySet();
    }

    @Override
    public Collection<Set<OWLObject>> values() {
        return this.delegate.values();
    }

    @Override
    public Set<Map.Entry<Variable<?>, Set<OWLObject>>> entrySet() {
        return this.delegate.entrySet();
    }

    @Override
    public boolean equals(Object o) {
        return this.delegate.equals(o);
    }

    @Override
    public int hashCode() {
        return this.delegate.hashCode();
    }

    public Set<Variable<?>> getVariables() {
        return new HashSet(this.keySet());
    }

    public Set<BindingNode> getBindingNodes() {
        return new HashSet<BindingNode>(this.bindingNodes);
    }

    public boolean isDisjointWith(AssignmentMap anotherAssignmentMap) {
        ArgCheck.checkNotNull(anotherAssignmentMap, "anotherAssignmentMap");
        boolean found = false;
        Iterator<Variable<?>> iterator = this.keySet().iterator();
        while (!found && iterator.hasNext()) {
            Variable<?> variable = iterator.next();
            if (!anotherAssignmentMap.keySet().contains(variable)) continue;
            HashSet set = new HashSet(this.get(variable));
            set.retainAll((Collection<?>)anotherAssignmentMap.get(variable));
            found = !set.isEmpty();
        }
        return !found;
    }

    public static boolean areDisjoint(Collection<? extends AssignmentMap> assignmentMaps) {
        ArgCheck.checkNotNull(assignmentMaps, "assignmentMaps");
        if (assignmentMaps.isEmpty()) {
            throw new IllegalArgumentException("The collection of AssignmentMap cannot be empty");
        }
        boolean found = false;
        Iterator<? extends AssignmentMap> iterator = assignmentMaps.iterator();
        while (!found && iterator.hasNext()) {
            AssignmentMap assignmentMap = iterator.next();
            Iterator<? extends AssignmentMap> anotherIterator = assignmentMaps.iterator();
            while (!found && anotherIterator.hasNext()) {
                AssignmentMap anotherAssignmentMap = anotherIterator.next();
                if (assignmentMap == anotherAssignmentMap) continue;
                found = assignmentMap.isDisjointWith(anotherAssignmentMap);
            }
        }
        return found;
    }

    public String toString() {
        return this.delegate.toString();
    }
}

