/*
 * Decompiled with CFR 0.152.
 */
package org.coode.oppl.bindingtree;

import org.coode.oppl.Variable;
import org.coode.oppl.utils.ArgCheck;
import org.coode.oppl.variabletypes.VariableTypeFactory;
import org.semanticweb.owlapi.model.OWLObject;

public class Assignment {
    private final Variable<?> assignedVariable;
    private final OWLObject assignment;

    public Assignment(Variable<?> assignedVariable, OWLObject assignment) {
        this.assignedVariable = ArgCheck.checkNotNull(assignedVariable, "assignedVariable");
        this.assignment = ArgCheck.checkNotNull(assignment, "assignment");
        if (VariableTypeFactory.getVariableType(assignment) != assignedVariable.getType()) {
            throw new IllegalArgumentException("The assigned value is incompatible with the variable it is assigned to: " + assignment.getClass() + " " + VariableTypeFactory.getVariableType(assignment) + " " + assignedVariable.getType());
        }
    }

    public Variable<?> getAssignedVariable() {
        return this.assignedVariable;
    }

    public OWLObject getAssignment() {
        return this.assignment;
    }

    public String toString() {
        return this.assignedVariable.getName() + "=" + this.assignment.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.assignedVariable.hashCode();
        result = 31 * result + this.assignment.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Assignment other = (Assignment)obj;
        if (!this.assignedVariable.equals(other.assignedVariable)) {
            return false;
        }
        return this.assignment.equals(other.assignment);
    }
}

