/*
 * Decompiled with CFR 0.152.
 */
package org.coode.oppl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import org.coode.oppl.AbstractConstraint;
import org.coode.oppl.ConstraintSystem;
import org.coode.oppl.ConstraintVisitorEx;
import org.coode.oppl.ExecutionMonitor;
import org.coode.oppl.InCollectionConstraint;
import org.coode.oppl.InequalityConstraint;
import org.coode.oppl.NAFConstraint;
import org.coode.oppl.OPPLAbstractFactory;
import org.coode.oppl.OPPLQuery;
import org.coode.oppl.OWLObjectInstantiator;
import org.coode.oppl.RegExpConstraint;
import org.coode.oppl.Variable;
import org.coode.oppl.bindingtree.BindingNode;
import org.coode.oppl.exceptions.RuntimeExceptionHandler;
import org.coode.oppl.function.OPPLFunction;
import org.coode.oppl.function.SimpleValueComputationParameters;
import org.coode.oppl.queryplanner.AbstractQueryPlannerItem;
import org.coode.oppl.queryplanner.AssertedAxiomPlannerItem;
import org.coode.oppl.queryplanner.ComplexityEstimate;
import org.coode.oppl.queryplanner.ConstraintQueryPlannerItem;
import org.coode.oppl.queryplanner.InferredAxiomQueryPlannerItem;
import org.coode.oppl.queryplanner.QueryPlannerItem;
import org.coode.oppl.rendering.ManchesterSyntaxRenderer;
import org.coode.oppl.utils.ArgCheck;
import org.coode.oppl.utils.VariableExtractor;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLException;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLObjectVisitor;
import org.semanticweb.owlapi.model.OWLObjectVisitorEx;
import org.semanticweb.owlapi.model.OWLOntologyChange;
import org.semanticweb.owlapi.model.OWLOntologyChangeListener;
import org.semanticweb.owlapi.model.OWLRuntimeException;
import org.semanticweb.owlapi.util.ShortFormProvider;

public class OPPLQueryImpl
implements OPPLQuery {
    private final List<OWLAxiom> axioms = new ArrayList<OWLAxiom>();
    private final List<OWLAxiom> assertedAxioms = new ArrayList<OWLAxiom>();
    private final Set<AbstractConstraint> constraints = new HashSet<AbstractConstraint>();
    private final ConstraintSystem constraintSystem;
    private boolean dirty = true;
    private final OWLOntologyChangeListener listener = new OWLOntologyChangeListener(){

        public void ontologiesChanged(List<? extends OWLOntologyChange> changes) throws OWLException {
            OPPLQueryImpl.this.setDirty(true);
        }
    };
    private final OPPLAbstractFactory factory;

    public OPPLQueryImpl(OPPLQuery query, OPPLAbstractFactory factory) {
        this(query.getConstraintSystem(), factory);
        for (OWLAxiom assertedAxiom : query.getAssertedAxioms()) {
            this.addAssertedAxiom(assertedAxiom);
        }
        for (OWLAxiom axiom : query.getAxioms()) {
            this.addAxiom(axiom);
        }
        for (AbstractConstraint constraint : query.getConstraints()) {
            this.addConstraint(constraint);
        }
    }

    public OPPLQueryImpl(ConstraintSystem constraintSystem, OPPLAbstractFactory factory) {
        this.constraintSystem = ArgCheck.checkNotNull(constraintSystem, "constraintSystem");
        constraintSystem.getOntologyManager().addOntologyChangeListener(this.listener);
        this.factory = ArgCheck.checkNotNull(factory);
    }

    @Override
    public void addAssertedAxiom(OWLAxiom axiom) {
        ArgCheck.checkNotNull(axiom, "axiom");
        this.assertedAxioms.add(axiom);
    }

    @Override
    public void addAxiom(OWLAxiom axiom) {
        ArgCheck.checkNotNull(axiom, "axiom");
        this.axioms.add(axiom);
    }

    @Override
    public void addConstraint(AbstractConstraint constraint) {
        ArgCheck.checkNotNull(constraint, "constraint");
        this.constraints.add(constraint);
    }

    @Override
    public List<OWLAxiom> getAxioms() {
        return new ArrayList<OWLAxiom>(this.axioms);
    }

    @Override
    public List<OWLAxiom> getAssertedAxioms() {
        return new ArrayList<OWLAxiom>(this.assertedAxioms);
    }

    @Override
    public List<AbstractConstraint> getConstraints() {
        return new ArrayList<AbstractConstraint>(this.constraints);
    }

    public String toString() {
        ManchesterSyntaxRenderer renderer;
        StringBuffer buffer = new StringBuffer("SELECT ");
        int i = 0;
        for (OWLAxiom axiom : this.assertedAxioms) {
            renderer = this.factory.getManchesterSyntaxRenderer(this.constraintSystem);
            buffer.append("ASSERTED ");
            axiom.accept((OWLObjectVisitor)renderer);
            buffer.append(renderer.toString());
            if (i < this.assertedAxioms.size() - 1) {
                buffer.append(",");
            }
            buffer.append('\n');
            ++i;
        }
        i = 0;
        for (OWLAxiom axiom : this.axioms) {
            renderer = this.factory.getManchesterSyntaxRenderer(this.constraintSystem);
            axiom.accept((OWLObjectVisitor)renderer);
            buffer.append(renderer.toString());
            if (i < this.axioms.size() - 1) {
                buffer.append(",");
            }
            buffer.append('\n');
            ++i;
        }
        if (this.constraints.size() > 0) {
            buffer.append(" WHERE ");
            i = 0;
            for (AbstractConstraint c : this.constraints) {
                buffer.append(c.render(this.getConstraintSystem()));
                if (i < this.constraints.size() - 1) {
                    buffer.append(",");
                }
                buffer.append('\n');
                ++i;
            }
        }
        return buffer.toString();
    }

    @Override
    public String render(ShortFormProvider shortFormProvider) {
        ManchesterSyntaxRenderer renderer;
        StringBuffer buffer = new StringBuffer("SELECT ");
        int i = 0;
        for (OWLAxiom axiom : this.assertedAxioms) {
            renderer = new ManchesterSyntaxRenderer(shortFormProvider);
            buffer.append("ASSERTED ");
            axiom.accept((OWLObjectVisitor)renderer);
            buffer.append(renderer.toString());
            if (i < this.assertedAxioms.size() - 1) {
                buffer.append(",");
            }
            buffer.append('\n');
            ++i;
        }
        i = 0;
        for (OWLAxiom axiom : this.axioms) {
            renderer = new ManchesterSyntaxRenderer(shortFormProvider);
            axiom.accept((OWLObjectVisitor)renderer);
            buffer.append(renderer.toString());
            if (i < this.axioms.size() - 1) {
                buffer.append(",");
            }
            buffer.append('\n');
            ++i;
        }
        if (this.constraints.size() > 0) {
            buffer.append(" WHERE ");
            i = 0;
            for (AbstractConstraint c : this.constraints) {
                buffer.append(c.render(shortFormProvider));
                if (i < this.constraints.size() - 1) {
                    buffer.append(",");
                }
                buffer.append('\n');
                ++i;
            }
        }
        return buffer.toString();
    }

    @Override
    public String render(ConstraintSystem cs) {
        return this.render();
    }

    @Override
    public String render() {
        ManchesterSyntaxRenderer renderer;
        StringBuffer buffer = new StringBuffer("SELECT ");
        int i = 0;
        for (OWLAxiom axiom : this.assertedAxioms) {
            renderer = this.factory.getManchesterSyntaxRenderer(this.constraintSystem);
            buffer.append("ASSERTED ");
            axiom.accept((OWLObjectVisitor)renderer);
            buffer.append(renderer.toString());
            if (i < this.assertedAxioms.size() - 1) {
                buffer.append(",");
            }
            buffer.append('\n');
            ++i;
        }
        i = 0;
        for (OWLAxiom axiom : this.axioms) {
            renderer = this.factory.getManchesterSyntaxRenderer(this.constraintSystem);
            axiom.accept((OWLObjectVisitor)renderer);
            buffer.append(renderer.toString());
            if (i < this.axioms.size() - 1) {
                buffer.append(",");
            }
            buffer.append('\n');
            ++i;
        }
        if (this.constraints.size() > 0) {
            buffer.append("\nWHERE ");
            i = 0;
            for (AbstractConstraint c : this.constraints) {
                buffer.append(c.render(this.getConstraintSystem()));
                if (i < this.constraints.size() - 1) {
                    buffer.append(",");
                }
                buffer.append('\n');
                ++i;
            }
        }
        return buffer.toString();
    }

    @Override
    public ConstraintSystem getConstraintSystem() {
        return this.constraintSystem;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.assertedAxioms == null ? 0 : this.assertedAxioms.hashCode());
        result = 31 * result + (this.axioms == null ? 0 : this.axioms.hashCode());
        result = 31 * result + (this.constraints == null ? 0 : this.constraints.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OPPLQueryImpl other = (OPPLQueryImpl)obj;
        if (this.assertedAxioms == null ? other.assertedAxioms != null : !this.assertedAxioms.equals(other.assertedAxioms)) {
            return false;
        }
        if (this.axioms == null ? other.axioms != null : !this.axioms.equals(other.axioms)) {
            return false;
        }
        return !(this.constraints == null ? other.constraints != null : !this.constraints.equals(other.constraints));
    }

    @Override
    public void execute(Collection<? extends BindingNode> leaves, RuntimeExceptionHandler runtimeExceptionHandler, ExecutionMonitor executionMonitor) {
        try {
            this.constraintSystem.setLeaves(new HashSet<BindingNode>(leaves));
            this.doExecute(runtimeExceptionHandler, false, executionMonitor);
            this.setDirty(false);
        }
        catch (OWLRuntimeException e) {
            runtimeExceptionHandler.handleOWLRuntimeException(e);
        }
    }

    @Override
    public void execute(RuntimeExceptionHandler runtimeExceptionHandler, ExecutionMonitor executionMonitor) {
        if (this.isDirty()) {
            try {
                this.doExecute(runtimeExceptionHandler, true, executionMonitor);
                this.setDirty(executionMonitor.isCancelled());
            }
            catch (OWLRuntimeException e) {
                runtimeExceptionHandler.handleOWLRuntimeException(e);
            }
        }
    }

    private void doExecute(RuntimeExceptionHandler runtimeExceptionHandler, boolean resetConstraintSystem, ExecutionMonitor executionMonitor) throws OWLRuntimeException {
        if (resetConstraintSystem) {
            this.getConstraintSystem().reset();
        }
        Set<BindingNode> currentLeaves = this.getConstraintSystem().getLeaves();
        ArrayList<AbstractQueryPlannerItem> queryPlannerItems = new ArrayList<AbstractQueryPlannerItem>();
        for (OWLAxiom axiom : this.assertedAxioms) {
            queryPlannerItems.add(new AssertedAxiomPlannerItem(this.getConstraintSystem(), axiom));
        }
        for (OWLAxiom axiom : this.axioms) {
            queryPlannerItems.add(new InferredAxiomQueryPlannerItem(this.getConstraintSystem(), axiom));
        }
        final ComplexityEstimate complexityEstimate = new ComplexityEstimate(this.constraintSystem, runtimeExceptionHandler);
        Comparator<QueryPlannerItem> comparator = new Comparator<QueryPlannerItem>(){

            @Override
            public int compare(QueryPlannerItem anItem, QueryPlannerItem anotherItem) {
                int difference;
                int toReturn = 0;
                toReturn = anItem == null ? (anotherItem == null ? toReturn : -1) : ((difference = (int)Math.signum(anItem.accept(complexityEstimate).floatValue() - anotherItem.accept(complexityEstimate).floatValue())) == 0 ? anItem.hashCode() - anotherItem.hashCode() : difference);
                return toReturn;
            }
        };
        Collections.sort(queryPlannerItems, comparator);
        int increment = (int)Math.ceil(100.0 / (double)queryPlannerItems.size());
        int progress = 0;
        ArrayList<ConstraintQueryPlannerItem> constraintsItems = new ArrayList<ConstraintQueryPlannerItem>();
        for (AbstractConstraint c : this.constraints) {
            constraintsItems.add(new ConstraintQueryPlannerItem(this.getConstraintSystem(), c));
        }
        Iterator iterator = queryPlannerItems.iterator();
        while (!executionMonitor.isCancelled() && iterator.hasNext()) {
            QueryPlannerItem queryPlannerItem = (QueryPlannerItem)iterator.next();
            currentLeaves = queryPlannerItem.match(currentLeaves, executionMonitor, runtimeExceptionHandler);
            int i = 0;
            while (i < constraintsItems.size()) {
                ConstraintQueryPlannerItem c = (ConstraintQueryPlannerItem)constraintsItems.get(i);
                if (executionMonitor.isCancelled()) break;
                if (this.canMatch(c, currentLeaves, runtimeExceptionHandler)) {
                    currentLeaves = c.match(currentLeaves, executionMonitor, runtimeExceptionHandler);
                    constraintsItems.remove(i);
                    continue;
                }
                ++i;
            }
            executionMonitor.progressIncrementChanged(progress += increment);
        }
        if (executionMonitor.isCancelled()) {
            currentLeaves = null;
        }
        this.getConstraintSystem().setLeaves(currentLeaves);
    }

    private boolean canMatch(ConstraintQueryPlannerItem c, Set<BindingNode> currentLeaves, RuntimeExceptionHandler runtimeExceptionHandler) {
        boolean found = false;
        AbstractConstraint constraint = c.getConstraint();
        Iterator<BindingNode> iterator = currentLeaves.iterator();
        while (!found && iterator.hasNext()) {
            final BindingNode bindingNode = iterator.next();
            final SimpleValueComputationParameters parameters = new SimpleValueComputationParameters(this.getConstraintSystem(), bindingNode, runtimeExceptionHandler);
            final OWLObjectInstantiator instantiator = new OWLObjectInstantiator(parameters);
            final VariableExtractor variableExtractor = new VariableExtractor(this.getConstraintSystem(), false);
            found = constraint.accept(new ConstraintVisitorEx<Boolean>(){

                @Override
                public Boolean visit(InequalityConstraint ic) {
                    OWLObject instantiatedExpression = (OWLObject)ic.getExpression().accept((OWLObjectVisitorEx)instantiator);
                    return bindingNode.getAssignmentValue(ic.getVariable(), parameters) == null || !variableExtractor.extractVariables(instantiatedExpression).isEmpty();
                }

                @Override
                public Boolean visit(InCollectionConstraint<? extends OWLObject> icc) {
                    for (OWLObject oWLObject : icc.getCollection()) {
                        OWLObject instantiated = (OWLObject)oWLObject.accept((OWLObjectVisitorEx)instantiator);
                        if (variableExtractor.extractVariables(instantiated).isEmpty()) continue;
                        return true;
                    }
                    return bindingNode.getAssignmentValue(icc.getVariable(), parameters) == null;
                }

                @Override
                public Boolean visit(RegExpConstraint rc) {
                    OPPLFunction<Pattern> expression = rc.getExpression();
                    for (Variable<?> variable : variableExtractor.extractVariables(expression)) {
                        if (bindingNode.getAssignmentValue(variable, parameters) != null) continue;
                        return true;
                    }
                    return bindingNode.getAssignmentValue(rc.getVariable(), parameters) == null;
                }

                @Override
                public Boolean visit(NAFConstraint nafConstraint) {
                    OWLAxiom instantiatedAxiom = (OWLAxiom)nafConstraint.getAxiom().accept((OWLObjectVisitorEx)instantiator);
                    Set<Variable<?>> extractedVariables = variableExtractor.extractVariables((OWLObject)instantiatedAxiom);
                    return !extractedVariables.isEmpty();
                }
            });
        }
        return !found;
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public void setDirty(boolean dirty) {
        this.dirty = dirty;
    }
}

