/*
 * Decompiled with CFR 0.152.
 */
package org.coode.oppl;

import org.coode.oppl.AbstractConstraint;
import org.coode.oppl.ConstraintSystem;
import org.coode.oppl.ConstraintVisitor;
import org.coode.oppl.ConstraintVisitorEx;
import org.coode.oppl.rendering.ManchesterSyntaxRenderer;
import org.coode.oppl.utils.ArgCheck;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLObjectVisitor;
import org.semanticweb.owlapi.util.ShortFormProvider;

public class NAFConstraint
implements AbstractConstraint {
    private final OWLAxiom axiom;
    private final ConstraintSystem constraintSystem;

    public NAFConstraint(OWLAxiom axiom, ConstraintSystem constraintSystem) {
        this.axiom = ArgCheck.checkNotNull(axiom, "axiom");
        this.constraintSystem = ArgCheck.checkNotNull(constraintSystem, "constraintSystem");
    }

    @Override
    public <O> O accept(ConstraintVisitorEx<O> visitor) {
        return visitor.visit(this);
    }

    @Override
    public void accept(ConstraintVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public String render(ShortFormProvider shortFormProvider) {
        ManchesterSyntaxRenderer r = new ManchesterSyntaxRenderer(shortFormProvider);
        this.getAxiom().accept((OWLObjectVisitor)r);
        return String.format("FAIL %s", r.toString());
    }

    @Override
    public String render(ConstraintSystem cs) {
        ManchesterSyntaxRenderer r = cs.getOPPLFactory().getManchesterSyntaxRenderer(cs);
        this.getAxiom().accept((OWLObjectVisitor)r);
        return String.format("FAIL %s", r);
    }

    public String toString() {
        return this.render(this.getConstraintSystem());
    }

    public OWLAxiom getAxiom() {
        return this.axiom;
    }

    public ConstraintSystem getConstraintSystem() {
        return this.constraintSystem;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.axiom == null ? 0 : this.axiom.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        NAFConstraint other = (NAFConstraint)obj;
        return !(this.axiom == null ? other.axiom != null : !this.axiom.equals(other.axiom));
    }
}

