/*
 * Decompiled with CFR 0.152.
 */
package org.coode.oppl;

import org.coode.oppl.AbstractConstraint;
import org.coode.oppl.ConstraintSystem;
import org.coode.oppl.ConstraintVisitor;
import org.coode.oppl.ConstraintVisitorEx;
import org.coode.oppl.Variable;
import org.coode.oppl.rendering.ManchesterSyntaxRenderer;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLObjectVisitor;
import org.semanticweb.owlapi.util.ShortFormProvider;

public class InequalityConstraint
implements AbstractConstraint {
    private final Variable<?> variable;
    private final OWLObject expression;
    private final ConstraintSystem constraintSystem;

    public InequalityConstraint(Variable<?> variable, OWLObject expression, ConstraintSystem constraintSystem) {
        this.variable = variable;
        this.expression = expression;
        this.constraintSystem = constraintSystem;
    }

    public Variable<?> getVariable() {
        return this.variable;
    }

    public OWLObject getExpression() {
        return this.expression;
    }

    @Override
    public <O> O accept(ConstraintVisitorEx<O> visitor) {
        return visitor.visit(this);
    }

    public String toString() {
        return this.render(this.getConstraintSystem());
    }

    public ConstraintSystem getConstraintSystem() {
        return this.constraintSystem;
    }

    @Override
    public String render(ShortFormProvider shortFormProvider) {
        ManchesterSyntaxRenderer renderer = new ManchesterSyntaxRenderer(shortFormProvider);
        this.expression.accept((OWLObjectVisitor)renderer);
        return this.variable.getName() + " != " + renderer.toString();
    }

    @Override
    public String render(ConstraintSystem cs) {
        ManchesterSyntaxRenderer renderer = cs.getOPPLFactory().getManchesterSyntaxRenderer(cs);
        this.expression.accept((OWLObjectVisitor)renderer);
        return this.variable.getName() + " != " + renderer.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.expression == null ? 0 : this.expression.hashCode());
        result = 31 * result + (this.variable == null ? 0 : this.variable.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        InequalityConstraint other = (InequalityConstraint)obj;
        if (this.expression == null ? other.expression != null : !this.expression.equals(other.expression)) {
            return false;
        }
        return !(this.variable == null ? other.variable != null : !this.variable.equals(other.variable));
    }

    @Override
    public void accept(ConstraintVisitor visitor) {
        visitor.visitInequalityConstraint(this);
    }
}

