/*
 * Decompiled with CFR 0.152.
 */
package org.coode.oppl;

import java.util.HashMap;
import java.util.Map;
import org.coode.oppl.AbstractVariableScope;
import org.coode.oppl.ConstraintSystem;
import org.coode.oppl.SubClassVariableScope;
import org.coode.oppl.SuperClassVariableScope;
import org.coode.oppl.VariableScope;
import org.coode.oppl.VariableScopeChecker;
import org.coode.oppl.rendering.ManchesterSyntaxRenderer;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLObjectVisitor;

public abstract class ClassVariableScope
extends AbstractVariableScope<OWLClassExpression>
implements VariableScope<OWLClassExpression> {
    private final OWLClassExpression description;
    private static Map<OWLClassExpression, SuperClassVariableScope> superClassesScopes = new HashMap<OWLClassExpression, SuperClassVariableScope>();
    private static Map<OWLClassExpression, SubClassVariableScope> subClassesScopes = new HashMap<OWLClassExpression, SubClassVariableScope>();

    ClassVariableScope(OWLClassExpression description, VariableScopeChecker checker) {
        super(checker);
        this.description = description;
    }

    public OWLClassExpression getClassExpression() {
        return this.description;
    }

    static SubClassVariableScope buildSubClassVariableScope(OWLClassExpression description, VariableScopeChecker checker) {
        SubClassVariableScope toReturn = subClassesScopes.get(description);
        if (toReturn == null) {
            toReturn = new SubClassVariableScope(description, checker);
            subClassesScopes.put(description, toReturn);
        }
        return toReturn;
    }

    static SuperClassVariableScope buildSuperClassVariableScope(OWLClassExpression description, VariableScopeChecker checker) {
        SuperClassVariableScope toReturn = superClassesScopes.get(description);
        if (toReturn == null) {
            toReturn = new SuperClassVariableScope(description, checker);
            superClassesScopes.put(description, toReturn);
        }
        return toReturn;
    }

    @Override
    public OWLClassExpression getScopingObject() {
        return this.getClassExpression();
    }

    @Override
    public String render(ConstraintSystem constraintSystem) {
        ManchesterSyntaxRenderer renderer = constraintSystem.getOPPLFactory().getManchesterSyntaxRenderer(constraintSystem);
        this.getScopingObject().accept((OWLObjectVisitor)renderer);
        return String.format("[%s %s]", new Object[]{this.getDirection(), renderer});
    }
}

