/*
 * Decompiled with CFR 0.152.
 */
package org.coode.oppl;

import java.util.ArrayList;
import java.util.List;
import org.coode.oppl.ActionFactory;
import org.coode.oppl.ActionType;
import org.coode.oppl.ExecutionMonitor;
import org.coode.oppl.OPPLQuery;
import org.coode.oppl.OPPLScript;
import org.coode.oppl.exceptions.RuntimeExceptionHandler;
import org.coode.oppl.utils.ArgCheck;
import org.semanticweb.owlapi.model.OWLAxiomChange;

public class ChangeExtractor {
    private final boolean considerImportClosure;
    private final RuntimeExceptionHandler runtimeExceptionHandler;
    private final ExecutionMonitor executionMonitor;

    public ChangeExtractor(RuntimeExceptionHandler runtimeExceptionHandler, boolean considerImportClosure) {
        this(runtimeExceptionHandler, ExecutionMonitor.NON_CANCELLABLE, considerImportClosure);
    }

    public ChangeExtractor(RuntimeExceptionHandler runtimeExceptionHandler, ExecutionMonitor executionMonitor, boolean considerImportClosure) {
        this.executionMonitor = ArgCheck.checkNotNull(executionMonitor, "executionMonitor");
        this.runtimeExceptionHandler = ArgCheck.checkNotNull(runtimeExceptionHandler, "runtimeExceptionHandler");
        this.considerImportClosure = considerImportClosure;
    }

    public List<OWLAxiomChange> visit(OPPLScript script) {
        OPPLQuery q = ArgCheck.checkNotNull(script, "script").getQuery();
        if (q != null) {
            q.execute(this.getRuntimeExceptionHandler(), this.getExecutionMonitor());
        }
        ArrayList<OWLAxiomChange> toReturn = new ArrayList<OWLAxiomChange>();
        List<OWLAxiomChange> changes = script.getActions();
        for (OWLAxiomChange change : changes) {
            ActionType action;
            boolean isAdd = change.isAddAxiom();
            ActionType actionType = action = isAdd ? ActionType.ADD : ActionType.REMOVE;
            if (this.considerImportClosure && !isAdd) {
                toReturn.addAll(ActionFactory.createChanges(action, change.getAxiom(), script.getConstraintSystem(), script.getConstraintSystem().getOntologyManager().getImportsClosure(script.getConstraintSystem().getOntology()), this.getRuntimeExceptionHandler()));
                continue;
            }
            toReturn.addAll(ActionFactory.createChanges(action, change.getAxiom(), script.getConstraintSystem(), script.getConstraintSystem().getOntology(), this.getRuntimeExceptionHandler()));
        }
        return toReturn;
    }

    public RuntimeExceptionHandler getRuntimeExceptionHandler() {
        return this.runtimeExceptionHandler;
    }

    public ExecutionMonitor getExecutionMonitor() {
        return this.executionMonitor;
    }
}

