/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.jfact.kernel.modelcaches;

import conformance.PortedFrom;
import uk.ac.manchester.cs.jfact.helpers.LogAdapter;
import uk.ac.manchester.cs.jfact.helpers.Templates;
import uk.ac.manchester.cs.jfact.kernel.modelcaches.ModelCacheInterface;
import uk.ac.manchester.cs.jfact.kernel.modelcaches.ModelCacheState;
import uk.ac.manchester.cs.jfact.kernel.modelcaches.ModelCacheType;

@PortedFrom(file="modelCacheConst.h", name="modelCacheConst")
public class ModelCacheConst
extends ModelCacheInterface {
    @PortedFrom(file="modelCacheConst.h", name="isTop")
    private final boolean isTop;

    public ModelCacheConst(boolean top) {
        super(false);
        this.isTop = top;
    }

    @Override
    @PortedFrom(file="modelCacheConst.h", name="getState")
    public ModelCacheState getState() {
        return this.isTop ? ModelCacheState.VALID : ModelCacheState.INVALID;
    }

    @PortedFrom(file="modelCacheConst.h", name="getConst")
    public boolean getConst() {
        return this.isTop;
    }

    @Override
    @PortedFrom(file="modelCacheConst.h", name="canMerge")
    public ModelCacheState canMerge(ModelCacheInterface p) {
        if (p.getCacheType() == ModelCacheType.CONST) {
            return this.isTop && ((ModelCacheConst)p).isTop ? ModelCacheState.VALID : ModelCacheState.INVALID;
        }
        return p.canMerge(this);
    }

    @Override
    @PortedFrom(file="modelCacheConst.h", name="getCacheType")
    public ModelCacheType getCacheType() {
        return ModelCacheType.CONST;
    }

    @Override
    @PortedFrom(file="modelCacheConst.h", name="logCacheEntry")
    public void logCacheEntry(int level, LogAdapter l) {
        l.printTemplate(Templates.LOGCACHEENTRY, this.isTop ? "TOP" : "BOTTOM");
    }

    @PortedFrom(file="modelCacheConst.h", name="createConstCache")
    public static ModelCacheConst createConstCache(int bp) {
        assert (bp == 1 || bp == -1);
        return new ModelCacheConst(bp == 1);
    }
}

