/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.jfact.kernel.actors;

import conformance.PortedFrom;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import uk.ac.manchester.cs.jfact.kernel.ClassifiableEntry;
import uk.ac.manchester.cs.jfact.kernel.ExpressionCache;
import uk.ac.manchester.cs.jfact.kernel.TaxonomyVertex;
import uk.ac.manchester.cs.jfact.kernel.actors.Policy;
import uk.ac.manchester.cs.jfact.kernel.actors.TaxGatheringWalker;
import uk.ac.manchester.cs.jfact.kernel.dl.interfaces.Expression;

@PortedFrom(file="JNIActor.h", name="TaxonomyActor")
public class TaxonomyActor<T extends Expression>
extends TaxGatheringWalker {
    private final Policy policy;
    private final ExpressionCache cache;
    @PortedFrom(file="JNIActor.h", name="acc")
    private final List<List<T>> acc = new ArrayList<List<T>>();
    @PortedFrom(file="JNIActor.h", name="plain")
    private final List<T> plain = new ArrayList<T>();
    @PortedFrom(file="JNIActor.h", name="syn")
    private final List<T> syn = new ArrayList<T>();

    @PortedFrom(file="JNIActor.h", name="TaxonomyActor")
    public TaxonomyActor(ExpressionCache em, Policy p) {
        this.cache = em;
        this.policy = p;
    }

    @Override
    public boolean applicable(TaxonomyVertex v) {
        if (this.applicable(v.getPrimer())) {
            return true;
        }
        return v.synonyms().anyMatch(this::applicable);
    }

    @Override
    protected boolean applicable(ClassifiableEntry entry) {
        return this.policy.applicable(entry);
    }

    @Override
    @PortedFrom(file="JNIActor.h", name="tryEntry")
    protected boolean tryEntry(ClassifiableEntry p) {
        if (!p.isSystem() && this.applicable(p)) {
            this.syn.add(this.asT(p));
            return true;
        }
        return false;
    }

    protected T asT(ClassifiableEntry p) {
        return (T)this.policy.buildTree(this.cache, p);
    }

    @Override
    @PortedFrom(file="JNIActor.h", name="clear")
    public void clear() {
        this.acc.clear();
        this.plain.clear();
    }

    @PortedFrom(file="JNIActor.h", name="getSynonyms")
    public Collection<T> getSynonyms() {
        return this.acc.isEmpty() ? this.syn : (Collection)this.acc.get(0);
    }

    @PortedFrom(file="JNIActor.h", name="getElements")
    public List<Collection<T>> getElements() {
        if (this.policy.needPlain()) {
            return Collections.singletonList(this.plain);
        }
        return new ArrayList<Collection<T>>(this.acc);
    }

    @Override
    @PortedFrom(file="JNIActor.h", name="apply")
    public boolean apply(TaxonomyVertex v) {
        this.syn.clear();
        this.tryEntry(v.getPrimer());
        v.synonyms().forEach(this::tryEntry);
        if (this.syn.isEmpty()) {
            return false;
        }
        if (this.policy.needPlain()) {
            this.plain.addAll(this.syn);
        } else {
            this.acc.add(new ArrayList<T>(this.syn));
        }
        return true;
    }

    @Override
    public void removePastBoundaries(Collection<TaxonomyVertex> pastBoundary) {
        ArrayList entries = new ArrayList();
        pastBoundary.forEach(t -> this.removePastBoundaries(entries, (TaxonomyVertex)t));
        this.plain.removeAll(entries);
        this.acc.forEach(l -> {
            boolean bl = l.removeAll(entries);
        });
    }

    protected void removePastBoundaries(List<T> entries, TaxonomyVertex t) {
        entries.add(this.asT(t.getPrimer()));
        TaxonomyVertex t1 = t.getSynonymNode();
        while (t1 != null) {
            entries.add(this.asT(t1.getPrimer()));
            t1 = t1.getSynonymNode();
        }
    }
}

