/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.jfact.kernel.actors;

import conformance.PortedFrom;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import uk.ac.manchester.cs.jfact.kernel.ClassifiableEntry;
import uk.ac.manchester.cs.jfact.kernel.Concept;
import uk.ac.manchester.cs.jfact.kernel.Individual;
import uk.ac.manchester.cs.jfact.kernel.TaxonomyVertex;
import uk.ac.manchester.cs.jfact.kernel.actors.TaxGatheringWalker;

@PortedFrom(file="Kernel.cpp", name="RIActor")
public class RIActor
extends TaxGatheringWalker {
    private final List<Individual> acc = new ArrayList<Individual>();

    @Override
    protected boolean tryEntry(ClassifiableEntry p) {
        if (p.isSystem() || !this.applicable(p)) {
            return false;
        }
        this.acc.add((Individual)p);
        return true;
    }

    @Override
    protected boolean applicable(ClassifiableEntry entry) {
        return ((Concept)entry).isSingleton();
    }

    @Override
    public boolean apply(TaxonomyVertex v) {
        AtomicBoolean ret = new AtomicBoolean(this.tryEntry(v.getPrimer()));
        v.synonyms().forEach(p -> {
            boolean bl = ret.compareAndSet(false, this.tryEntry((ClassifiableEntry)p));
        });
        return ret.get();
    }

    @Override
    public boolean applicable(TaxonomyVertex v) {
        if (RIActor.test(v.getPrimer())) {
            return true;
        }
        return v.synonyms().anyMatch(RIActor::test);
    }

    private static boolean test(ClassifiableEntry p) {
        return !p.isSystem() && ((Concept)p).isSingleton();
    }

    @Override
    public void clear() {
        this.acc.clear();
    }

    public List<Individual> getAcc() {
        return this.acc;
    }
}

