/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.jfact.kernel;

import conformance.Original;
import conformance.PortedFrom;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.stream.Stream;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.util.OWLAPIStreamUtils;
import uk.ac.manchester.cs.jfact.kernel.ClassifiableEntry;
import uk.ac.manchester.cs.jfact.kernel.TaxonomyVertex;
import uk.ac.manchester.cs.jfact.kernel.actors.Actor;
import uk.ac.manchester.cs.jfact.kernel.actors.SupConceptActor;
import uk.ac.manchester.cs.jfact.kernel.options.JFactReasonerConfiguration;

@PortedFrom(file="Taxonomy.h", name="Taxonomy")
public class Taxonomy
implements Serializable {
    @PortedFrom(file="Taxonomy.h", name="Graph")
    private final List<TaxonomyVertex> graph = new ArrayList<TaxonomyVertex>();
    @PortedFrom(file="Taxonomy.h", name="Current")
    protected TaxonomyVertex current = new TaxonomyVertex();
    @PortedFrom(file="Taxonomy.h", name="willInsertIntoTaxonomy")
    protected boolean willInsertIntoTaxonomy = true;
    @PortedFrom(file="Taxonomy.h", name="FreshNode")
    protected final TaxonomyVertex freshNode = new TaxonomyVertex();
    @PortedFrom(file="Taxonomy.h", name="checkLabel")
    protected long visitedLabel = 1L;
    @Original
    private final JFactReasonerConfiguration options;

    public Taxonomy(ClassifiableEntry pTop, ClassifiableEntry pBottom, JFactReasonerConfiguration c) {
        this.options = c;
        this.graph.add(new TaxonomyVertex(pBottom));
        this.graph.add(new TaxonomyVertex(pTop));
        this.freshNode.addNeighbour(true, this.getTopVertex());
        this.freshNode.addNeighbour(false, this.getBottomVertex());
    }

    @PortedFrom(file="Taxonomy.h", name="getCurrent")
    public TaxonomyVertex getCurrent() {
        return this.current;
    }

    @PortedFrom(file="Taxonomy.h", name="setCurrent")
    public void setCurrent(TaxonomyVertex cur) {
        this.current = cur;
    }

    @PortedFrom(file="Taxonomy.h", name="getRelativesInfo")
    public boolean getRelativesInfo(TaxonomyVertex node, SupConceptActor actor, boolean needCurrent, boolean onlyDirect, boolean upDirection) {
        try {
            if (needCurrent) {
                if (!actor.apply(node)) {
                    return false;
                }
                if (onlyDirect) {
                    return true;
                }
            }
            LinkedList<Stream<TaxonomyVertex>> queue = new LinkedList<Stream<TaxonomyVertex>>();
            queue.add(node.neigh(upDirection));
            while (!queue.isEmpty()) {
                for (TaxonomyVertex _node : OWLAPIStreamUtils.asList((Stream)((Stream)queue.remove()))) {
                    if (this.isVisited(_node)) continue;
                    this.setVisited(_node);
                    if (!actor.apply(_node) && onlyDirect) {
                        return false;
                    }
                    if (onlyDirect) continue;
                    queue.add(_node.neigh(upDirection));
                }
            }
            return true;
        }
        finally {
            this.clearVisited();
        }
    }

    @PortedFrom(file="Taxonomy.h", name="getRelativesInfo")
    public void getRelativesInfo(TaxonomyVertex node, Actor actor, boolean needCurrent, boolean onlyDirect, boolean upDirection) {
        if (needCurrent && actor.apply(node) && onlyDirect) {
            return;
        }
        LinkedList queue = new LinkedList();
        node.neigh(upDirection).forEach(queue::add);
        HashSet<TaxonomyVertex> pastBoundary = new HashSet<TaxonomyVertex>();
        while (!queue.isEmpty()) {
            TaxonomyVertex nextNode = (TaxonomyVertex)queue.remove(0);
            if (this.isVisited(nextNode)) continue;
            this.setVisited(nextNode);
            boolean applied = actor.apply(nextNode);
            if (applied && onlyDirect) {
                nextNode.neigh(upDirection).forEach(boundary -> this.setAllVisited((TaxonomyVertex)boundary, upDirection, (Set<TaxonomyVertex>)pastBoundary));
                continue;
            }
            nextNode.neigh(upDirection).filter(v -> actor.applicable((TaxonomyVertex)v) || !onlyDirect).forEach(queue::add);
        }
        actor.removePastBoundaries(pastBoundary);
        this.clearVisited();
    }

    @PortedFrom(file="Taxonomy.h", name="setVisited")
    public void setVisited(TaxonomyVertex node) {
        node.setChecked(this.visitedLabel);
    }

    public void setAllVisited(TaxonomyVertex node, boolean direction, Set<TaxonomyVertex> pastBoundary) {
        pastBoundary.add(node);
        this.setVisited(node);
        node.neigh(direction).forEach(v -> {
            this.setVisited((TaxonomyVertex)v);
            this.setAllVisited((TaxonomyVertex)v, direction, pastBoundary);
        });
    }

    @PortedFrom(file="Taxonomy.h", name="isVisited")
    public boolean isVisited(TaxonomyVertex node) {
        return node.isChecked(this.visitedLabel);
    }

    @PortedFrom(file="Taxonomy.h", name="clearCheckedLabel")
    protected void clearVisited() {
        ++this.visitedLabel;
    }

    public JFactReasonerConfiguration getOptions() {
        return this.options;
    }

    @PortedFrom(file="Taxonomy.h", name="getTopVertex")
    public TaxonomyVertex getTopVertex() {
        return this.graph.get(1);
    }

    @PortedFrom(file="Taxonomy.h", name="getBottomVertex")
    public TaxonomyVertex getBottomVertex() {
        return this.graph.get(0);
    }

    @PortedFrom(file="Taxonomy.h", name="getFreshVertex")
    public TaxonomyVertex getFreshVertex(ClassifiableEntry e) {
        this.freshNode.setSample(e, false);
        return this.freshNode;
    }

    public String toString() {
        StringBuilder o = new StringBuilder();
        o.append("All entries are in format:\n\"entry\" {n: parent_1 ... parent_n} {m: child_1 child_m}\n\n");
        this.graph.stream().skip(1L).sorted((o1, o2) -> o1.getPrimer().getIRI().compareTo((OWLObject)o2.getPrimer().getIRI())).forEach(o::append);
        o.append(this.getBottomVertex());
        return o.toString();
    }

    @PortedFrom(file="Taxonomy.h", name="removeNode")
    public void removeNode(TaxonomyVertex node) {
        node.setInUse(false);
    }

    @PortedFrom(file="Taxonomy.h", name="queryMode")
    public boolean queryMode() {
        return !this.willInsertIntoTaxonomy;
    }

    @PortedFrom(file="Taxonomy.h", name="finalise")
    public void finalise() {
        this.graph.stream().skip(1L).forEach(p -> {
            if (p.noNeighbours(false)) {
                p.addNeighbour(false, this.getBottomVertex());
                this.getBottomVertex().addNeighbour(true, (TaxonomyVertex)p);
            }
        });
        this.willInsertIntoTaxonomy = false;
    }

    @PortedFrom(file="Taxonomy.h", name="deFinalise")
    public void deFinalise() {
        TaxonomyVertex bot = this.getBottomVertex();
        bot.neigh(true).forEach(p -> {
            boolean bl = p.removeLink(false, bot);
        });
        bot.clearLinks(true);
        this.willInsertIntoTaxonomy = true;
    }

    @PortedFrom(file="Taxonomy.h", name="addCurrentToSynonym")
    public void addCurrentToSynonym(TaxonomyVertex syn) {
        ClassifiableEntry currentEntry = this.current.getPrimer();
        if (this.queryMode()) {
            syn.setVertexAsHost(currentEntry);
        } else {
            syn.addSynonym(currentEntry);
            this.options.getLog().print((Object)"\nTAX:set ", (Object)currentEntry.getIRI(), (Object)" equal ", (Object)syn.getPrimer().getIRI());
        }
    }

    @PortedFrom(file="Taxonomy.h", name="finishCurrentNode")
    public void finishCurrentNode() {
        TaxonomyVertex syn = this.current.getSynonymNode();
        if (syn != null) {
            this.addCurrentToSynonym(syn);
        } else if (!this.queryMode()) {
            this.current.incorporate(this.options);
            this.graph.add(this.current);
            this.current = new TaxonomyVertex();
        }
    }

    @PortedFrom(file="TaxonomyCreator.cpp", name="processSynonym")
    protected boolean processSynonym() {
        ClassifiableEntry currentEntry = this.current.getPrimer();
        ClassifiableEntry syn = ClassifiableEntry.resolveSynonym(currentEntry);
        if (syn.equals(currentEntry)) {
            return false;
        }
        if (syn.isClassified()) {
            this.addCurrentToSynonym(syn.getTaxVertex());
            return true;
        }
        return false;
    }

    public void clearLabels() {
        ++this.visitedLabel;
    }
}

