/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.jfact.kernel;

import conformance.PortedFrom;
import java.util.ArrayList;
import java.util.List;
import uk.ac.manchester.cs.jfact.dep.DepSet;
import uk.ac.manchester.cs.jfact.helpers.Pair;
import uk.ac.manchester.cs.jfact.helpers.Templates;
import uk.ac.manchester.cs.jfact.kernel.ClassifiableEntry;
import uk.ac.manchester.cs.jfact.kernel.DlCompletionTree;
import uk.ac.manchester.cs.jfact.kernel.DlCompletionTreeArc;
import uk.ac.manchester.cs.jfact.kernel.DlSatTester;
import uk.ac.manchester.cs.jfact.kernel.Individual;
import uk.ac.manchester.cs.jfact.kernel.Related;
import uk.ac.manchester.cs.jfact.kernel.Role;
import uk.ac.manchester.cs.jfact.kernel.TBox;
import uk.ac.manchester.cs.jfact.kernel.options.JFactReasonerConfiguration;

@PortedFrom(file="ReasonerNom.h", name="NominalReasoner")
public class NominalReasoner
extends DlSatTester {
    @PortedFrom(file="ReasonerNom.h", name="Nominals")
    protected final List<Individual> nominals = new ArrayList<Individual>();

    public NominalReasoner(TBox tbox, JFactReasonerConfiguration options) {
        super(tbox, options);
        this.tBox.individuals().filter(pi -> !pi.isSynonym()).forEach(this.nominals::add);
    }

    @Override
    @PortedFrom(file="ReasonerNom.h", name="hasNominals")
    public boolean hasNominals() {
        return true;
    }

    @PortedFrom(file="ReasonerNom.h", name="registerNominalCache")
    protected void registerNominalCache(Individual p) {
        this.dlHeap.setCache(p.getpName(), this.createModelCache(p.getNode().resolvePBlocker()));
    }

    @PortedFrom(file="ReasonerNom.h", name="initNominalNode")
    protected boolean initNominalNode(Individual nom) {
        DlCompletionTree node = this.cGraph.getNewNode();
        node.setNominalLevel();
        nom.setNode(node);
        return this.initNewNode(node, DepSet.create(), nom.getpName());
    }

    @PortedFrom(file="ReasonerNom.h", name="updateClassifiedSingleton")
    protected void updateClassifiedSingleton(Individual p) {
        this.registerNominalCache(p);
        if (p.getNode().isPBlocked()) {
            int bp = p.getNode().getBlocker().label().getSimpleConcepts().iterator().next().getConcept();
            Individual blocker = (Individual)this.dlHeap.get(bp).getConcept();
            assert (blocker.getNode().equals(p.getNode().getBlocker()));
            this.tBox.addSameIndividuals(p, new Pair(blocker, p.getNode().getPurgeDep().isEmpty()));
        }
    }

    @Override
    @PortedFrom(file="ReasonerNom.h", name="prepareReasoner")
    protected void prepareReasoner() {
        this.options.getLog().print("\nInitNominalReasoner:");
        this.restore(1);
        if (!(this.bContext instanceof DlSatTester.BCBarrier)) {
            this.stack.pop();
            this.createBCBarrier();
        }
        this.save();
        this.resetSessionFlags();
    }

    @PortedFrom(file="ReasonerNom.h", name="consistentNominalCloud")
    public boolean consistentNominalCloud() {
        boolean result;
        this.options.getLog().print("\n\nChecking consistency of an ontology with individuals:\n");
        if (this.initNewNode(this.cGraph.getRoot(), DepSet.create(), 1) || this.initNominalCloud()) {
            this.options.getLog().print("\ninit done\n");
            result = false;
        } else {
            this.options.getLog().print("\nrunning sat...");
            result = this.runSat();
            this.options.getLog().print(" done: ");
            this.options.getLog().print(result);
            this.options.getLog().print("\n");
        }
        if (result && this.noBranchingOps()) {
            this.options.getLog().print("InitNominalReasoner[");
            this.curNode = null;
            this.createBCBarrier();
            this.save();
            this.nonDetShift = 1;
            this.options.getLog().print("]");
        }
        this.options.getLog().printTemplate(Templates.CONSISTENT_NOMINAL, result ? "consistent" : "INCONSISTENT");
        if (!result) {
            return false;
        }
        this.nominals.forEach(this::updateClassifiedSingleton);
        return true;
    }

    @PortedFrom(file="ReasonerNom.h", name="initNominalCloud")
    private boolean initNominalCloud() {
        if (this.nominals.stream().anyMatch(this::initNominalNode)) {
            return true;
        }
        if (this.tBox.getRelatedI().stream().anyMatch(this::initRelatedNominals)) {
            return true;
        }
        if (this.tBox.getDifferent().isEmpty()) {
            return false;
        }
        DepSet dummy = DepSet.create();
        for (List<Individual> r : this.tBox.getDifferent()) {
            this.cGraph.initIR();
            if (r.stream().anyMatch(p -> this.cGraph.setCurIR(ClassifiableEntry.resolveSynonym(p).getNode(), dummy))) {
                return true;
            }
            this.cGraph.finiIR();
        }
        return false;
    }

    @PortedFrom(file="ReasonerNom.h", name="initRelatedNominals")
    private boolean initRelatedNominals(Related rel) {
        DlCompletionTree from = ClassifiableEntry.resolveSynonym(rel.getA()).getNode();
        DlCompletionTree to = ClassifiableEntry.resolveSynonym(rel.getB()).getNode();
        Role r = ClassifiableEntry.resolveSynonym(rel.getRole());
        DepSet dep = DepSet.create();
        if (r.isDisjoint() && this.checkDisjointRoleClash(from, to, r, dep)) {
            return true;
        }
        DlCompletionTreeArc pA = this.cGraph.addRoleLabel(from, to, false, r, dep);
        return this.setupEdge(pA, dep, 0);
    }

    @PortedFrom(file="Reasoner.h", name="createBCBarrier")
    private void createBCBarrier() {
        this.bContext = this.stack.pushBarrier();
    }

    @PortedFrom(file="ConjunctiveQueryFolding.cpp", name="checkExtraCond")
    public boolean checkExtraCond() {
        this.prepareReasoner();
        DepSet dummy = DepSet.create();
        int i = 0;
        while (i < this.tBox.getIV().size()) {
            if (this.addToDoEntry(this.tBox.getIV().get(i).getNode(), this.tBox.getConceptsForQueryAnswering().get(i), dummy, "QA")) {
                return true;
            }
            ++i;
        }
        return !this.checkSatisfiability();
    }
}

