/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.jfact.kernel;

import conformance.Original;
import java.io.Serializable;
import java.util.function.Function;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.reasoner.FreshEntityPolicy;
import uk.ac.manchester.cs.jfact.kernel.ClassifiableEntry;
import uk.ac.manchester.cs.jfact.kernel.NameSet;
import uk.ac.manchester.cs.jfact.kernel.NamedEntry;
import uk.ac.manchester.cs.jfact.kernel.ReasonerFreshEntityException;
import uk.ac.manchester.cs.jfact.kernel.options.JFactReasonerConfiguration;

public class NamedEntryCollection<T extends NamedEntry>
implements Serializable {
    private final NameSet<T, IRI> nameset;
    private final String typeName;
    private boolean locked;
    @Original
    private final JFactReasonerConfiguration options;

    public NamedEntryCollection(String name, JFactReasonerConfiguration options) {
        this.typeName = name;
        this.locked = false;
        this.nameset = new NameSet();
        this.options = options;
    }

    public boolean isLocked() {
        return this.locked;
    }

    public boolean setLocked(boolean val) {
        boolean old = this.locked;
        this.locked = val;
        return old;
    }

    public boolean isRegistered(IRI name) {
        return this.nameset.get(name) != null;
    }

    public T get(IRI name, Function<IRI, T> creator) {
        NamedEntry p = (NamedEntry)this.nameset.get(name);
        if (p != null) {
            return (T)p;
        }
        if (this.isLocked() && !this.options.isUseUndefinedNames() && this.options.getFreshEntityPolicy() == FreshEntityPolicy.DISALLOW) {
            throw new ReasonerFreshEntityException("Unable to register '" + name + "' as a " + this.typeName, name);
        }
        p = (NamedEntry)this.nameset.add(name, creator);
        if (this.isLocked()) {
            p.setSystem();
            if (p instanceof ClassifiableEntry) {
                ((ClassifiableEntry)p).setNonClassifiable(true);
            }
        }
        return (T)p;
    }

    public boolean remove(T p) {
        if (!this.isRegistered(((NamedEntry)p).getIRI())) {
            return false;
        }
        this.nameset.remove(((NamedEntry)p).getIRI());
        return false;
    }

    public Stream<T> getConcepts() {
        return this.nameset.values().stream();
    }

    @Nullable
    public T first() {
        if (this.nameset.size() > 0) {
            return (T)((NamedEntry)this.nameset.values().iterator().next());
        }
        return null;
    }

    public int size() {
        return this.nameset.size();
    }
}

