/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.jfact.kernel;

import conformance.PortedFrom;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nonnull;
import uk.ac.manchester.cs.jfact.datatypes.Literal;
import uk.ac.manchester.cs.jfact.kernel.dl.ConceptAnd;
import uk.ac.manchester.cs.jfact.kernel.dl.ConceptBottom;
import uk.ac.manchester.cs.jfact.kernel.dl.ConceptDataExactCardinality;
import uk.ac.manchester.cs.jfact.kernel.dl.ConceptDataExists;
import uk.ac.manchester.cs.jfact.kernel.dl.ConceptDataForall;
import uk.ac.manchester.cs.jfact.kernel.dl.ConceptDataMaxCardinality;
import uk.ac.manchester.cs.jfact.kernel.dl.ConceptDataMinCardinality;
import uk.ac.manchester.cs.jfact.kernel.dl.ConceptDataValue;
import uk.ac.manchester.cs.jfact.kernel.dl.ConceptNot;
import uk.ac.manchester.cs.jfact.kernel.dl.ConceptObjectExactCardinality;
import uk.ac.manchester.cs.jfact.kernel.dl.ConceptObjectExists;
import uk.ac.manchester.cs.jfact.kernel.dl.ConceptObjectForall;
import uk.ac.manchester.cs.jfact.kernel.dl.ConceptObjectMaxCardinality;
import uk.ac.manchester.cs.jfact.kernel.dl.ConceptObjectMinCardinality;
import uk.ac.manchester.cs.jfact.kernel.dl.ConceptObjectSelf;
import uk.ac.manchester.cs.jfact.kernel.dl.ConceptObjectValue;
import uk.ac.manchester.cs.jfact.kernel.dl.ConceptOr;
import uk.ac.manchester.cs.jfact.kernel.dl.ConceptTop;
import uk.ac.manchester.cs.jfact.kernel.dl.DataAnd;
import uk.ac.manchester.cs.jfact.kernel.dl.DataBottom;
import uk.ac.manchester.cs.jfact.kernel.dl.DataNot;
import uk.ac.manchester.cs.jfact.kernel.dl.DataOneOf;
import uk.ac.manchester.cs.jfact.kernel.dl.DataOr;
import uk.ac.manchester.cs.jfact.kernel.dl.DataRoleBottom;
import uk.ac.manchester.cs.jfact.kernel.dl.DataRoleTop;
import uk.ac.manchester.cs.jfact.kernel.dl.DataTop;
import uk.ac.manchester.cs.jfact.kernel.dl.ObjectRoleBottom;
import uk.ac.manchester.cs.jfact.kernel.dl.ObjectRoleChain;
import uk.ac.manchester.cs.jfact.kernel.dl.ObjectRoleProjectionFrom;
import uk.ac.manchester.cs.jfact.kernel.dl.ObjectRoleProjectionInto;
import uk.ac.manchester.cs.jfact.kernel.dl.ObjectRoleTop;
import uk.ac.manchester.cs.jfact.kernel.dl.interfaces.ConceptExpression;
import uk.ac.manchester.cs.jfact.kernel.dl.interfaces.DataExpression;
import uk.ac.manchester.cs.jfact.kernel.dl.interfaces.DataRoleExpression;
import uk.ac.manchester.cs.jfact.kernel.dl.interfaces.IndividualExpression;
import uk.ac.manchester.cs.jfact.kernel.dl.interfaces.ObjectRoleComplexExpression;
import uk.ac.manchester.cs.jfact.kernel.dl.interfaces.ObjectRoleExpression;
import uk.ac.manchester.cs.jfact.kernel.dl.interfaces.RoleExpression;

@PortedFrom(file="tExpressionManager.h", name="TExpressionManager")
public class ExpressionManager
implements Serializable {
    @PortedFrom(file="tExpressionManager.h", name="CTop")
    @Nonnull
    private static final ConceptTop top = new ConceptTop();
    @PortedFrom(file="tExpressionManager.h", name="CBottom")
    @Nonnull
    private static final ConceptBottom bottom = new ConceptBottom();
    @PortedFrom(file="tExpressionManager.h", name="DTop")
    @Nonnull
    private static final DataTop dataTop = new DataTop();
    @PortedFrom(file="tExpressionManager.h", name="ORTop")
    @Nonnull
    private static final ObjectRoleExpression objectRoleTop = new ObjectRoleTop();
    @PortedFrom(file="tExpressionManager.h", name="ORBottom")
    @Nonnull
    private static final ObjectRoleExpression objectRoleBottom = new ObjectRoleBottom();
    @PortedFrom(file="tExpressionManager.h", name="DRTop")
    @Nonnull
    private static final DataRoleExpression dataRoleTop = new DataRoleTop();
    @PortedFrom(file="tExpressionManager.h", name="DRBottom")
    @Nonnull
    private static final DataRoleExpression dataRoleBottom = new DataRoleBottom();
    @PortedFrom(file="tExpressionManager.h", name="DBottom")
    @Nonnull
    private static final DataBottom dataBottom = new DataBottom();

    private ExpressionManager() {
    }

    @PortedFrom(file="tExpressionManager.h", name="isUniversalRole")
    public static boolean isUniversalRole(RoleExpression r) {
        return r.equals(dataRoleTop) || r.equals(objectRoleTop);
    }

    @PortedFrom(file="tExpressionManager.h", name="isEmptyRole")
    public static boolean isEmptyRole(RoleExpression r) {
        return r.equals(dataRoleBottom) || r.equals(objectRoleBottom);
    }

    @PortedFrom(file="tExpressionManager.h", name="top")
    public static ConceptTop top() {
        return top;
    }

    @PortedFrom(file="tExpressionManager.h", name="bottom")
    public static ConceptBottom bottom() {
        return bottom;
    }

    @PortedFrom(file="tExpressionManager.h", name="Not")
    public static ConceptExpression not(ConceptExpression r) {
        return new ConceptNot(r);
    }

    @PortedFrom(file="tExpressionManager.h", name="and")
    public static ConceptExpression and(List<ConceptExpression> l) {
        return new ConceptAnd(l);
    }

    @PortedFrom(file="tExpressionManager.h", name="and")
    public static ConceptExpression and(ConceptExpression c, ConceptExpression d) {
        if (c.equals(d)) {
            return c;
        }
        if (c instanceof ConceptTop) {
            return d;
        }
        if (d instanceof ConceptTop) {
            return c;
        }
        return ExpressionManager.and(Arrays.asList(c, d));
    }

    @PortedFrom(file="tExpressionManager.h", name="or")
    public static ConceptExpression or(ConceptExpression c, ConceptExpression d) {
        return ExpressionManager.or(Arrays.asList(c, d));
    }

    @PortedFrom(file="tExpressionManager.h", name="or")
    public static ConceptExpression or(List<ConceptExpression> l) {
        return new ConceptOr(l);
    }

    @PortedFrom(file="tExpressionManager.h", name="SelfReference")
    public static ConceptExpression selfReference(ObjectRoleExpression r) {
        return new ConceptObjectSelf(r);
    }

    @PortedFrom(file="tExpressionManager.h", name="value")
    public static ConceptExpression value(ObjectRoleExpression r, IndividualExpression i) {
        return new ConceptObjectValue(r, i);
    }

    @PortedFrom(file="tExpressionManager.h", name="Exists")
    public static ConceptExpression exists(ObjectRoleExpression r, ConceptExpression c) {
        return new ConceptObjectExists(r, c);
    }

    @PortedFrom(file="tExpressionManager.h", name="Forall")
    public static ConceptExpression forall(ObjectRoleExpression r, ConceptExpression c) {
        return new ConceptObjectForall(r, c);
    }

    @PortedFrom(file="tExpressionManager.h", name="MinCardinality")
    public static ConceptExpression minCardinality(int n, ObjectRoleExpression r, ConceptExpression c) {
        return new ConceptObjectMinCardinality(n, r, c);
    }

    @PortedFrom(file="tExpressionManager.h", name="MaxCardinality")
    public static ConceptExpression maxCardinality(int n, ObjectRoleExpression r, ConceptExpression c) {
        return new ConceptObjectMaxCardinality(n, r, c);
    }

    @PortedFrom(file="tExpressionManager.h", name="cardinality")
    public static ConceptExpression cardinality(int n, ObjectRoleExpression r, ConceptExpression c) {
        return new ConceptObjectExactCardinality(n, r, c);
    }

    @PortedFrom(file="tExpressionManager.h", name="value")
    public static ConceptExpression value(DataRoleExpression r, Literal<?> v) {
        return new ConceptDataValue(r, v);
    }

    @PortedFrom(file="tExpressionManager.h", name="Exists")
    public static ConceptExpression exists(DataRoleExpression r, DataExpression e) {
        return new ConceptDataExists(r, e);
    }

    @PortedFrom(file="tExpressionManager.h", name="Forall")
    public static ConceptExpression forall(DataRoleExpression r, DataExpression e) {
        return new ConceptDataForall(r, e);
    }

    @PortedFrom(file="tExpressionManager.h", name="MinCardinality")
    public static ConceptExpression minCardinality(int n, DataRoleExpression r, DataExpression e) {
        return new ConceptDataMinCardinality(n, r, e);
    }

    @PortedFrom(file="tExpressionManager.h", name="MaxCardinality")
    public static ConceptExpression maxCardinality(int n, DataRoleExpression r, DataExpression e) {
        return new ConceptDataMaxCardinality(n, r, e);
    }

    @PortedFrom(file="tExpressionManager.h", name="cardinality")
    public static ConceptExpression cardinality(int n, DataRoleExpression r, DataExpression e) {
        return new ConceptDataExactCardinality(n, r, e);
    }

    @PortedFrom(file="tExpressionManager.h", name="ObjectRoleTop")
    public static ObjectRoleExpression objectRoleTop() {
        return objectRoleTop;
    }

    @PortedFrom(file="tExpressionManager.h", name="ObjectRoleBottom")
    public static ObjectRoleExpression objectRoleBottom() {
        return objectRoleBottom;
    }

    @PortedFrom(file="tExpressionManager.h", name="Compose")
    public static ObjectRoleComplexExpression compose(List<ObjectRoleExpression> l) {
        return new ObjectRoleChain(l);
    }

    @PortedFrom(file="tExpressionManager.h", name="Compose")
    public static ObjectRoleComplexExpression compose(ObjectRoleExpression e1, ObjectRoleExpression e2) {
        return new ObjectRoleChain(Arrays.asList(e1, e2));
    }

    @PortedFrom(file="tExpressionManager.h", name="ProjectFrom")
    public static ObjectRoleComplexExpression projectFrom(ObjectRoleExpression r, ConceptExpression c) {
        return new ObjectRoleProjectionFrom(r, c);
    }

    @PortedFrom(file="tExpressionManager.h", name="ProjectInto")
    public static ObjectRoleComplexExpression projectInto(ObjectRoleExpression r, ConceptExpression c) {
        return new ObjectRoleProjectionInto(r, c);
    }

    @PortedFrom(file="tExpressionManager.h", name="DataRoleTop")
    public static DataRoleExpression dataRoleTop() {
        return dataRoleTop;
    }

    @PortedFrom(file="tExpressionManager.h", name="DataRoleBottom")
    public static DataRoleExpression dataRoleBottom() {
        return dataRoleBottom;
    }

    @PortedFrom(file="tExpressionManager.h", name="DataTop")
    public static DataExpression dataTop() {
        return dataTop;
    }

    @PortedFrom(file="tExpressionManager.h", name="DataBottom")
    public static DataBottom dataBottom() {
        return dataBottom;
    }

    @PortedFrom(file="tExpressionManager.h", name="DataNot")
    public static DataExpression dataNot(DataExpression rm) {
        return new DataNot(rm);
    }

    @PortedFrom(file="tExpressionManager.h", name="DataAnd")
    public static DataExpression dataAnd(List<DataExpression> l) {
        return new DataAnd(l);
    }

    @PortedFrom(file="tExpressionManager.h", name="DataOr")
    public static DataExpression dataOr(List<DataExpression> l) {
        return new DataOr(l);
    }

    @PortedFrom(file="tExpressionManager.h", name="DataOneOf")
    public static DataExpression dataOneOf(List<Literal<?>> l) {
        return new DataOneOf(l);
    }
}

