/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.jfact.kernel;

import conformance.Original;
import conformance.PortedFrom;
import gnu.trove.list.TIntList;
import gnu.trove.list.array.TIntArrayList;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.semanticweb.owlapi.model.HasIRI;
import org.semanticweb.owlapi.reasoner.TimeOutException;
import uk.ac.manchester.cs.chainsaw.FastSet;
import uk.ac.manchester.cs.chainsaw.FastSetFactory;
import uk.ac.manchester.cs.chainsaw.LocalFastSet;
import uk.ac.manchester.cs.jfact.datatypes.DataTypeReasoner;
import uk.ac.manchester.cs.jfact.datatypes.DatatypeEntry;
import uk.ac.manchester.cs.jfact.datatypes.LiteralEntry;
import uk.ac.manchester.cs.jfact.dep.DepSet;
import uk.ac.manchester.cs.jfact.helpers.DLVertex;
import uk.ac.manchester.cs.jfact.helpers.Helper;
import uk.ac.manchester.cs.jfact.helpers.LogAdapter;
import uk.ac.manchester.cs.jfact.helpers.Reference;
import uk.ac.manchester.cs.jfact.helpers.SaveStack;
import uk.ac.manchester.cs.jfact.helpers.Stats;
import uk.ac.manchester.cs.jfact.helpers.Templates;
import uk.ac.manchester.cs.jfact.helpers.Timer;
import uk.ac.manchester.cs.jfact.helpers.UnreachableSituationException;
import uk.ac.manchester.cs.jfact.kernel.AddConceptResult;
import uk.ac.manchester.cs.jfact.kernel.CGLabel;
import uk.ac.manchester.cs.jfact.kernel.CWDArray;
import uk.ac.manchester.cs.jfact.kernel.Concept;
import uk.ac.manchester.cs.jfact.kernel.ConceptWDep;
import uk.ac.manchester.cs.jfact.kernel.DLDag;
import uk.ac.manchester.cs.jfact.kernel.DagTag;
import uk.ac.manchester.cs.jfact.kernel.DlCompletionGraph;
import uk.ac.manchester.cs.jfact.kernel.DlCompletionTree;
import uk.ac.manchester.cs.jfact.kernel.DlCompletionTreeArc;
import uk.ac.manchester.cs.jfact.kernel.EdgeCompare;
import uk.ac.manchester.cs.jfact.kernel.Individual;
import uk.ac.manchester.cs.jfact.kernel.KBFlags;
import uk.ac.manchester.cs.jfact.kernel.NamedEntry;
import uk.ac.manchester.cs.jfact.kernel.RAStateTransitions;
import uk.ac.manchester.cs.jfact.kernel.RATransition;
import uk.ac.manchester.cs.jfact.kernel.Redo;
import uk.ac.manchester.cs.jfact.kernel.Restorer;
import uk.ac.manchester.cs.jfact.kernel.Role;
import uk.ac.manchester.cs.jfact.kernel.SimpleRule;
import uk.ac.manchester.cs.jfact.kernel.TBox;
import uk.ac.manchester.cs.jfact.kernel.dl.interfaces.NamedEntity;
import uk.ac.manchester.cs.jfact.kernel.modelcaches.ModelCacheConst;
import uk.ac.manchester.cs.jfact.kernel.modelcaches.ModelCacheIan;
import uk.ac.manchester.cs.jfact.kernel.modelcaches.ModelCacheInterface;
import uk.ac.manchester.cs.jfact.kernel.modelcaches.ModelCacheState;
import uk.ac.manchester.cs.jfact.kernel.options.JFactReasonerConfiguration;
import uk.ac.manchester.cs.jfact.kernel.todolist.ToDoEntry;
import uk.ac.manchester.cs.jfact.kernel.todolist.ToDoList;

@PortedFrom(file="Reasoner.h", name="DlSatTester")
public class DlSatTester
implements Serializable {
    @PortedFrom(file="Reasoner.h", name="SessionGCIs")
    private final TIntArrayList sessionGCIs = new TIntArrayList();
    @PortedFrom(file="Reasoner.h", name="ActiveSplits")
    private final FastSet activeSplits = FastSetFactory.create();
    @PortedFrom(file="Reasoner.h", name="SessionSignature")
    private final Set<NamedEntity> sessionSignature = new HashSet<NamedEntity>();
    @PortedFrom(file="Reasoner.h", name="SessionSigDepSet")
    private final Map<NamedEntity, DepSet> sessionSigDepSet = new HashMap<NamedEntity, DepSet>();
    @PortedFrom(file="Reasoner.h", name="NodesToMerge")
    private List<DlCompletionTree> nodesToMerge = new ArrayList<DlCompletionTree>();
    @PortedFrom(file="Reasoner.h", name="EdgesToMerge")
    private List<DlCompletionTreeArc> edgesToMerge = new ArrayList<DlCompletionTreeArc>();
    @PortedFrom(file="Reasoner.h", name="tBox")
    protected final TBox tBox;
    @PortedFrom(file="Reasoner.h", name="DLHeap")
    protected final DLDag dlHeap;
    @PortedFrom(file="Reasoner.h", name="ReflexiveRoles")
    private final List<Role> reflexiveRoles = new ArrayList<Role>();
    @PortedFrom(file="Reasoner.h", name="CGraph")
    protected final DlCompletionGraph cGraph;
    @PortedFrom(file="Reasoner.h", name="TODO")
    private final ToDoList todo;
    @Original
    private final FastSet used = new LocalFastSet();
    @PortedFrom(file="Reasoner.h", name="GCIs")
    private final KBFlags gcis;
    @PortedFrom(file="Reasoner.h", name="inProcess")
    private final FastSet inProcess = FastSetFactory.create();
    @PortedFrom(file="Reasoner.h", name="satTimer")
    private final Timer satTimer = new Timer();
    @PortedFrom(file="Reasoner.h", name="subTimer")
    private final Timer subTimer = new Timer();
    @PortedFrom(file="Reasoner.h", name="testTimer")
    private final Timer testTimer = new Timer();
    @PortedFrom(file="Reasoner.h", name="Stack")
    protected final BCStack stack = new BCStack();
    @PortedFrom(file="Reasoner.h", name="bContext")
    protected BranchingContext bContext;
    @PortedFrom(file="Reasoner.h", name="tryLevel")
    private int tryLevel;
    @PortedFrom(file="Reasoner.h", name="nonDetShift")
    protected int nonDetShift;
    @PortedFrom(file="Reasoner.h", name="curNode")
    protected DlCompletionTree curNode;
    @Original
    private DepSet curConceptDepSet;
    @Original
    private int curConceptConcept;
    @PortedFrom(file="Reasoner.h", name="dagSize")
    private int dagSize;
    @PortedFrom(file="Reasoner.h", name="OrConceptsToTest")
    private List<ConceptWDep> orConceptsToTest = new ArrayList<ConceptWDep>();
    @PortedFrom(file="Reasoner.h", name="clashSet")
    private DepSet clashSet = DepSet.create();
    @Original
    protected final JFactReasonerConfiguration options;
    @PortedFrom(file="Reasoner.h", name="encounterNominal")
    private boolean encounterNominal;
    @PortedFrom(file="Reasoner.h", name="checkDataNode")
    private boolean checkDataNode;
    @PortedFrom(file="Reasoner.h", name="newNodeCache")
    private final ModelCacheIan newNodeCache;
    @PortedFrom(file="Reasoner.h", name="newNodeEdges")
    private final ModelCacheIan newNodeEdges;
    @Original
    private final Stats stats = new Stats();
    @Original
    private static final EnumSet<DagTag> handlecollection = EnumSet.of(DagTag.AND, DagTag.COLLECTION);
    @Original
    private static final EnumSet<DagTag> handleforallle = EnumSet.of(DagTag.FORALL, DagTag.LE);
    @Original
    private static final EnumSet<DagTag> handlesingleton = EnumSet.of(DagTag.PSINGLETON, DagTag.NSINGLETON, DagTag.NCONCEPT, DagTag.PCONCEPT);
    private static final Comparator<DlCompletionTree> nodeCompare = Comparator.comparing(DlCompletionTree::getNominalLevel).thenComparing(DlCompletionTree::getId);

    protected DlSatTester(TBox tbox, JFactReasonerConfiguration options) {
        this.options = options;
        this.tBox = tbox;
        this.dlHeap = tbox.getDLHeap();
        this.cGraph = new DlCompletionGraph(1, this);
        this.todo = new ToDoList(this.cGraph.getRareStack());
        this.newNodeCache = new ModelCacheIan(true, tbox.nC, tbox.nR.get(), options);
        this.newNodeEdges = new ModelCacheIan(false, tbox.nC, tbox.nR.get(), options);
        this.gcis = tbox.getGCIs();
        this.bContext = null;
        this.tryLevel = 1;
        this.nonDetShift = 0;
        this.curNode = null;
        this.dagSize = 0;
        options.getLog().printTemplate(Templates.READCONFIG, options.getuseSemanticBranching(), options.getuseBackjumping(), options.getuseLazyBlocking(), options.getUseAnywhereBlocking());
        if (this.tBox.hasFC() && options.getUseAnywhereBlocking()) {
            options.setUseAnywhereBlocking(false);
            options.getLog().print("Fairness constraints: set useAnywhereBlocking = false\n");
        }
        this.cGraph.initContext(tbox.getnSkipBeforeBlock(), options.getuseLazyBlocking(), options.getUseAnywhereBlocking());
        tbox.getORM().fillReflexiveRoles(this.reflexiveRoles);
        this.resetSessionFlags();
    }

    @PortedFrom(file="Reasoner.h", name="isNodeGloballyUsed")
    private static boolean isNodeGloballyUsed(DlCompletionTree node) {
        return !node.isDataNode() && !node.isIBlocked() && !node.isPBlocked();
    }

    @PortedFrom(file="Reasoner.h", name="isObjectNodeUnblocked")
    private static boolean isObjectNodeUnblocked(DlCompletionTree node) {
        return DlSatTester.isNodeGloballyUsed(node) && !node.isDBlocked();
    }

    @PortedFrom(file="Reasoner.h", name="updateName")
    private void updateName(DlCompletionTree node, int bp) {
        CGLabel lab = node.label();
        ConceptWDep c = lab.getSCConceptWithBP(bp);
        if (c == null) {
            c = lab.getSCConceptWithBP(-bp);
        }
        if (c != null) {
            this.addExistingToDoEntry(node, c, "sp");
        }
    }

    @PortedFrom(file="Reasoner.h", name="updateName")
    private void updateName(int bp) {
        this.cGraph.nodes().filter(DlSatTester::isNodeGloballyUsed).forEach(n2 -> this.updateName((DlCompletionTree)n2, bp));
    }

    @PortedFrom(file="Reasoner.h", name="addExistingToDoEntry")
    private void addExistingToDoEntry(DlCompletionTree node, ConceptWDep c, String reason) {
        int bp = c.getConcept();
        this.todo.addEntry(node, this.dlHeap.get(bp).getType(), c);
        this.logNCEntry(node, c.getConcept(), c.getDep(), "+", reason);
    }

    @PortedFrom(file="Reasoner.h", name="redoNodeLabel")
    private void redoNodeLabel(DlCompletionTree node, String reason) {
        CGLabel lab = node.label();
        lab.getSimpleConcepts().forEach(c -> this.addExistingToDoEntry(node, (ConceptWDep)c, reason));
        lab.getComplexConcepts().forEach(c -> this.addExistingToDoEntry(node, (ConceptWDep)c, reason));
    }

    @PortedFrom(file="Reasoner.h", name="ensureDAGSize")
    private void ensureDAGSize() {
        if (this.dagSize < this.dlHeap.size()) {
            this.dagSize = this.dlHeap.maxSize();
        }
    }

    @PortedFrom(file="Reasoner.h", name="createModelCache")
    protected ModelCacheInterface createModelCache(DlCompletionTree p) {
        return new ModelCacheIan(this.dlHeap, p, this.encounterNominal, this.tBox.nC, this.tBox.nR.get(), this.options);
    }

    @PortedFrom(file="Reasoner.h", name="tryCacheNode")
    private ModelCacheState tryCacheNode(DlCompletionTree node) {
        boolean val;
        ModelCacheState ret = this.canBeCached(node) ? this.reportNodeCached(node) : ModelCacheState.FAILED;
        boolean bl = val = ret == ModelCacheState.VALID;
        if (node.isCached() != val) {
            Restorer setCached = node.setCached(val);
            this.cGraph.saveRareCond(setCached);
        }
        return ret;
    }

    @PortedFrom(file="Reasoner.h", name="applyExtraRulesIf")
    private boolean applyExtraRulesIf(Concept p) {
        if (!p.hasExtraRules()) {
            return false;
        }
        assert (p.isPrimitive());
        return this.applyExtraRules(p);
    }

    @PortedFrom(file="Reasoner.h", name="hasNominals")
    public boolean hasNominals() {
        return false;
    }

    @PortedFrom(file="Reasoner.h", name="isIBlocked")
    private boolean isIBlocked() {
        return this.curNode.isIBlocked();
    }

    @PortedFrom(file="Reasoner.h", name="isSomeExists")
    private boolean isSomeExists(Role r, int c) {
        if (!this.used.contains(c)) {
            return false;
        }
        DlCompletionTree where = this.curNode.isSomeApplicable(r, c);
        if (where != null) {
            this.options.getLog().printTemplateMixInt(Templates.E, r.getIRI(), where.getId(), c);
        }
        return where != null;
    }

    @PortedFrom(file="Reasoner.h", name="isFirstBranchCall")
    private boolean isFirstBranchCall() {
        return this.bContext == null;
    }

    @PortedFrom(file="Reasoner.h", name="initBC")
    protected void initBC(BranchingContext c) {
        c.node = this.curNode;
        c.concept = new ConceptWDep(this.curConceptConcept, this.curConceptDepSet);
        c.branchDep = DepSet.create(this.curConceptDepSet);
        c.sgSize = this.sessionGCIs.size();
    }

    @PortedFrom(file="Reasoner.h", name="createBCOr")
    private void createBCOr() {
        this.bContext = this.stack.pushOr();
    }

    @PortedFrom(file="Reasoner.h", name="createBCNN")
    private void createBCNN() {
        this.bContext = this.stack.pushNN();
    }

    @PortedFrom(file="Reasoner.h", name="createBCLE")
    private void createBCLE() {
        this.bContext = this.stack.pushLE();
    }

    @PortedFrom(file="Reasoner.h", name="createBCCh")
    private void createBCCh() {
        this.bContext = this.stack.pushCh();
    }

    @PortedFrom(file="Reasoner.h", name="isFunctionalVertex")
    private static boolean isFunctionalVertex(DLVertex v) {
        return v.getType() == DagTag.LE && v.getNumberLE() == 1 && v.getConceptIndex() == 1;
    }

    @PortedFrom(file="Reasoner.h", name="checkNRclash")
    private static boolean checkNRclash(DLVertex atleast, DLVertex atmost) {
        return (atmost.getConceptIndex() == 1 || atleast.getConceptIndex() == atmost.getConceptIndex()) && atleast.getNumberGE() > atmost.getNumberLE() && atleast.getRole().lesserequal(atmost.getRole());
    }

    @PortedFrom(file="Reasoner.h", name="isQuickClashLE")
    private boolean isQuickClashLE(DLVertex atmost) {
        return this.curNode.complexConcepts().stream().anyMatch(q -> q.getConcept() < 0 && this.isNRClash(this.dlHeap.get(q.getConcept()), atmost, (ConceptWDep)q));
    }

    @PortedFrom(file="Reasoner.h", name="isQuickClashGE")
    private boolean isQuickClashGE(DLVertex atleast) {
        return this.curNode.complexConcepts().stream().anyMatch(q -> q.getConcept() > 0 && this.isNRClash(atleast, this.dlHeap.get(q.getConcept()), (ConceptWDep)q));
    }

    @PortedFrom(file="Reasoner.h", name="findChooseRuleConcept")
    private boolean findChooseRuleConcept(CWDArray label, int c, @Nullable DepSet d) {
        if (c == 1) {
            return true;
        }
        if (this.findConceptClash(label, c, d)) {
            if (d != null) {
                d.add(this.clashSet);
            }
            return true;
        }
        if (this.findConceptClash(label, -c, d)) {
            if (d != null) {
                d.add(this.clashSet);
            }
            return false;
        }
        throw new UnreachableSituationException();
    }

    @PortedFrom(file="Reasoner.h", name="checkDisjointRoleClash")
    private boolean checkDisjointRoleClash(DlCompletionTreeArc edge, DlCompletionTree to, Role r, DepSet dep) {
        if (edge.getArcEnd().equals(to) && edge.getRole().isDisjoint(r)) {
            this.setClashSet(dep);
            this.updateClashSet(edge.getDep());
            return true;
        }
        return false;
    }

    @PortedFrom(file="Reasoner.h", name="checkIrreflexivity")
    private boolean checkIrreflexivity(DlCompletionTreeArc edge, Role r, DepSet dep) {
        if (!edge.getArcEnd().equals(edge.getReverse().getArcEnd())) {
            return false;
        }
        if (!edge.isNeighbour(r) && !edge.isNeighbour(r.inverse())) {
            return false;
        }
        this.setClashSet(dep);
        this.updateClashSet(edge.getDep());
        return true;
    }

    @PortedFrom(file="Reasoner.h", name="logNCEntry")
    private void logNCEntry(DlCompletionTree n, int bp, DepSet dep, String action, @Nullable String reason) {
        if (this.options.isLoggingActive()) {
            LogAdapter logAdapter = this.options.getLog();
            logAdapter.print(" ").print(action).print("(").print(n.logNode()).print(",").print(bp).print((Object)dep, (Object)")");
            if (reason != null) {
                logAdapter.print(reason);
            }
        }
    }

    @PortedFrom(file="Reasoner.h", name="getCurLevel")
    private int getCurLevel() {
        return this.tryLevel;
    }

    @PortedFrom(file="Reasoner.h", name="setCurLevel")
    private void setCurLevel(int level) {
        this.tryLevel = level;
    }

    @PortedFrom(file="Reasoner.h", name="noBranchingOps")
    protected boolean noBranchingOps() {
        return this.tryLevel == 1 + this.nonDetShift;
    }

    @PortedFrom(file="Reasoner.h", name="getSaveRestoreLevel")
    private int getSaveRestoreLevel(DepSet ds) {
        if (this.options.isImproveSaveRestoreDepset()) {
            return ds.level() + 1;
        }
        return this.getCurLevel();
    }

    @PortedFrom(file="Reasoner.h", name="restore")
    private void restore() {
        this.restore(this.getCurLevel() - 1);
    }

    @PortedFrom(file="Reasoner.h", name="updateLevel")
    private void updateLevel(DlCompletionTree n, DepSet ds) {
        this.cGraph.saveNode(n, this.getSaveRestoreLevel(ds));
    }

    @PortedFrom(file="Reasoner.h", name="determiniseBranchingOp")
    private void determiniseBranchingOp() {
        this.bContext = null;
        this.stack.pop();
    }

    @PortedFrom(file="Reasoner.h", name="setClashSet")
    private void setClashSet(DepSet d) {
        this.clashSet = d;
    }

    @PortedFrom(file="Reasoner.h", name="setClashSet")
    private void setClashSet(List<DepSet> depsets) {
        DepSet dep = DepSet.create();
        depsets.forEach(dep::add);
        this.clashSet = dep;
    }

    @PortedFrom(file="Reasoner.h", name="updateClashSet")
    private void updateClashSet(DepSet d) {
        this.clashSet.add(d);
    }

    @PortedFrom(file="Reasoner.h", name="getCurDepSet")
    private DepSet getCurDepSet() {
        return DepSet.create(this.getCurLevel() - 1);
    }

    @PortedFrom(file="Reasoner.h", name="getBranchDep")
    private DepSet getBranchDep() {
        return this.bContext.branchDep;
    }

    @PortedFrom(file="Reasoner.h", name="prepareBranchDep")
    private void prepareBranchDep() {
        this.getBranchDep().restrict(this.getCurLevel());
    }

    @PortedFrom(file="Reasoner.h", name="useBranchDep")
    private void useBranchDep() {
        this.prepareBranchDep();
        this.setClashSet(this.getBranchDep());
    }

    @PortedFrom(file="Reasoner.h", name="repeatUnblockedNode")
    public void repeatUnblockedNode(DlCompletionTree node, boolean direct) {
        if (direct) {
            this.applyAllGeneratingRules(node);
        } else {
            this.redoNodeLabel(node, "ubi");
        }
    }

    @PortedFrom(file="Reasoner.h", name="getDAG")
    public DLDag getDAG() {
        return this.tBox.getDLHeap();
    }

    @PortedFrom(file="Reasoner.h", name="getRootNode")
    public DlCompletionTree getRootNode() {
        return this.cGraph.getRoot();
    }

    @Original
    public void initToDoPriorities() {
        String iaoeflg = this.options.getIAOEFLG();
        this.options.getLog().print((Object)"\nInit IAOEFLG = ", (Object)iaoeflg);
        this.todo.initPriorities(iaoeflg);
    }

    @PortedFrom(file="Reasoner.h", name="setBlockingMethod")
    public void setBlockingMethod(boolean hasInverse, boolean hasQCR) {
        this.cGraph.setBlockingMethod(hasInverse, hasQCR);
    }

    @PortedFrom(file="Reasoner.h", name="buildCacheByCGraph")
    public ModelCacheInterface buildCacheByCGraph(boolean sat) {
        if (sat) {
            return this.createModelCache(this.getRootNode());
        }
        return ModelCacheConst.createConstCache(-1);
    }

    @PortedFrom(file="Reasoner.h", name="writeTotalStatistic")
    public void writeTotalStatistic(LogAdapter o) {
        if (this.options.isUseReasoningStatistics()) {
            this.stats.accumulate();
            this.stats.logStatisticData(o, false, this.cGraph, this.options);
        }
        o.print("\n");
    }

    @PortedFrom(file="Reasoner.h", name="createCache")
    public ModelCacheInterface createCache(int p, FastSet f) {
        assert (Helper.isValid(p));
        ModelCacheInterface cache = this.dlHeap.getCache(p);
        if (cache != null) {
            return cache;
        }
        if (!this.tBox.testHasTopRole()) {
            this.prepareCascadedCache(p, f);
        }
        if ((cache = this.dlHeap.getCache(p)) != null) {
            return cache;
        }
        cache = this.buildCache(p);
        this.dlHeap.setCache(p, cache);
        return cache;
    }

    @PortedFrom(file="Reasoner.h", name="prepareCascadedCache")
    private void prepareCascadedCache(int p, FastSet f) {
        Role r;
        boolean pos;
        if (this.inProcess.contains(p)) {
            return;
        }
        if (f.contains(p)) {
            return;
        }
        DLVertex v = this.dlHeap.get(p);
        boolean bl = pos = p > 0;
        if (v.getCache(pos) != null) {
            return;
        }
        DagTag type = v.getType();
        if (handlecollection.contains((Object)type)) {
            int[] nArray = v.begin();
            int n = nArray.length;
            int n2 = 0;
            while (n2 < n) {
                int q = nArray[n2];
                int p2 = pos ? q : -q;
                this.inProcess.add(p2);
                this.prepareCascadedCache(p2, f);
                this.inProcess.remove(p2);
                ++n2;
            }
        } else if (handlesingleton.contains((Object)type)) {
            if (!pos && type.isPNameTag()) {
                return;
            }
            this.inProcess.add(p);
            this.prepareCascadedCache(pos ? v.getConceptIndex() : -v.getConceptIndex(), f);
            this.inProcess.remove(p);
        } else if (handleforallle.contains((Object)type) && !(r = v.getRole()).isDataRole() && !r.isTop()) {
            int x;
            int n = x = pos ? v.getConceptIndex() : -v.getConceptIndex();
            if (x != 1) {
                this.inProcess.add(x);
                this.createCache(x, f);
                this.inProcess.remove(x);
            }
            if ((x = r.getBPRange()) != 1) {
                this.inProcess.add(x);
                this.createCache(x, f);
                this.inProcess.remove(x);
            }
        }
        f.add(p);
    }

    @PortedFrom(file="Reasoner.h", name="buildCache")
    private ModelCacheInterface buildCache(int p) {
        boolean sat;
        LogAdapter logAdapter = this.options.getLog();
        if (this.options.isLoggingActive()) {
            logAdapter.print("\nChecking satisfiability of DAG entry ").print(p);
            this.tBox.printDagEntry(logAdapter, p);
            logAdapter.print(":\n");
        }
        if (!(sat = this.runSat(p, 1))) {
            logAdapter.printTemplateInt(Templates.BUILD_CACHE_UNSAT, p);
        }
        return this.buildCacheByCGraph(sat);
    }

    @PortedFrom(file="Reasoner.h", name="resetSessionFlags")
    protected void resetSessionFlags() {
        this.ensureDAGSize();
        this.used.add(1);
        this.used.add(-1);
        this.encounterNominal = false;
        this.checkDataNode = true;
    }

    @PortedFrom(file="Reasoner.h", name="initNewNode")
    protected boolean initNewNode(DlCompletionTree node, DepSet dep, int c) {
        if (node.isDataNode()) {
            this.checkDataNode = false;
        }
        node.setInit(c);
        if (this.addToDoEntry(node, c, dep, null)) {
            return true;
        }
        if (node.isDataNode()) {
            return false;
        }
        if (this.addToDoEntry(node, this.tBox.getTG(), dep, null)) {
            return true;
        }
        if (this.gcis.isReflexive() && this.applyReflexiveRoles(node, dep)) {
            return true;
        }
        int[] nArray = this.sessionGCIs.toArray();
        int n = nArray.length;
        int n2 = 0;
        while (n2 < n) {
            int i = nArray[n2];
            if (this.addToDoEntry(node, i, dep, "sg")) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    @PortedFrom(file="Reasoner.h", name="runSat")
    public boolean runSat(int p, int q) {
        this.prepareReasoner();
        if (this.initNewNode(this.cGraph.getRoot(), DepSet.create(), p) || this.addToDoEntry(this.cGraph.getRoot(), q, DepSet.create(), null)) {
            return false;
        }
        Timer timer = q == 1 ? this.satTimer : this.subTimer;
        timer.start();
        boolean result = this.runSat();
        timer.stop();
        return result;
    }

    @PortedFrom(file="Reasoner.h", name="checkDisjointRoles")
    public boolean checkDisjointRoles(Role r, Role s) {
        this.prepareReasoner();
        DepSet dummy = DepSet.create();
        if (this.initNewNode(this.cGraph.getRoot(), dummy, 1)) {
            return true;
        }
        this.curNode = this.cGraph.getRoot();
        DlCompletionTreeArc edgeR = this.createOneNeighbour(r, dummy);
        DlCompletionTreeArc edgeS = this.createOneNeighbour(s, dummy);
        if (this.initNewNode(edgeR.getArcEnd(), dummy, 1) || this.initNewNode(edgeS.getArcEnd(), dummy, 1) || this.setupEdge(edgeR, dummy, 0) || this.setupEdge(edgeS, dummy, 0) || this.merge(edgeS.getArcEnd(), edgeR.getArcEnd(), dummy)) {
            return true;
        }
        this.curNode = null;
        return !this.runSat();
    }

    @PortedFrom(file="Reasoner.h", name="checkIrreflexivity")
    public boolean checkIrreflexivity(Role r) {
        this.prepareReasoner();
        DepSet dummy = DepSet.create();
        if (this.initNewNode(this.cGraph.getRoot(), dummy, 1)) {
            return true;
        }
        this.curNode = this.cGraph.getRoot();
        DlCompletionTreeArc edgeR = this.createOneNeighbour(r, dummy);
        if (this.initNewNode(edgeR.getArcEnd(), dummy, 1) || this.setupEdge(edgeR, dummy, 0) || this.merge(edgeR.getArcEnd(), this.cGraph.getRoot(), dummy)) {
            return true;
        }
        this.curNode = null;
        return !this.runSat();
    }

    @PortedFrom(file="Reasoner.h", name="backJumpedRestore")
    private boolean backJumpedRestore() {
        if (this.clashSet == null || this.clashSet.isEmpty()) {
            return true;
        }
        this.restore(this.clashSet.level());
        return false;
    }

    @PortedFrom(file="Reasoner.h", name="nextBranchingOption")
    private void nextBranchingOption() {
        this.getBranchDep().add(this.clashSet);
        this.bContext.nextOption();
    }

    @PortedFrom(file="Reasoner.h", name="straightforwardRestore")
    private boolean straightforwardRestore() {
        if (this.noBranchingOps()) {
            return true;
        }
        this.restore();
        return false;
    }

    @PortedFrom(file="Reasoner.h", name="tunedRestore")
    private boolean tunedRestore() {
        if (this.options.getuseBackjumping()) {
            return this.backJumpedRestore();
        }
        return this.straightforwardRestore();
    }

    @PortedFrom(file="Reasoner.h", name="commonTacticBodyAll")
    private boolean commonTacticBodyAll(DLVertex cur) {
        assert (this.curConceptConcept > 0 && cur.getType() == DagTag.FORALL);
        if (cur.getRole().isTop()) {
            this.stats.getnAllCalls().inc();
            return this.addSessionGCI(cur.getConceptIndex(), this.curConceptDepSet);
        }
        if (cur.getRole().isSimple()) {
            return this.commonTacticBodyAllSimple(cur);
        }
        return this.commonTacticBodyAllComplex(cur);
    }

    @PortedFrom(file="Tactic.cpp", name="addSessionGCI")
    private boolean addSessionGCI(int c, DepSet dep) {
        this.sessionGCIs.add(c);
        return this.cGraph.nodes().anyMatch(node -> DlSatTester.isNodeGloballyUsed(node) && this.addToDoEntry((DlCompletionTree)node, c, dep, "sg"));
    }

    @Original
    public JFactReasonerConfiguration getOptions() {
        return this.options;
    }

    @PortedFrom(file="Reasoner.h", name="prepareReasoner")
    protected void prepareReasoner() {
        this.cGraph.clear();
        this.stack.clear();
        this.todo.clear();
        this.used.clear();
        this.sessionGCIs.clear();
        this.curNode = null;
        this.bContext = null;
        this.tryLevel = 1;
        this.resetSessionFlags();
    }

    @PortedFrom(file="Reasoner.h", name="findConcept")
    public boolean findConcept(CWDArray label, int p) {
        assert (Helper.isCorrect(p));
        assert (p != 1);
        assert (p != -1);
        this.stats.getnLookups().inc();
        return label.contains(p);
    }

    @PortedFrom(file="Reasoner.h", name="checkAddedConcept")
    private AddConceptResult checkAddedConcept(CWDArray lab, int p, @Nullable DepSet dep) {
        assert (Helper.isCorrect(p));
        if (this.findConcept(lab, p)) {
            return AddConceptResult.EXIST;
        }
        if (this.findConceptClash(lab, -p, dep)) {
            return AddConceptResult.CLASH;
        }
        return AddConceptResult.DONE;
    }

    @PortedFrom(file="Reasoner.h", name="findConceptClash")
    private boolean findConceptClash(CWDArray lab, int bp, @Nullable DepSet dep) {
        assert (Helper.isCorrect(bp));
        assert (bp != 1);
        assert (bp != -1);
        this.stats.getnLookups().inc();
        DepSet depset = lab.get(bp);
        if (depset != null) {
            this.clashSet = DepSet.plus(depset, dep);
            return true;
        }
        return false;
    }

    @PortedFrom(file="Reasoner.h", name="tryAddConcept")
    private AddConceptResult tryAddConcept(CWDArray lab, int bp, @Nullable DepSet dep) {
        boolean canC = this.used.contains(bp);
        boolean canNegC = this.used.contains(-bp);
        if (canC) {
            if (canNegC) {
                return this.checkAddedConcept(lab, bp, dep);
            }
            this.stats.getnLookups().inc();
            return this.findConcept(lab, bp) ? AddConceptResult.EXIST : AddConceptResult.DONE;
        }
        if (canNegC) {
            return this.findConceptClash(lab, -bp, dep) ? AddConceptResult.CLASH : AddConceptResult.DONE;
        }
        return AddConceptResult.DONE;
    }

    @PortedFrom(file="Reasoner.h", name="addToDoEntry")
    protected boolean addToDoEntry(DlCompletionTree n, int bp, DepSet dep, @Nullable String reason) {
        if (bp == 1) {
            return false;
        }
        if (bp == -1) {
            this.setClashSet(dep);
            this.logNCEntry(n, bp, dep, "x", this.dlHeap.get(bp).getType().getName());
            return true;
        }
        DLVertex v = this.dlHeap.get(bp);
        DagTag tag = v.getType();
        switch (this.tryAddConcept(n.label().getLabel(tag.isComplexConcept()), bp, dep)) {
            case CLASH: {
                this.logNCEntry(n, bp, dep, "x", this.dlHeap.get(bp).getType().getName());
                return true;
            }
            case EXIST: {
                return false;
            }
            case DONE: {
                return this.insertToDoEntry(n, bp, dep, tag, reason);
            }
        }
        throw new UnreachableSituationException();
    }

    @PortedFrom(file="Reasoner.h", name="insertToDoEntry")
    private boolean insertToDoEntry(DlCompletionTree n, int bp, DepSet dep, DagTag tag, @Nullable String reason) {
        ConceptWDep p = new ConceptWDep(bp, dep);
        this.updateLevel(n, dep);
        this.cGraph.addConceptToNode(n, p, tag.isComplexConcept());
        this.used.add(bp);
        if (n.isCached()) {
            return this.correctCachedEntry(n);
        }
        this.todo.addEntry(n, tag, p);
        if (n.isDataNode()) {
            return this.checkDataNode ? this.hasDataClash(n) : false;
        }
        this.logNCEntry(n, bp, dep, "+", reason);
        return false;
    }

    @PortedFrom(file="Reasoner.h", name="canBeCached")
    private boolean canBeCached(DlCompletionTree node) {
        if (!this.options.isUseNodeCache()) {
            return false;
        }
        if (node.isNominalNode()) {
            return false;
        }
        this.stats.getnCacheTry().inc();
        AtomicBoolean shallow = new AtomicBoolean(true);
        AtomicInteger size = new AtomicInteger(0);
        if (node.simpleConcepts().stream().anyMatch(p -> this.canBeCachedCheck(shallow, size, (ConceptWDep)p))) {
            return false;
        }
        if (node.complexConcepts().stream().anyMatch(p -> this.canBeCachedCheck(shallow, size, (ConceptWDep)p))) {
            return false;
        }
        if (shallow.get() && size.get() > 0) {
            this.stats.getnCacheFailedShallow().inc();
            this.options.getLog().print(" cf(s)");
            return false;
        }
        return true;
    }

    protected boolean canBeCachedCheck(AtomicBoolean shallow, AtomicInteger size, ConceptWDep p) {
        if (this.dlHeap.getCache(p.getConcept()) == null) {
            this.stats.getnCacheFailedNoCache().inc();
            this.options.getLog().printTemplateInt(Templates.CAN_BE_CACHED, p.getConcept());
            return true;
        }
        shallow.compareAndSet(true, this.dlHeap.getCache(p.getConcept()).shallowCache());
        size.incrementAndGet();
        return false;
    }

    @PortedFrom(file="Reasoner.h", name="doCacheNode")
    private void doCacheNode(DlCompletionTree node) {
        ArrayList deps = new ArrayList();
        this.newNodeCache.clear();
        if (Stream.concat(node.simpleConcepts().stream(), node.complexConcepts().stream()).anyMatch(p -> this.doCacheNodeCheck(deps, (ConceptWDep)p))) {
            this.newNodeEdges.clear();
            this.newNodeEdges.initRolesFromArcs(node);
            this.newNodeCache.merge(this.newNodeEdges);
        }
    }

    protected boolean doCacheNodeCheck(List<DepSet> deps, ConceptWDep p) {
        deps.add(p.getDep());
        ModelCacheState merge = this.newNodeCache.merge(this.dlHeap.getCache(p.getConcept()));
        if (merge != ModelCacheState.VALID) {
            if (merge == ModelCacheState.INVALID) {
                this.setClashSet(deps);
            }
            return false;
        }
        return true;
    }

    @PortedFrom(file="Reasoner.h", name="reportNodeCached")
    private ModelCacheState reportNodeCached(DlCompletionTree node) {
        this.doCacheNode(node);
        ModelCacheState status = this.newNodeCache.getState();
        switch (status) {
            case VALID: {
                this.stats.getnCachedSat().inc();
                this.options.getLog().printTemplateInt(Templates.REPORT1, node.getId());
                break;
            }
            case INVALID: {
                this.stats.getnCachedUnsat().inc();
                break;
            }
            case FAILED: 
            case UNKNOWN: {
                this.stats.getnCacheFailed().inc();
                this.options.getLog().print(" cf(c)");
                status = ModelCacheState.FAILED;
                break;
            }
            default: {
                throw new UnreachableSituationException();
            }
        }
        return status;
    }

    @PortedFrom(file="Reasoner.h", name="correctCachedEntry")
    private boolean correctCachedEntry(DlCompletionTree n) {
        assert (n.isCached());
        ModelCacheState status = this.tryCacheNode(n);
        if (status == ModelCacheState.FAILED) {
            this.redoNodeLabel(n, "uc");
        }
        return status.usageByState();
    }

    @PortedFrom(file="Reasoner.h", name="hasDataClash")
    private boolean hasDataClash(DlCompletionTree node) {
        assert (node != null && node.isDataNode());
        DataTypeReasoner datatypeReasoner = new DataTypeReasoner(this.options);
        LinkedHashSet calls = new LinkedHashSet();
        node.simpleConcepts().forEach(r -> {
            boolean positive;
            DagTag d = this.dlHeap.get(r.getConcept()).getType();
            NamedEntry dataEntry = this.dlHeap.get(r.getConcept()).getConcept();
            boolean bl = positive = r.getConcept() > 0;
            if (dataEntry != null) {
                DataCall dc = new DataCall();
                dc.d = d;
                dc.positive = positive;
                dc.dataEntry = dataEntry;
                dc.r = r;
                calls.add(dc);
            }
        });
        for (DataCall dc : calls) {
            if (!datatypeReasoner.addDataEntry(dc.positive, dc.d, dc.dataEntry, dc.r.getDep())) continue;
            this.setClashSet(datatypeReasoner.getClashSet());
            return true;
        }
        boolean checkClash = datatypeReasoner.checkClash();
        if (checkClash) {
            this.setClashSet(datatypeReasoner.getClashSet());
        }
        return checkClash;
    }

    @PortedFrom(file="Reasoner.h", name="runSat")
    protected boolean runSat() {
        this.testTimer.start();
        boolean result = this.checkSatisfiability();
        this.testTimer.stop();
        this.options.getLog().print("\nChecking time was ").print(this.testTimer.getResultTime()).print(" milliseconds");
        this.testTimer.reset();
        this.finaliseStatistic();
        if (result && this.options.getLog().isEnabled()) {
            this.cGraph.print(this.options.getLog());
        }
        return result;
    }

    @PortedFrom(file="Reasoner.h", name="finaliseStatistic")
    private void finaliseStatistic() {
        if (this.options.isUseReasoningStatistics()) {
            this.writeTotalStatistic(this.options.getLog());
        }
        this.cGraph.clearStatistics();
    }

    @PortedFrom(file="Reasoner.h", name="applyReflexiveRoles")
    private boolean applyReflexiveRoles(DlCompletionTree node, DepSet dep) {
        return this.reflexiveRoles.stream().map(r -> this.cGraph.addRoleLabel(node, node, false, (Role)r, dep)).anyMatch(p -> this.setupEdge((DlCompletionTreeArc)p, dep, 0));
    }

    @PortedFrom(file="Reasoner.h", name="checkSatisfiability")
    protected boolean checkSatisfiability() {
        int loop = 0;
        while (true) {
            if (this.curNode == null) {
                if (this.todo.isEmpty()) {
                    if (this.performAfterReasoning() && this.tunedRestore()) {
                        return false;
                    }
                    if (this.todo.isEmpty()) {
                        return true;
                    }
                }
                ToDoEntry curTDE = this.todo.getNextEntry();
                assert (curTDE != null);
                this.curNode = curTDE.getNode();
                this.curConceptConcept = curTDE.getOffsetConcept();
                this.curConceptDepSet = DepSet.create(curTDE.getOffsetDepSet());
            }
            if (++loop == 50) {
                loop = 0;
                if (this.tBox.isCancelled().get()) {
                    return false;
                }
                if (this.testTimer.calcDelta() >= this.options.getTimeOut()) {
                    throw new TimeOutException();
                }
            }
            if (this.commonTactic()) {
                if (!this.tunedRestore()) continue;
                return false;
            }
            this.curNode = null;
        }
    }

    @PortedFrom(file="Reasoner.h", name="performAfterReasoning")
    private boolean performAfterReasoning() {
        this.logIndentation();
        this.options.getLog().print("ub:");
        this.cGraph.retestCGBlockedStatus();
        this.options.getLog().print("]");
        if (!this.todo.isEmpty()) {
            return false;
        }
        if (this.options.isUseFairness() && this.tBox.hasFC()) {
            for (Concept p : this.tBox.getFairness()) {
                DlCompletionTree violator = this.cGraph.getFCViolator(p.getpName());
                if (violator == null) continue;
                this.stats.getnFairnessViolations().inc();
                if (!this.addToDoEntry(violator, p.getpName(), this.getCurDepSet(), "fair")) continue;
                return true;
            }
            if (!this.todo.isEmpty()) {
                return false;
            }
        }
        return false;
    }

    @PortedFrom(file="Reasoner.h", name="restoreBC")
    private void restoreBC() {
        this.curNode = this.bContext.node;
        if (this.bContext.concept == null) {
            this.curConceptConcept = 0;
            this.curConceptDepSet = DepSet.create();
        } else {
            this.curConceptConcept = this.bContext.concept.getConcept();
            this.curConceptDepSet = DepSet.create(this.bContext.concept.getDep());
        }
        if (!this.sessionGCIs.isEmpty()) {
            DlSatTester.resize((TIntList)this.sessionGCIs, this.bContext.sgSize);
        }
        this.nextBranchingOption();
    }

    /*
     * Unable to fully structure code
     */
    private static void resize(TIntList l, int n) {
        block2: {
            if (l.size() <= n) ** GOTO lbl8
            while (l.size() > n) {
                l.remove(l.size() - 1);
            }
            break block2;
lbl-1000:
            // 1 sources

            {
                l.add(null);
lbl8:
                // 2 sources

                ** while (l.size() < n)
            }
        }
    }

    @PortedFrom(file="Reasoner.h", name="save")
    protected void save() {
        this.cGraph.save();
        this.todo.save();
        ++this.tryLevel;
        this.bContext = null;
        this.stats.getnStateSaves().inc();
        this.options.getLog().printTemplateInt(Templates.SAVE, this.getCurLevel() - 1);
        if (this.options.isDebugSaveRestore()) {
            this.cGraph.print(this.options.getLog());
            this.options.getLog().print((Object)this.todo);
        }
    }

    @PortedFrom(file="Reasoner.h", name="restore")
    protected void restore(int newTryLevel) {
        assert (!this.stack.isEmpty());
        assert (newTryLevel > 0);
        this.setCurLevel(newTryLevel);
        this.bContext = (BranchingContext)this.stack.top(this.getCurLevel());
        this.restoreBC();
        this.cGraph.restore(this.getCurLevel());
        this.todo.restore(this.getCurLevel());
        this.stats.getnStateRestores().inc();
        this.options.getLog().printTemplateInt(Templates.RESTORE, this.getCurLevel());
        if (this.options.isDebugSaveRestore()) {
            this.cGraph.print(this.options.getLog());
            this.options.getLog().print((Object)this.todo);
        }
    }

    @PortedFrom(file="Reasoner.h", name="logIndentation")
    private void logIndentation() {
        LogAdapter logAdapter = this.options.getLog();
        logAdapter.print("\n");
        IntStream.range(1, this.getCurLevel()).forEach(i -> {
            LogAdapter logAdapter2 = logAdapter.print(' ');
        });
        logAdapter.print('[');
    }

    @PortedFrom(file="Reasoner.h", name="logStartEntry")
    private void logStartEntry() {
        if (this.options.isLoggingActive()) {
            this.logIndentation();
            LogAdapter logAdapter = this.options.getLog();
            logAdapter.print("(");
            logAdapter.print(this.curNode.logNode());
            logAdapter.print(",");
            logAdapter.print(this.curConceptConcept);
            if (this.curConceptDepSet != null) {
                logAdapter.print((Object)this.curConceptDepSet);
            }
            logAdapter.print("){");
            if (this.curConceptConcept < 0) {
                logAdapter.print("~");
            }
            DLVertex v = this.dlHeap.get(this.curConceptConcept);
            logAdapter.print((Object)v.getType());
            if (v.getConcept() != null) {
                logAdapter.print((Object)"(", (Object)v.getConcept().getIRI(), (Object)")");
            }
            logAdapter.print("}:");
            logAdapter.print("}:");
        }
    }

    @PortedFrom(file="Reasoner.h", name="logFinishEntry")
    private void logFinishEntry(boolean res) {
        if (this.options.isLoggingActive()) {
            this.options.getLog().print("]");
            if (res) {
                this.options.getLog().printTemplate(Templates.LOG_FINISH_ENTRY, this.clashSet);
            }
        }
    }

    @PortedFrom(file="Reasoner.h", name="printReasoningTime")
    public float printReasoningTime(LogAdapter o) {
        o.print((Object)"\n     SAT takes ", (Object)this.satTimer, (Object)" seconds\n     SUB takes ", (Object)this.subTimer, (Object)" seconds");
        return this.satTimer.calcDelta() + this.subTimer.calcDelta();
    }

    @PortedFrom(file="Reasoner.h", name="commonTactic")
    private boolean commonTactic() {
        if (this.curNode.isCached() || this.curNode.isPBlocked()) {
            return false;
        }
        this.logStartEntry();
        boolean ret = false;
        if (!this.isIBlocked()) {
            ret = this.commonTacticBody(this.dlHeap.get(this.curConceptConcept));
        }
        this.logFinishEntry(ret);
        return ret;
    }

    @PortedFrom(file="Reasoner.h", name="commonTacticBody")
    private boolean commonTacticBody(DLVertex cur) {
        this.stats.getnTacticCalls().inc();
        switch (cur.getType()) {
            case TOP: {
                throw new UnreachableSituationException();
            }
            case DATATYPE: 
            case DATAVALUE: {
                this.stats.getnUseless().inc();
                return false;
            }
            case PSINGLETON: 
            case NSINGLETON: {
                if (this.curConceptConcept > 0) {
                    return this.commonTacticBodySingleton(cur);
                }
                return this.commonTacticBodyId(cur);
            }
            case PCONCEPT: 
            case NCONCEPT: {
                return this.commonTacticBodyId(cur);
            }
            case AND: {
                if (this.curConceptConcept > 0) {
                    return this.commonTacticBodyAnd(cur);
                }
                return this.commonTacticBodyOr(cur);
            }
            case FORALL: {
                if (this.curConceptConcept < 0) {
                    return this.commonTacticBodySome(cur);
                }
                return this.commonTacticBodyAll(cur);
            }
            case IRR: {
                if (this.curConceptConcept < 0) {
                    return this.commonTacticBodySomeSelf(cur.getRole());
                }
                return this.commonTacticBodyIrrefl(cur.getRole());
            }
            case LE: {
                if (this.curConceptConcept < 0) {
                    return this.commonTacticBodyGE(cur);
                }
                if (DlSatTester.isFunctionalVertex(cur)) {
                    return this.commonTacticBodyFunc(cur);
                }
                return this.commonTacticBodyLE(cur);
            }
            case PROJ: {
                assert (this.curConceptConcept > 0);
                return this.commonTacticBodyProj(cur.getRole(), cur.getConceptIndex(), cur.getProjRole());
            }
            case CHOOSE: {
                assert (this.curConceptConcept > 0);
                return this.applyChooseRule(this.curNode, cur.getConceptIndex());
            }
        }
        throw new UnreachableSituationException();
    }

    @PortedFrom(file="Reasoner.h", name="commonTacticBodyId")
    private boolean commonTacticBodyId(DLVertex cur) {
        assert (cur.getType().isCNameTag());
        this.stats.getnIdCalls().inc();
        if (this.options.isUseSimpleRules() && this.curConceptConcept > 0 && this.applyExtraRulesIf((Concept)cur.getConcept())) {
            return true;
        }
        int c = this.curConceptConcept > 0 ? cur.getConceptIndex() : -cur.getConceptIndex();
        return this.addToDoEntry(this.curNode, c, this.curConceptDepSet, null);
    }

    @PortedFrom(file="Reasoner.h", name="updateSessionSignature")
    private void updateSessionSignature(@Nullable NamedEntity entity, @Nullable DepSet dep) {
        if (entity != null) {
            this.sessionSignature.add(entity);
            this.sessionSigDepSet.get(entity).add(dep);
        }
    }

    @PortedFrom(file="Reasoner.h", name="updateSessionSignature")
    private void updateSessionSignature() {
        int n = 0;
        DlCompletionTree node = this.cGraph.getNode(n++);
        while (node != null) {
            node = this.cGraph.getNode(n++);
        }
    }

    @PortedFrom(file="Reasoner.h", name="applicable")
    protected boolean applicable(SimpleRule rule) {
        CWDArray lab = this.curNode.label().getLabel(false);
        DepSet loc = null;
        for (Concept p : rule.getBody()) {
            if (p.getpName() == this.curConceptConcept) continue;
            if (this.findConceptClash(lab, p.getpName(), loc == null ? this.curConceptDepSet : loc)) {
                if (loc == null) {
                    loc = DepSet.create(this.clashSet);
                    continue;
                }
                loc.add(this.clashSet);
                continue;
            }
            return false;
        }
        this.setClashSet(loc == null ? this.curConceptDepSet : loc);
        return true;
    }

    @PortedFrom(file="Tactic.cpp", name="applyExtraRules")
    private boolean applyExtraRules(Concept c) {
        FastSet erBegin = c.getExtraRules();
        int i = 0;
        while (i < erBegin.size()) {
            SimpleRule rule = this.tBox.getSimpleRule(erBegin.get(i));
            this.stats.getnSRuleAdd().inc();
            if (this.applicable(rule)) {
                this.stats.getnSRuleFire().inc();
                if (this.addToDoEntry(this.curNode, rule.getBpHead(), this.clashSet, null)) {
                    return true;
                }
            }
            ++i;
        }
        return false;
    }

    @PortedFrom(file="Reasoner.h", name="commonTacticBodySingleton")
    private boolean commonTacticBodySingleton(DLVertex cur) {
        assert (cur.getType() == DagTag.PSINGLETON || cur.getType() == DagTag.NSINGLETON);
        this.stats.getnSingletonCalls().inc();
        assert (this.hasNominals());
        this.encounterNominal = true;
        Individual c = (Individual)cur.getConcept();
        assert (c != null && c.getNode() != null);
        DepSet dep = DepSet.create(this.curConceptDepSet);
        if (c.isNonClassifiable()) {
            return true;
        }
        DlCompletionTree realNode = c.getNode().resolvePBlocker(dep);
        if (!realNode.equals(this.curNode)) {
            return this.merge(this.curNode, realNode, dep);
        }
        return this.commonTacticBodyId(cur);
    }

    @PortedFrom(file="Reasoner.h", name="commonTacticBodyAnd")
    private boolean commonTacticBodyAnd(DLVertex cur) {
        assert (this.curConceptConcept > 0 && cur.getType() == DagTag.AND);
        this.stats.getnAndCalls().inc();
        int[] nArray = cur.begin();
        int n = nArray.length;
        int n2 = 0;
        while (n2 < n) {
            int q = nArray[n2];
            if (this.addToDoEntry(this.curNode, q, this.curConceptDepSet, null)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    @PortedFrom(file="Reasoner.h", name="commonTacticBodyOr")
    private boolean commonTacticBodyOr(DLVertex cur) {
        assert (this.curConceptConcept < 0 && cur.getType() == DagTag.AND);
        this.stats.getnOrCalls().inc();
        if (this.isFirstBranchCall()) {
            Reference<DepSet> dep = new Reference<DepSet>(DepSet.create());
            if (this.planOrProcessing(cur, dep)) {
                this.options.getLog().printTemplate(Templates.COMMON_TACTIC_BODY_OR, this.orConceptsToTest.get(this.orConceptsToTest.size() - 1));
                return false;
            }
            if (this.orConceptsToTest.isEmpty()) {
                this.setClashSet(dep.getReference());
                return true;
            }
            if (this.orConceptsToTest.size() == 1) {
                ConceptWDep c = this.orConceptsToTest.get(0);
                return this.insertToDoEntry(this.curNode, c.getConcept(), dep.getReference(), this.dlHeap.get(c.getConcept()).getType(), "bcp");
            }
            this.createBCOr();
            this.bContext.branchDep = DepSet.create(dep.getReference());
            this.orConceptsToTest = ((BCOr)this.bContext).setApplicableOrEntries(this.orConceptsToTest);
        }
        return this.processOrEntry();
    }

    @PortedFrom(file="Reasoner.h", name="planOrProcessing")
    private boolean planOrProcessing(DLVertex cur, Reference<DepSet> dep) {
        this.orConceptsToTest.clear();
        dep.setReference(DepSet.create(this.curConceptDepSet));
        CGLabel lab = this.curNode.label();
        int[] nArray = cur.begin();
        int n = nArray.length;
        int n2 = 0;
        while (n2 < n) {
            int q = nArray[n2];
            int inverse = -q;
            switch (this.tryAddConcept(lab.getLabel(this.dlHeap.get(inverse).getType().isComplexConcept()), inverse, null)) {
                case CLASH: {
                    dep.getReference().add(this.clashSet);
                    break;
                }
                case EXIST: {
                    this.orConceptsToTest.clear();
                    this.orConceptsToTest.add(new ConceptWDep(-q));
                    return true;
                }
                case DONE: {
                    this.orConceptsToTest.add(new ConceptWDep(-q));
                    break;
                }
                default: {
                    throw new UnreachableSituationException();
                }
            }
            ++n2;
        }
        return false;
    }

    @PortedFrom(file="Reasoner.h", name="processOrEntry")
    private boolean processOrEntry() {
        DepSet dep;
        BCOr bcOr = (BCOr)this.bContext;
        String reason = null;
        if (bcOr.isLastOrEntry()) {
            this.prepareBranchDep();
            dep = this.getBranchDep();
            this.determiniseBranchingOp();
            reason = "bcp";
        } else {
            this.save();
            dep = this.getCurDepSet();
            this.stats.getnOrBrCalls().inc();
        }
        if (this.options.getuseSemanticBranching()) {
            int[] nArray = bcOr.getApplicableOrEntriesConcepts();
            int n = nArray.length;
            int n2 = 0;
            while (n2 < n) {
                int i = nArray[n2];
                if (this.addToDoEntry(this.curNode, -i, dep, "sb")) {
                    return true;
                }
                ++n2;
            }
        }
        if (this.options.isUseDynamicBackjumping()) {
            return this.addToDoEntry(this.curNode, bcOr.orCur().getConcept(), dep, reason);
        }
        return this.insertToDoEntry(this.curNode, bcOr.orCur().getConcept(), dep, this.dlHeap.get(bcOr.orCur().getConcept()).getType(), reason);
    }

    @PortedFrom(file="Reasoner.h", name="commonTacticBodyAllComplex")
    private boolean commonTacticBodyAllComplex(DLVertex cur) {
        int state = cur.getState();
        int c = this.curConceptConcept - state;
        RAStateTransitions rst = cur.getRole().getAutomaton().get(state);
        if (rst.hasEmptyTransition() && rst.stream().anyMatch(q -> this.applyEmptyTransition(c, (RATransition)q))) {
            return true;
        }
        if (rst.hasTopTransition() && rst.stream().anyMatch(q -> q.isTop() && this.addSessionGCI(c + q.finalState(), this.curConceptDepSet))) {
            return true;
        }
        if (state == 1 && this.addToDoEntry(this.curNode, cur.getConceptIndex(), this.curConceptDepSet, null)) {
            return true;
        }
        this.stats.getnAllCalls().inc();
        Stream neighbors = this.curNode.getNeighbour().stream();
        return neighbors.anyMatch(p -> rst.recognise(p.getRole()) && this.applyTransitions((DlCompletionTreeArc)p, rst, c, DepSet.plus(this.curConceptDepSet, p.getDep()), null));
    }

    protected boolean applyEmptyTransition(int c, RATransition q) {
        this.stats.getnAutoEmptyLookups().inc();
        return q.isEmpty() && this.addToDoEntry(this.curNode, c + q.finalState(), this.curConceptDepSet, "e");
    }

    @PortedFrom(file="Tactic.cpp", name="commonTacticBodyAllSimple")
    private boolean commonTacticBodyAllSimple(DLVertex cur) {
        RAStateTransitions rst = cur.getRole().getAutomaton().get(0);
        int c = cur.getConceptIndex();
        this.stats.getnAllCalls().inc();
        Stream neighbors = this.curNode.getNeighbour().stream();
        return neighbors.anyMatch(p -> rst.recognise(p.getRole()) && this.addToDoEntry(p.getArcEnd(), c, DepSet.plus(this.curConceptDepSet, p.getDep()), null));
    }

    @PortedFrom(file="Tactic.cpp", name="applyTransitions")
    private boolean applyTransitions(DlCompletionTreeArc edge, RAStateTransitions rst, int c, DepSet dep, @Nullable String reason) {
        DlCompletionTree node = edge.getArcEnd();
        if (rst.isSingleton()) {
            return this.addToDoEntry(node, c + rst.getTransitionEnd(), dep, reason);
        }
        return rst.stream().anyMatch(q -> this.applyTransitionsCheck(edge, c, dep, reason, node, (RATransition)q));
    }

    protected boolean applyTransitionsCheck(DlCompletionTreeArc edge, int c, DepSet dep, @Nullable String reason, DlCompletionTree node, RATransition q) {
        this.stats.getnAutoTransLookups().inc();
        return q.applicable(edge.getRole()) && this.addToDoEntry(node, c + q.finalState(), dep, reason);
    }

    @PortedFrom(file="Reasoner.h", name="applyUniversalNR")
    private boolean applyUniversalNR(DlCompletionTree node, DlCompletionTreeArc arcSample, DepSet depIn, int flags) {
        if (flags == 0) {
            return false;
        }
        DepSet dep = DepSet.plus(depIn, arcSample.getDep());
        return node.complexConcepts().stream().anyMatch(p -> p.getConcept() > 0 && this.universalNR(node, (ConceptWDep)p, arcSample, dep, flags));
    }

    private boolean universalNR(DlCompletionTree node, ConceptWDep p, DlCompletionTreeArc arcSample, DepSet dep, int flags) {
        DLVertex v = this.dlHeap.get(p.getConcept());
        Role vR = v.getRole();
        switch (v.getType()) {
            case IRR: {
                return Redo.REDOIRR.match(flags) && this.checkIrreflexivity(arcSample, vR, dep);
            }
            case FORALL: {
                if (!Redo.REDOFORALL.match(flags) || vR.isTop()) {
                    return false;
                }
                RAStateTransitions rst = vR.getAutomaton().get(v.getState());
                if (!rst.recognise(arcSample.getRole()) || !(vR.isSimple() ? this.addToDoEntry(arcSample.getArcEnd(), v.getConceptIndex(), DepSet.plus(dep, p.getDep()), "ae") : this.applyTransitions(arcSample, rst, p.getConcept() - v.getState(), DepSet.plus(dep, p.getDep()), "ae"))) break;
                return true;
            }
            case LE: {
                if (DlSatTester.isFunctionalVertex(v)) {
                    if (!Redo.REDOFUNC.match(flags) || !arcSample.getRole().lesserequal(vR)) break;
                    this.addExistingToDoEntry(node, p, "f");
                    break;
                }
                if (!Redo.REDOATMOST.match(flags) || !arcSample.getRole().lesserequal(vR)) break;
                this.addExistingToDoEntry(node, p, "le");
                break;
            }
        }
        return false;
    }

    @PortedFrom(file="Reasoner.h", name="commonTacticBodySome")
    private boolean commonTacticBodySome(DLVertex cur) {
        DLVertex nom;
        Role r = cur.getRole();
        if (r.isTop()) {
            return this.commonTacticBodySomeUniv(cur);
        }
        int c = -cur.getConceptIndex();
        if (this.isSomeExists(r, c)) {
            return false;
        }
        if (c < 0 && this.dlHeap.get(c).getType() == DagTag.AND) {
            int[] nArray = this.dlHeap.get(c).begin();
            int n = nArray.length;
            int n2 = 0;
            while (n2 < n) {
                int q = nArray[n2];
                if (this.isSomeExists(r, -q)) {
                    return false;
                }
                ++n2;
            }
        }
        if (c > 0 && this.tBox.testHasNominals() && ((nom = this.dlHeap.get(c)).getType() == DagTag.PSINGLETON || nom.getType() == DagTag.NSINGLETON)) {
            return this.commonTacticBodyValue(r, (Individual)nom.getConcept());
        }
        this.stats.getnSomeCalls().inc();
        if (r.isFunctional()) {
            List<Role> list = r.beginTopfunc();
            int i = 0;
            while (i < list.size()) {
                int functional = list.get(i).getFunctional();
                AddConceptResult tryAddConcept = this.tryAddConcept(this.curNode.label().getLabel(true), functional, this.curConceptDepSet);
                if (tryAddConcept == AddConceptResult.CLASH) {
                    return true;
                }
                if (tryAddConcept == AddConceptResult.DONE) {
                    this.updateLevel(this.curNode, this.curConceptDepSet);
                    ConceptWDep rFuncRestriction1 = new ConceptWDep(functional, this.curConceptDepSet);
                    this.cGraph.addConceptToNode(this.curNode, rFuncRestriction1, true);
                    this.used.add(rFuncRestriction1.getConcept());
                    this.options.getLog().printTemplate(Templates.COMMON_TACTIC_BODY_SOME, rFuncRestriction1);
                }
                ++i;
            }
        }
        AtomicBoolean rFunc = new AtomicBoolean(false);
        Reference<Role> rf = new Reference<Role>(r);
        Reference<Object> rFuncRestriction = new Reference<Object>(null);
        this.curNode.complexConcepts().stream().forEach(lc -> this.findRC(r, rFunc, rf, (Reference<ConceptWDep>)rFuncRestriction, (ConceptWDep)lc));
        if (!rFunc.get()) {
            return this.createNewEdge(cur.getRole(), c, Redo.redoForallAtmost());
        }
        DlCompletionTreeArc functionalArc = null;
        DepSet newDep = null;
        int i = 0;
        while (i < this.curNode.getNeighbour().size() && functionalArc == null) {
            DlCompletionTreeArc pr = this.curNode.getNeighbour().get(i);
            newDep = pr.neighbourDepSet(rf.getReference());
            if (newDep != null) {
                functionalArc = pr;
            }
            ++i;
        }
        if (functionalArc == null || newDep == null) {
            return this.createNewEdge(cur.getRole(), c, Redo.redoForallAtmost());
        }
        this.options.getLog().printTemplate(Templates.COMMON_TACTIC_BODY_SOME2, rFuncRestriction.getReference());
        DlCompletionTree succ = functionalArc.getArcEnd();
        newDep.add(this.curConceptDepSet);
        if (r.isDisjoint() && this.checkDisjointRoleClash(this.curNode, succ, r, newDep)) {
            return true;
        }
        functionalArc = this.cGraph.addRoleLabel(this.curNode, succ, functionalArc.isPredEdge(), r, newDep);
        if (this.addToDoEntry(succ, c, newDep, null)) {
            return true;
        }
        if (!r.equals(rf.getReference())) {
            if (this.initHeadOfNewEdge(this.curNode, r, newDep, "RD") || this.initHeadOfNewEdge(succ, r.inverse(), newDep, "RR")) {
                return true;
            }
            if (this.applyUniversalNR(this.curNode, functionalArc, newDep, Redo.redoForallFunc())) {
                return true;
            }
            if (this.applyUniversalNR(succ, functionalArc.getReverse(), newDep, Redo.redoForallFuncAtMost())) {
                return true;
            }
        }
        return false;
    }

    protected void findRC(Role r, AtomicBoolean rFunc, Reference<Role> rf, Reference<ConceptWDep> rFuncRestriction, ConceptWDep lc) {
        DLVertex ver = this.dlHeap.get(lc.getConcept());
        if (lc.getConcept() > 0 && DlSatTester.isFunctionalVertex(ver) && r.lesserequal(ver.getRole()) && (!rFunc.get() || rf.getReference().lesserequal(ver.getRole())) && rFunc.compareAndSet(false, true)) {
            rf.setReference(ver.getRole());
            rFuncRestriction.setReference(lc);
        }
    }

    @PortedFrom(file="Reasoner.h", name="commonTacticBodyValue")
    private boolean commonTacticBodyValue(Role r, Individual nom) {
        DepSet dep = DepSet.create(this.curConceptDepSet);
        if (this.isCurNodeBlocked()) {
            return false;
        }
        this.stats.getnSomeCalls().inc();
        assert (nom.getNode() != null);
        DlCompletionTree realNode = nom.getNode().resolvePBlocker(dep);
        if (r.isDisjoint() && this.checkDisjointRoleClash(this.curNode, realNode, r, dep)) {
            return true;
        }
        this.encounterNominal = true;
        DlCompletionTreeArc edge = this.cGraph.addRoleLabel(this.curNode, realNode, false, r, dep);
        return this.setupEdge(edge, dep, Redo.redoForallFuncAtmostIrr());
    }

    @PortedFrom(file="Reasoner.h", name="commonTacticBodySomeUniv")
    private boolean commonTacticBodySomeUniv(DLVertex cur) {
        DlCompletionTree node;
        if (this.isCurNodeBlocked()) {
            return false;
        }
        this.stats.getnSomeCalls().inc();
        int c = -cur.getConceptIndex();
        int i = 0;
        while ((node = this.cGraph.getNode(i++)) != null) {
            if (!DlSatTester.isObjectNodeUnblocked(node) || !node.label().contains(c)) continue;
            return false;
        }
        node = this.cGraph.getNewNode();
        return this.initNewNode(node, this.curConceptDepSet, c);
    }

    @PortedFrom(file="Reasoner.h", name="createNewEdge")
    private boolean createNewEdge(Role r, int c, int flags) {
        if (this.isCurNodeBlocked()) {
            this.stats.getnUseless().inc();
            return false;
        }
        DlCompletionTreeArc pA = this.createOneNeighbour(r, this.curConceptDepSet);
        return this.initNewNode(pA.getArcEnd(), this.curConceptDepSet, c) || this.setupEdge(pA, this.curConceptDepSet, flags);
    }

    @PortedFrom(file="Reasoner.h", name="createOneNeighbour")
    private DlCompletionTreeArc createOneNeighbour(Role r, DepSet dep) {
        return this.createOneNeighbour(r, dep, Integer.MAX_VALUE);
    }

    @PortedFrom(file="Reasoner.h", name="createOneNeighbour")
    private DlCompletionTreeArc createOneNeighbour(Role r, DepSet dep, int level) {
        boolean forNN = level != Integer.MAX_VALUE;
        DlCompletionTreeArc pA = this.cGraph.createNeighbour(this.curNode, forNN, r, dep);
        DlCompletionTree node = pA.getArcEnd();
        if (forNN) {
            node.setNominalLevel(level);
        }
        if (r.isDataRole()) {
            node.setDataNode();
        }
        this.options.getLog().printTemplateMixInt(r.isDataRole() ? Templates.DN : Templates.CN, dep, node.getId());
        return pA;
    }

    @PortedFrom(file="Reasoner.h", name="isCurNodeBlocked")
    private boolean isCurNodeBlocked() {
        if (!this.options.getuseLazyBlocking()) {
            return this.curNode.isBlocked();
        }
        if (!this.curNode.isBlocked() && this.curNode.isAffected()) {
            this.updateLevel(this.curNode, this.curConceptDepSet);
            this.cGraph.detectBlockedStatus(this.curNode);
        }
        return this.curNode.isBlocked();
    }

    @PortedFrom(file="Reasoner.h", name="applyAllGeneratingRules")
    private void applyAllGeneratingRules(DlCompletionTree node) {
        node.label().getComplexConcepts().stream().filter(p -> p.getConcept() <= 0).forEach(p -> this.addLEForAll(node, (ConceptWDep)p));
    }

    private void addLEForAll(DlCompletionTree node, ConceptWDep p) {
        DLVertex v = this.dlHeap.get(p.getConcept());
        if (v.getType() == DagTag.LE || v.getType() == DagTag.FORALL) {
            this.addExistingToDoEntry(node, p, "ubd");
        }
    }

    @PortedFrom(file="Reasoner.h", name="setupEdge")
    public boolean setupEdge(DlCompletionTreeArc pA, DepSet dep, int flags) {
        DlCompletionTree child = pA.getArcEnd();
        DlCompletionTree from = pA.getReverse().getArcEnd();
        if (this.initHeadOfNewEdge(from, pA.getRole(), dep, "RD")) {
            return true;
        }
        if (this.initHeadOfNewEdge(child, pA.getReverse().getRole(), dep, "RR")) {
            return true;
        }
        if (this.applyUniversalNR(from, pA, dep, flags)) {
            return true;
        }
        if (pA.isPredEdge() || child.isNominalNode() || child.equals(from)) {
            if (this.applyUniversalNR(child, pA.getReverse(), dep, flags)) {
                return true;
            }
        } else if (child.isDataNode()) {
            this.checkDataNode = true;
            if (this.hasDataClash(child)) {
                return true;
            }
        } else if (this.tryCacheNode(child).usageByState()) {
            return true;
        }
        return false;
    }

    @PortedFrom(file="Reasoner.h", name="initHeadOfNewEdge")
    private boolean initHeadOfNewEdge(DlCompletionTree node, Role r, DepSet dep, String reason) {
        Stream s;
        if (r.isFunctional() && (s = r.beginTopfunc().stream()).anyMatch(p -> this.addToDoEntry(node, p.getFunctional(), dep, "fr"))) {
            return true;
        }
        if (this.addToDoEntry(node, r.getBPDomain(), dep, reason)) {
            return true;
        }
        return !this.options.isUpdaterndFromSuperRoles() && (s = r.getAncestor().stream()).anyMatch(q -> this.addToDoEntry(node, q.getBPDomain(), dep, reason));
    }

    @PortedFrom(file="Reasoner.h", name="commonTacticBodyFunc")
    private boolean commonTacticBodyFunc(DLVertex cur) {
        assert (this.curConceptConcept > 0 && DlSatTester.isFunctionalVertex(cur));
        if (cur.getRole().isTop()) {
            return this.processTopRoleFunc(cur);
        }
        if (this.isNNApplicable(cur.getRole(), 1, this.curConceptConcept + 1)) {
            return this.commonTacticBodyNN(cur);
        }
        this.stats.getnFuncCalls().inc();
        if (this.isQuickClashLE(cur)) {
            return true;
        }
        this.findNeighbours(cur.getRole(), 1, null);
        if (this.edgesToMerge.size() < 2) {
            return false;
        }
        DlCompletionTreeArc q = this.edgesToMerge.get(0);
        DlCompletionTree sample = q.getArcEnd();
        DepSet depF = DepSet.create(this.curConceptDepSet);
        depF.add(q.getDep());
        int i = 1;
        while (i < this.edgesToMerge.size()) {
            q = this.edgesToMerge.get(i);
            if (!q.getArcEnd().isPBlocked() && this.merge(q.getArcEnd(), sample, DepSet.plus(depF, q.getDep()))) {
                return true;
            }
            ++i;
        }
        return false;
    }

    @PortedFrom(file="Reasoner.h", name="commonTacticBodyLE")
    private boolean commonTacticBodyLE(DLVertex cur) {
        assert (this.curConceptConcept > 0 && cur.getType() == DagTag.LE);
        this.stats.getnLeCalls().inc();
        Role r = cur.getRole();
        if (r.isTop()) {
            return this.processTopRoleLE(cur);
        }
        int c = cur.getConceptIndex();
        boolean needInit = true;
        if (!this.isFirstBranchCall()) {
            if (this.bContext instanceof BCNN) {
                return this.commonTacticBodyNN(cur);
            }
            if (this.bContext instanceof BCLE) {
                needInit = false;
            } else assert (this.bContext instanceof BCChoose);
        } else if (this.isQuickClashLE(cur)) {
            return true;
        }
        if (needInit) {
            if (c != 1 && this.commonTacticBodyChoose(r, c)) {
                return true;
            }
            if (this.isNNApplicable(r, c, this.curConceptConcept + cur.getNumberLE())) {
                return this.commonTacticBodyNN(cur);
            }
        }
        while (true) {
            Reference<DepSet> dep;
            DlCompletionTree to;
            if (this.isFirstBranchCall() && this.initLEProcessing(cur)) {
                return false;
            }
            BCLE bcLE = (BCLE)this.bContext;
            if (bcLE.noMoreLEOptions()) {
                this.useBranchDep();
                return true;
            }
            DlCompletionTreeArc fromArc = (DlCompletionTreeArc)bcLE.getFrom();
            DlCompletionTreeArc toArc = (DlCompletionTreeArc)bcLE.getTo();
            DlCompletionTree from = fromArc.getArcEnd();
            if (this.cGraph.nonMergable(from, to = toArc.getArcEnd(), dep = new Reference<DepSet>(DepSet.create()))) {
                dep.getReference().add(fromArc.getDep());
                dep.getReference().add(toArc.getDep());
                if (c == 1) {
                    this.setClashSet(dep.getReference());
                } else {
                    DagTag tag = this.dlHeap.get(c).getType();
                    boolean test = this.findConceptClash(from.label().getLabel(tag.isComplexConcept()), c, dep.getReference());
                    assert (test);
                    dep.getReference().add(this.clashSet);
                    test = this.findConceptClash(to.label().getLabel(tag.isComplexConcept()), c, dep.getReference());
                    assert (test);
                }
                this.nextBranchingOption();
                assert (!this.isFirstBranchCall());
                continue;
            }
            this.save();
            DepSet curDep = DepSet.create(this.getCurDepSet());
            curDep.add(fromArc.getDep());
            if (this.merge(from, to, curDep)) {
                return true;
            }
            if (c != 1 && this.commonTacticBodyChoose(r, c)) break;
        }
        return true;
    }

    @PortedFrom(file="Reasoner.h", name="initLEProcessing")
    private boolean initLEProcessing(DLVertex cur) {
        DepSet dep = DepSet.create();
        this.findNeighbours(cur.getRole(), cur.getConceptIndex(), dep);
        if (this.edgesToMerge.size() <= cur.getNumberLE()) {
            return true;
        }
        this.createBCLE();
        this.bContext.branchDep.add(dep);
        BCLE bcLE = (BCLE)this.bContext;
        this.edgesToMerge = bcLE.swap(this.edgesToMerge);
        bcLE.resetMCI();
        return false;
    }

    @PortedFrom(file="Reasoner.h", name="commonTacticBodyGE")
    private boolean commonTacticBodyGE(DLVertex cur) {
        assert (this.curConceptConcept < 0 && cur.getType() == DagTag.LE);
        if (this.isCurNodeBlocked()) {
            return false;
        }
        Role r = cur.getRole();
        if (r.isTop()) {
            return this.processTopRoleGE(cur);
        }
        this.stats.getnGeCalls().inc();
        if (this.isQuickClashGE(cur)) {
            return true;
        }
        return this.createDifferentNeighbours(cur.getRole(), cur.getConceptIndex(), this.curConceptDepSet, cur.getNumberGE(), Integer.MAX_VALUE);
    }

    @PortedFrom(file="Reasoner.h", name="processTopRoleFunc")
    private boolean processTopRoleFunc(DLVertex cur) {
        assert (this.curConceptConcept > 0 && DlSatTester.isFunctionalVertex(cur));
        this.stats.getnFuncCalls().inc();
        if (this.isQuickClashLE(cur)) {
            return true;
        }
        this.findCLabelledNodes(1, null);
        if (this.nodesToMerge.size() < 2) {
            return false;
        }
        DlCompletionTree sample = this.nodesToMerge.get(0);
        DepSet dep = DepSet.create(this.curConceptDepSet);
        return this.nodesToMerge.stream().skip(1L).anyMatch(p -> !p.isPBlocked() && this.merge((DlCompletionTree)p, sample, dep));
    }

    @PortedFrom(file="Reasoner.h", name="processTopRoleLE")
    private boolean processTopRoleLE(DLVertex cur) {
        assert (this.curConceptConcept > 0 && cur.getType() == DagTag.LE);
        int c = cur.getConceptIndex();
        boolean needInit = true;
        if (!this.isFirstBranchCall()) {
            if (this.bContext instanceof BCLE) {
                needInit = false;
            } else assert (this.bContext instanceof BCChoose);
        } else if (this.isQuickClashLE(cur)) {
            return true;
        }
        if (needInit && c != 1 && this.applyChooseRuleGlobally(c)) {
            return true;
        }
        while (true) {
            Reference<DepSet> dep;
            DlCompletionTree to;
            if (this.isFirstBranchCall() && this.initTopLEProcessing(cur)) {
                return false;
            }
            BCLE bcLE = (BCLE)this.bContext;
            if (bcLE.noMoreLEOptions()) {
                this.useBranchDep();
                return true;
            }
            DlCompletionTree from = (DlCompletionTree)bcLE.getFrom();
            if (this.cGraph.nonMergable(from, to = (DlCompletionTree)bcLE.getTo(), dep = new Reference<DepSet>(DepSet.create()))) {
                if (c == 1) {
                    this.setClashSet(dep.getReference());
                } else {
                    DagTag tag = this.dlHeap.get(c).getType();
                    boolean test = this.findConceptClash(from.label().getLabel(tag.isComplexConcept()), c, dep.getReference());
                    assert (test);
                    dep.getReference().add(this.clashSet);
                    test = this.findConceptClash(to.label().getLabel(tag.isComplexConcept()), c, dep.getReference());
                    assert (test);
                }
                this.nextBranchingOption();
                assert (!this.isFirstBranchCall());
                continue;
            }
            this.save();
            DepSet curDep = DepSet.create(this.getCurDepSet());
            if (this.merge(from, to, curDep)) break;
        }
        return true;
    }

    @PortedFrom(file="Reasoner.h", name="processTopRoleGE")
    private boolean processTopRoleGE(DLVertex cur) {
        assert (this.curConceptConcept < 0 && cur.getType() == DagTag.LE);
        assert (!this.isCurNodeBlocked());
        this.stats.getnGeCalls().inc();
        if (this.isQuickClashGE(cur)) {
            return true;
        }
        return this.createDifferentNeighbours(cur.getRole(), cur.getConceptIndex(), this.curConceptDepSet, cur.getNumberGE(), Integer.MAX_VALUE);
    }

    @PortedFrom(file="Reasoner.h", name="initTopLEProcessing")
    private boolean initTopLEProcessing(DLVertex cur) {
        DepSet dep = DepSet.create();
        this.findCLabelledNodes(cur.getConceptIndex(), dep);
        if (this.nodesToMerge.size() <= cur.getNumberLE()) {
            return true;
        }
        this.createBCTopLE();
        this.bContext.branchDep.add(dep);
        BCLE bcLE = (BCLE)this.bContext;
        this.nodesToMerge = bcLE.swap(this.nodesToMerge);
        bcLE.resetMCI();
        return false;
    }

    @PortedFrom(file="Reasoner.h", name="createDifferentNeighbours")
    private boolean createDifferentNeighbours(Role r, int c, DepSet dep, int n, int level) {
        DlCompletionTreeArc pA = null;
        this.cGraph.initIR();
        int i = 0;
        while (i < n) {
            pA = this.createOneNeighbour(r, dep, level);
            DlCompletionTree child = pA.getArcEnd();
            this.cGraph.setCurIR(child, dep);
            if (this.initNewNode(child, dep, c)) {
                return true;
            }
            if (this.setupEdge(pA, dep, Redo.REDOFORALL.getValue())) {
                return true;
            }
            ++i;
        }
        this.cGraph.finiIR();
        return this.applyUniversalNR(this.curNode, pA, dep, Redo.redoFuncAtMost());
    }

    @PortedFrom(file="Reasoner.h", name="isNRClash")
    private boolean isNRClash(DLVertex atleast, DLVertex atmost, ConceptWDep reason) {
        if (atmost.getType() != DagTag.LE || atleast.getType() != DagTag.LE) {
            return false;
        }
        if (!DlSatTester.checkNRclash(atleast, atmost)) {
            return false;
        }
        this.setClashSet(DepSet.plus(this.curConceptDepSet, reason.getDep()));
        this.logNCEntry(this.curNode, reason.getConcept(), reason.getDep(), "x", this.dlHeap.get(reason.getConcept()).getType().getName());
        return true;
    }

    private boolean usedInverseAndClash(DagTag dt, ConceptWDep p, CGLabel to) {
        return this.used.contains(-p.getConcept()) && this.findConceptClash(to.getLabel(false), -p.getConcept(), p.getDep());
    }

    @PortedFrom(file="Reasoner.h", name="checkMergeClash")
    private boolean checkMergeClash(CGLabel from, CGLabel to, DepSet dep, int nodeId) {
        DepSet clashDep = DepSet.create(dep);
        Optional<ConceptWDep> clashConcept = from.getSimpleConcepts().stream().filter(p -> this.usedInverseAndClash(DagTag.PCONCEPT, (ConceptWDep)p, to)).findAny();
        boolean clash = false;
        if (clashConcept.isPresent()) {
            clashDep.add(this.clashSet);
            this.options.getLog().printTemplateMixInt(Templates.CHECK_MERGE_CLASH, clashDep, nodeId, clashConcept.get().getConcept());
            clash = true;
        }
        if ((clashConcept = from.getComplexConcepts().stream().filter(p -> this.usedInverseAndClash(DagTag.FORALL, (ConceptWDep)p, to)).findAny()).isPresent()) {
            clashDep.add(this.clashSet);
            this.options.getLog().printTemplateMixInt(Templates.CHECK_MERGE_CLASH, clashDep, nodeId, clashConcept.get().getConcept());
            clash = true;
        }
        if (clash) {
            this.setClashSet(clashDep);
        }
        return clash;
    }

    @PortedFrom(file="Reasoner.h", name="mergeLabels")
    private boolean mergeLabels(CGLabel from, DlCompletionTree to, DepSet dep) {
        if (!dep.isEmpty()) {
            this.cGraph.saveRareCond(to.label().getLabel(false).updateDepSet(dep));
            this.cGraph.saveRareCond(to.label().getLabel(true).updateDepSet(dep));
        }
        return from.getSimpleConcepts().stream().anyMatch(p -> this.checkIndexAndSaveOrAddEntry((ConceptWDep)p, false, to, dep)) || from.getComplexConcepts().stream().anyMatch(p -> this.checkIndexAndSaveOrAddEntry((ConceptWDep)p, true, to, dep));
    }

    private boolean checkIndexAndSaveOrAddEntry(ConceptWDep p, boolean dt, DlCompletionTree to, DepSet dep) {
        int bp = p.getConcept();
        this.stats.getnLookups().inc();
        int index = to.label().getLabel(dt).index(bp);
        if (index > -1) {
            if (!p.getDep().isEmpty()) {
                this.cGraph.saveRareCond(to.label().getLabel(dt).updateDepSet(index, p.getDep()));
            }
        } else if (this.insertToDoEntry(to, bp, DepSet.plus(dep, p.getDep()), this.dlHeap.get(bp).getType(), "M")) {
            return true;
        }
        return false;
    }

    @PortedFrom(file="Tactic.cpp", name="Merge")
    private boolean merge(DlCompletionTree from, DlCompletionTree to, DepSet depF) {
        assert (!from.isPBlocked());
        assert (!from.equals(to));
        assert (to.getNominalLevel() <= from.getNominalLevel());
        this.options.getLog().printTemplateInt(Templates.MERGE, from.getId(), to.getId());
        this.stats.getnMergeCalls().inc();
        DepSet dep = DepSet.create(depF);
        Reference<DepSet> ref = new Reference<DepSet>(dep);
        if (this.cGraph.nonMergable(from, to, ref)) {
            this.setClashSet(ref.getReference());
            return true;
        }
        if (this.checkMergeClash(from.label(), to.label(), depF, to.getId())) {
            return true;
        }
        if (this.mergeLabels(from.label(), to, depF)) {
            return true;
        }
        ArrayList<DlCompletionTreeArc> edges = new ArrayList<DlCompletionTreeArc>();
        this.cGraph.merge(from, to, depF, edges);
        if (edges.stream().anyMatch(q -> q.getRole().isDisjoint() && this.checkDisjointRoleClash(q.getReverse().getArcEnd(), q.getArcEnd(), q.getRole(), depF))) {
            return true;
        }
        if (to.isDataNode()) {
            return this.hasDataClash(to);
        }
        return edges.stream().anyMatch(q -> this.applyUniversalNR(to, (DlCompletionTreeArc)q, depF, Redo.redoForallFuncAtmostIrr()));
    }

    @PortedFrom(file="Reasoner.h", name="checkDisjointRoleClash")
    protected boolean checkDisjointRoleClash(DlCompletionTree from, DlCompletionTree to, Role r, DepSet dep) {
        return from.getNeighbour().stream().anyMatch(p -> this.checkDisjointRoleClash((DlCompletionTreeArc)p, to, r, dep));
    }

    @PortedFrom(file="Tactic.cpp", name="isNewEdge")
    private static boolean isNewEdge(DlCompletionTree node, List<DlCompletionTreeArc> e) {
        return e.stream().noneMatch(p -> p.getArcEnd().equals(node));
    }

    @PortedFrom(file="Reasoner.h", name="findNeighbours")
    private void findNeighbours(Role role, int c, @Nullable DepSet dep) {
        this.edgesToMerge.clear();
        DagTag tag = this.dlHeap.get(c).getType();
        this.curNode.getNeighbour().stream().filter(p -> p.isNeighbour(role) && DlSatTester.isNewEdge(p.getArcEnd(), this.edgesToMerge) && this.findChooseRuleConcept(p.getArcEnd().label().getLabel(tag.isComplexConcept()), c, dep)).forEach(this.edgesToMerge::add);
        Collections.sort(this.edgesToMerge, new EdgeCompare());
    }

    @PortedFrom(file="Reasoner.h", name="commonTacticBodyChoose")
    private boolean commonTacticBodyChoose(Role r, int c) {
        return this.curNode.getNeighbour().stream().anyMatch(p -> p.isNeighbour(r) && this.applyChooseRule(p.getArcEnd(), c));
    }

    @PortedFrom(file="Reasoner.h", name="applyChooseRule")
    private boolean applyChooseRule(DlCompletionTree node, int c) {
        if (node.isLabelledBy(c) || node.isLabelledBy(-c)) {
            return false;
        }
        if (this.isFirstBranchCall()) {
            this.createBCCh();
            this.save();
            return this.addToDoEntry(node, -c, this.getCurDepSet(), "cr0");
        }
        this.prepareBranchDep();
        DepSet dep = DepSet.create(this.getBranchDep());
        this.determiniseBranchingOp();
        return this.addToDoEntry(node, c, dep, "cr1");
    }

    @PortedFrom(file="Reasoner.h", name="commonTacticBodyNN")
    private boolean commonTacticBodyNN(DLVertex cur) {
        BCNN bcNN;
        this.stats.getnNNCalls().inc();
        if (this.isFirstBranchCall()) {
            this.createBCNN();
        }
        if ((bcNN = (BCNN)this.bContext).noMoreNNOptions(cur.getNumberLE())) {
            this.useBranchDep();
            return true;
        }
        int nn = bcNN.getBranchIndex();
        this.save();
        DepSet curDep = this.getCurDepSet();
        if (this.addToDoEntry(this.curNode, this.curConceptConcept + cur.getNumberLE(), DepSet.create(), "NNs")) {
            return true;
        }
        if (this.createDifferentNeighbours(cur.getRole(), cur.getConceptIndex(), curDep, nn, this.curNode.getNominalLevel() + 1)) {
            return true;
        }
        return this.addToDoEntry(this.curNode, this.curConceptConcept + cur.getNumberLE() - nn, curDep, "NN");
    }

    @PortedFrom(file="Reasoner.h", name="isNNApplicable")
    protected boolean isNNApplicable(Role r, int c, int stopper) {
        if (!this.curNode.isNominalNode()) {
            return false;
        }
        if (this.used.contains(stopper) && this.curNode.isLabelledBy(stopper)) {
            return false;
        }
        return this.curNode.getNeighbour().stream().filter(p -> p.isPredEdge() && p.getArcEnd().isBlockableNode() && p.isNeighbour(r) && p.getArcEnd().isLabelledBy(c)).peek(p -> {
            LogAdapter logAdapter = this.options.getLog().print(" NN(").print(p.getArcEnd().getId()).print(")");
        }).findAny().isPresent();
    }

    @PortedFrom(file="Reasoner.h", name="commonTacticBodySomeSelf")
    private boolean commonTacticBodySomeSelf(Role r) {
        if (this.isCurNodeBlocked()) {
            return false;
        }
        if (this.curNode.getNeighbour().stream().anyMatch(p -> p.getArcEnd().equals(this.curNode) && p.isNeighbour(r))) {
            return false;
        }
        DepSet dep = DepSet.create(this.curConceptDepSet);
        DlCompletionTreeArc pA = this.cGraph.createLoop(this.curNode, r, dep);
        return this.setupEdge(pA, dep, Redo.redoForallFuncAtmostIrr());
    }

    @PortedFrom(file="Reasoner.h", name="commonTacticBodyIrrefl")
    private boolean commonTacticBodyIrrefl(Role r) {
        return this.curNode.getNeighbour().stream().anyMatch(p -> this.checkIrreflexivity((DlCompletionTreeArc)p, r, this.curConceptDepSet));
    }

    @PortedFrom(file="Reasoner.h", name="commonTacticBodyProj")
    private boolean commonTacticBodyProj(Role r, int c, Role projR) {
        if (this.curNode.isLabelledBy(-c)) {
            return false;
        }
        return this.curNode.getNeighbour().stream().anyMatch(p -> p.isNeighbour(r) && this.checkProjection((DlCompletionTreeArc)p, c, projR));
    }

    @PortedFrom(file="Reasoner.h", name="checkProjection")
    private boolean checkProjection(DlCompletionTreeArc pA, int c, Role projR) {
        if (pA.isNeighbour(projR)) {
            return false;
        }
        if (this.curNode.isLabelledBy(-c)) {
            return false;
        }
        DepSet dep = DepSet.create(this.curConceptDepSet);
        dep.add(pA.getDep());
        if (!this.curNode.isLabelledBy(c)) {
            if (this.isFirstBranchCall()) {
                this.createBCCh();
                this.save();
                return this.addToDoEntry(this.curNode, -c, this.getCurDepSet(), "cr0");
            }
            this.prepareBranchDep();
            dep.add(this.getBranchDep());
            this.determiniseBranchingOp();
            if (this.addToDoEntry(this.curNode, c, dep, "cr1")) {
                return true;
            }
        }
        DlCompletionTree child = pA.getArcEnd();
        return this.setupEdge(this.cGraph.addRoleLabel(this.curNode, child, pA.isPredEdge(), projR, dep), dep, Redo.redoForallFuncAtmostIrr());
    }

    @PortedFrom(file="Reasoner.h", name="createBCTopLE")
    public void createBCTopLE() {
        this.bContext = this.stack.pushTopLE();
        this.initBC(this.bContext);
    }

    @PortedFrom(file="Reasoner.h", name="applyChooseRuleGlobally")
    private boolean applyChooseRuleGlobally(int c) {
        return this.cGraph.nodes().anyMatch(p -> DlSatTester.isObjectNodeUnblocked(p) && this.applyChooseRule((DlCompletionTree)p, c));
    }

    @PortedFrom(file="Reasoner.h", name="findCLabelledNodes")
    private void findCLabelledNodes(int c, @Nullable DepSet dep) {
        this.nodesToMerge.clear();
        DagTag tag = this.dlHeap.get(c).getType();
        int i = 0;
        DlCompletionTree arc = this.cGraph.getNode(i++);
        while (arc != null) {
            if (DlSatTester.isNodeGloballyUsed(arc) && this.findChooseRuleConcept(arc.label().getLabel(tag.isComplexConcept()), c, dep)) {
                this.nodesToMerge.add(arc);
            }
            arc = this.cGraph.getNode(i++);
        }
        Collections.sort(this.nodesToMerge, nodeCompare);
    }

    class BCBarrier
    extends BranchingContext {
        BCBarrier() {
        }
    }

    class BCChoose
    extends BranchingContext {
        BCChoose() {
        }
    }

    class BCLE<I>
    extends BranchingContext {
        private int branchIndex;
        private int mergeCandIndex;
        private List<I> edges;

        BCLE() {
            this.edges = new ArrayList<I>();
        }

        @Override
        public void init() {
            this.branchIndex = 0;
            this.mergeCandIndex = 0;
        }

        public List<I> swap(List<I> values) {
            List<I> temp = this.edges;
            this.edges = values;
            return temp;
        }

        protected void resetMCI() {
            this.mergeCandIndex = this.edges.size() - 1;
        }

        @Override
        public void nextOption() {
            --this.mergeCandIndex;
            if (this.mergeCandIndex == this.branchIndex) {
                ++this.branchIndex;
                this.resetMCI();
            }
        }

        protected I getFrom() {
            return this.edges.get(this.mergeCandIndex);
        }

        protected I getTo() {
            return this.edges.get(this.branchIndex);
        }

        protected boolean noMoreLEOptions() {
            return this.mergeCandIndex <= this.branchIndex;
        }

        protected List<I> getEdgesToMerge() {
            return this.edges;
        }

        protected void setEdgesToMerge(List<I> edgesToMerge) {
            this.edges = edgesToMerge;
        }
    }

    class BCNN
    extends BranchingContext {
        private int branchIndex;

        BCNN() {
        }

        @Override
        public void init() {
            this.branchIndex = 1;
        }

        @Override
        public void nextOption() {
            ++this.branchIndex;
        }

        protected boolean noMoreNNOptions(int n) {
            return this.branchIndex > n;
        }

        protected int getBranchIndex() {
            return this.branchIndex;
        }

        public void setBranchIndex(int branchIndex) {
            this.branchIndex = branchIndex;
        }
    }

    class BCOr
    extends BranchingContext {
        private int branchIndex;
        private int size;
        private List<ConceptWDep> applicableOrEntries;

        BCOr() {
            this.size = 0;
            this.applicableOrEntries = new ArrayList<ConceptWDep>();
        }

        @Override
        public void init() {
            this.branchIndex = 0;
        }

        @Override
        public void nextOption() {
            ++this.branchIndex;
        }

        protected boolean isLastOrEntry() {
            return this.size == this.branchIndex + 1;
        }

        protected ConceptWDep orCur() {
            return this.applicableOrEntries.get(this.branchIndex);
        }

        protected int getBranchIndex() {
            return this.branchIndex;
        }

        protected int[] getApplicableOrEntriesConcepts() {
            int[] toReturn = new int[this.branchIndex];
            int i = 0;
            while (i < toReturn.length) {
                toReturn[i] = this.applicableOrEntries.get(i).getConcept();
                ++i;
            }
            return toReturn;
        }

        protected List<ConceptWDep> setApplicableOrEntries(List<ConceptWDep> list) {
            List<ConceptWDep> toReturn = this.applicableOrEntries;
            this.applicableOrEntries = list;
            this.size = this.applicableOrEntries.size();
            return toReturn;
        }

        @Override
        public String toString() {
            StringBuilder o = new StringBuilder();
            o.append("BCOR ");
            o.append(this.branchIndex);
            o.append(" dep ");
            o.append(this.branchDep);
            o.append(" curconcept ");
            o.append(this.concept == null ? new ConceptWDep(0) : this.concept);
            o.append(" curnode ");
            o.append(this.node);
            o.append(" orentries [");
            o.append(this.applicableOrEntries);
            o.append(']');
            return o.toString();
        }
    }

    class BCStack
    extends SaveStack<BranchingContext> {
        private final BCBarrier bcBarrier;

        protected BCStack() {
            this.bcBarrier = new BCBarrier();
        }

        @Override
        public void push(BranchingContext p) {
            p.init();
            DlSatTester.this.initBC(p);
            super.push(p);
        }

        protected BranchingContext pushOr() {
            BCOr o = new BCOr();
            this.push(o);
            return o;
        }

        protected BranchingContext pushNN() {
            BCNN n = new BCNN();
            this.push(n);
            return n;
        }

        protected BCLE<DlCompletionTreeArc> pushLE() {
            BCLE<DlCompletionTreeArc> e = new BCLE<DlCompletionTreeArc>();
            this.push(e);
            return e;
        }

        protected BCLE<DlCompletionTree> pushTopLE() {
            BCLE<DlCompletionTree> e = new BCLE<DlCompletionTree>();
            this.push(e);
            return e;
        }

        protected BCChoose pushCh() {
            BCChoose c = new BCChoose();
            this.push(c);
            return c;
        }

        protected BCBarrier pushBarrier() {
            this.push(this.bcBarrier);
            return this.bcBarrier;
        }
    }

    class BranchingContext
    implements Serializable {
        protected DlCompletionTree node = null;
        protected ConceptWDep concept = null;
        protected DepSet branchDep = DepSet.create();
        protected int sgSize;

        public void init() {
        }

        public void nextOption() {
        }

        public String toString() {
            return String.valueOf(this.getClass().getSimpleName()) + " dep '" + this.branchDep + "' curconcept '" + (this.concept == null ? new ConceptWDep(0) : this.concept) + "' curnode '" + this.node + '\'';
        }
    }

    static class DataCall {
        DagTag d;
        NamedEntry dataEntry;
        boolean positive;
        ConceptWDep r;

        DataCall() {
        }

        public int hashCode() {
            return ((this.positive ? 1 : 2) * 37 + this.d.hashCode()) * 37 + this.dataEntry.hashCode();
        }

        public boolean equals(@Nullable Object obj) {
            if (obj == null) {
                return false;
            }
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataCall)) {
                return false;
            }
            DataCall o = (DataCall)obj;
            return this.positive == o.positive && this.d.equals((Object)o.d) && this.dataEntry.equals(o.dataEntry);
        }

        public String toString() {
            HasIRI o = this.dataEntry instanceof DatatypeEntry ? ((DatatypeEntry)this.dataEntry).getDatatype() : (this.dataEntry instanceof LiteralEntry ? ((LiteralEntry)this.dataEntry).getLiteral() : this.dataEntry);
            return String.valueOf(this.positive) + ", " + (Object)((Object)this.d) + ", \"" + o.toString().replace("\"", "\\\"") + "\", " + this.r.getDep().toString().replace("{", "").replace("}", "");
        }
    }
}

