/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.jfact.kernel;

import conformance.PortedFrom;
import java.io.Serializable;
import javax.annotation.Nullable;
import uk.ac.manchester.cs.jfact.dep.DepSet;
import uk.ac.manchester.cs.jfact.helpers.LogAdapter;
import uk.ac.manchester.cs.jfact.helpers.Templates;
import uk.ac.manchester.cs.jfact.kernel.DlCompletionTree;
import uk.ac.manchester.cs.jfact.kernel.Restorer;
import uk.ac.manchester.cs.jfact.kernel.Role;

@PortedFrom(file="dlCompletionTreeArc.h", name="DlCompletionTreeArc")
public class DlCompletionTreeArc
implements Serializable {
    private final DlCompletionTree node;
    protected Role role;
    protected DepSet depSet;
    protected DlCompletionTreeArc reverse;
    private boolean succEdge = true;

    public DlCompletionTreeArc(Role r, DepSet dep, DlCompletionTree n) {
        this.role = r;
        this.depSet = DepSet.create(dep);
        this.node = n;
        this.reverse = null;
    }

    public void setReverse(DlCompletionTreeArc v) {
        this.reverse = v;
        v.reverse = this;
    }

    @Nullable
    public Role getRole() {
        return this.role;
    }

    public DepSet getDep() {
        return this.depSet;
    }

    public void setSuccEdge(boolean val) {
        this.succEdge = val;
    }

    public boolean isSuccEdge() {
        return this.succEdge;
    }

    public boolean unblockable() {
        return this.isSuccEdge() && !this.isIBlocked() && !this.isReflexiveEdge();
    }

    public boolean isPredEdge() {
        return !this.succEdge;
    }

    public DlCompletionTree getArcEnd() {
        return this.node;
    }

    public DlCompletionTreeArc getReverse() {
        return this.reverse;
    }

    public boolean isNeighbour(Role pRole) {
        return !this.isIBlocked() && this.role.lesserequal(pRole);
    }

    @Nullable
    public DepSet neighbourDepSet(Role pRole) {
        if (this.isNeighbour(pRole)) {
            return DepSet.create(this.depSet);
        }
        return null;
    }

    public boolean isIBlocked() {
        return this.role == null;
    }

    public boolean isReflexiveEdge() {
        return this.node.equals(this.reverse.node);
    }

    @Nullable
    public Restorer save() {
        if (this.role == null) {
            return null;
        }
        EdgeRestorer ret = new EdgeRestorer(this);
        this.role = null;
        this.reverse.role = null;
        return ret;
    }

    @Nullable
    public Restorer addDep(DepSet dep) {
        if (dep.isEmpty()) {
            return null;
        }
        EdgeDepRestorer ret = new EdgeDepRestorer(this);
        this.depSet.add(dep);
        return ret;
    }

    public void print(LogAdapter o) {
        o.printTemplate(Templates.DLCOMPLETIONTREEARC, this.isIBlocked() ? "-" : this.role.getIRI(), this.depSet);
    }

    static class EdgeDepRestorer
    extends Restorer {
        private final DlCompletionTreeArc arc;
        private final DepSet dep;

        public EdgeDepRestorer(DlCompletionTreeArc q) {
            this.arc = q;
            this.dep = DepSet.create(q.getDep());
        }

        @Override
        public void restore() {
            this.arc.depSet = DepSet.create(this.dep);
        }
    }

    static class EdgeRestorer
    extends Restorer {
        private final DlCompletionTreeArc arc;
        private final Role role;

        public EdgeRestorer(DlCompletionTreeArc q) {
            this.arc = q;
            this.role = q.role;
        }

        @Override
        public void restore() {
            this.arc.role = this.role;
            this.arc.reverse.role = this.role.inverse();
        }
    }
}

