/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.jfact.kernel;

import conformance.Original;
import conformance.PortedFrom;
import gnu.trove.map.hash.TIntObjectHashMap;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import uk.ac.manchester.cs.jfact.dep.DepSet;
import uk.ac.manchester.cs.jfact.helpers.ArrayIntMap;
import uk.ac.manchester.cs.jfact.helpers.DLVertex;
import uk.ac.manchester.cs.jfact.helpers.Helper;
import uk.ac.manchester.cs.jfact.helpers.LogAdapter;
import uk.ac.manchester.cs.jfact.helpers.Reference;
import uk.ac.manchester.cs.jfact.helpers.Templates;
import uk.ac.manchester.cs.jfact.kernel.CGLabel;
import uk.ac.manchester.cs.jfact.kernel.ConceptWDep;
import uk.ac.manchester.cs.jfact.kernel.DLDag;
import uk.ac.manchester.cs.jfact.kernel.DagTag;
import uk.ac.manchester.cs.jfact.kernel.DlCompletionTreeArc;
import uk.ac.manchester.cs.jfact.kernel.RAStateTransitions;
import uk.ac.manchester.cs.jfact.kernel.Restorer;
import uk.ac.manchester.cs.jfact.kernel.Role;
import uk.ac.manchester.cs.jfact.kernel.options.JFactReasonerConfiguration;
import uk.ac.manchester.cs.jfact.kernel.state.DLCompletionTreeSaveState;
import uk.ac.manchester.cs.jfact.kernel.state.SaveList;

@PortedFrom(file="dlCompletionTree.h", name="DlCompletionTree")
public class DlCompletionTree
implements Comparable<DlCompletionTree>,
Serializable {
    private final CGLabel label;
    protected final List<ConceptWDep> inequalityRelation = new ArrayList<ConceptWDep>();
    protected final TIntObjectHashMap<ConceptWDep> inequalityRelationHelper = new TIntObjectHashMap();
    private final List<DlCompletionTreeArc> neighbour = new ArrayList<DlCompletionTreeArc>();
    private final SaveList saves = new SaveList();
    private final int id;
    private int init;
    protected DlCompletionTree blocker;
    protected DepSet pDep = DepSet.create();
    protected int curLevel;
    private boolean flagDataNode = false;
    protected boolean cached = true;
    protected boolean pBlocked = true;
    protected boolean dBlocked = true;
    private boolean affected = true;
    private int nominalLevel;
    @Original
    private final JFactReasonerConfiguration options;
    public static final int BLOCKABLE_LEVEL = Integer.MAX_VALUE;

    public DlCompletionTree(int newId, JFactReasonerConfiguration c) {
        this.id = newId;
        this.options = c;
        this.label = new CGLabel(c);
    }

    @PortedFrom(file="dlCompletionTree.h", name="B2")
    private boolean b2(DLVertex v, int c) {
        assert (this.hasParent());
        RAStateTransitions rst = v.getRole().getAutomaton().get(v.getState());
        if (v.getRole().isSimple()) {
            return this.b2Simple(rst, v.getConceptIndex());
        }
        if (rst.empty()) {
            return true;
        }
        int bp = c - v.getState();
        if (rst.isSingleton()) {
            return this.b2Simple(rst, bp + rst.getTransitionEnd());
        }
        return this.b2Complex(rst, bp);
    }

    public boolean canBlockInit(int c) {
        if (c == -1) {
            return false;
        }
        if (c == 1) {
            return true;
        }
        return this.label.contains(c);
    }

    private void logSRNode(String action) {
        this.options.getLog().printTemplateMixInt(Templates.LOG_SR_NODE, action, this.id, this.neighbour.size(), this.curLevel);
    }

    private String getBlockingStatusName() {
        return this.isPBlocked() ? "p" : (this.isDBlocked() ? "d" : (this.isIBlocked() ? "i" : "u"));
    }

    private String logNodeBStatus() {
        StringBuilder toReturn = new StringBuilder();
        if (this.blocker != null) {
            toReturn.append(this.getBlockingStatusName()).append(this.blocker.id);
        }
        if (this.isCached()) {
            toReturn.append('c');
        }
        return toReturn.toString();
    }

    public void addNeighbour(DlCompletionTreeArc p) {
        this.neighbour.add(p);
    }

    public int getId() {
        return this.id;
    }

    public boolean isCached() {
        return this.cached;
    }

    @Nullable
    public Restorer setCached(boolean val) {
        if (this.cached == val) {
            return null;
        }
        CacheRestorer ret = new CacheRestorer(this);
        this.cached = val;
        return ret;
    }

    public boolean isDataNode() {
        return this.flagDataNode;
    }

    public void setDataNode() {
        this.flagDataNode = true;
    }

    public boolean isBlockableNode() {
        return this.nominalLevel == Integer.MAX_VALUE;
    }

    public boolean isNominalNode() {
        return this.nominalLevel != Integer.MAX_VALUE;
    }

    public void setNominalLevel() {
        this.setNominalLevel(0);
    }

    public void setNominalLevel(int newLevel) {
        this.nominalLevel = newLevel;
    }

    public int getNominalLevel() {
        return this.nominalLevel;
    }

    public void addConcept(ConceptWDep p, boolean complex) {
        this.label.add(complex, p);
    }

    public void setInit(int p) {
        this.init = p;
    }

    public int getInit() {
        return this.init;
    }

    public List<DlCompletionTreeArc> getNeighbour() {
        return this.neighbour;
    }

    public boolean hasParent() {
        if (this.neighbour.isEmpty()) {
            return false;
        }
        return this.neighbour.get(0).isPredEdge();
    }

    @Nullable
    public DlCompletionTree isSomeApplicable(Role r, int c) {
        return r.isTransitive() ? this.isTSomeApplicable(r, c) : this.isNSomeApplicable(r, c);
    }

    public CGLabel label() {
        return this.label;
    }

    public List<ConceptWDep> simpleConcepts() {
        return this.label.getSimpleConcepts();
    }

    public List<ConceptWDep> complexConcepts() {
        return this.label.getComplexConcepts();
    }

    public ArrayIntMap simpleConceptsMap() {
        return this.label.getSimpleConceptsMap();
    }

    public ArrayIntMap complexConceptsMap() {
        return this.label.getComplexConceptsMap();
    }

    public boolean isLabelledBy(int p) {
        return this.label.contains(p);
    }

    public boolean isBlockedBySH(DlCompletionTree p) {
        return this.label.lesserequal(p.label);
    }

    public boolean isBlockedBySHI(DLDag dag, DlCompletionTree p) {
        return this.isCommonlyBlockedBy(dag, p);
    }

    public boolean isBlockedBySHIQ(DLDag dag, DlCompletionTree p) {
        return this.isCommonlyBlockedBy(dag, p) && (this.isCBlockedBy(dag, p) || this.isABlockedBy(dag, p));
    }

    public DlCompletionTree getParentNode() {
        return this.neighbour.get(0).getArcEnd();
    }

    public boolean isAffected() {
        return this.affected;
    }

    public void setAffected() {
        if (this.isAffected() || this.isNominalNode() || this.isPBlocked()) {
            return;
        }
        this.affected = true;
        this.neighbour.stream().filter(q -> q.isSuccEdge()).forEach(q -> q.getArcEnd().setAffected());
    }

    public void clearAffected() {
        this.affected = false;
    }

    public boolean isDBlocked() {
        return this.blocker != null && !this.pBlocked && this.dBlocked;
    }

    public boolean isIBlocked() {
        return this.blocker != null && !this.pBlocked && !this.dBlocked;
    }

    public boolean isPBlocked() {
        return this.blocker != null && this.pBlocked && !this.dBlocked;
    }

    public boolean isBlockedPBlockedNominalNodeCached() {
        return this.cached || this.isNominalNode() || this.isBlocked() || this.isPBlocked();
    }

    public boolean isBlocked() {
        return this.blocker != null && !this.pBlocked;
    }

    public boolean isIllegallyDBlocked() {
        return this.isDBlocked() && this.blocker.isBlocked();
    }

    public DlCompletionTree getBlocker() {
        return this.blocker;
    }

    public DepSet getPurgeDep() {
        return this.pDep;
    }

    public DlCompletionTree resolvePBlocker() {
        if (this.isPBlocked()) {
            return this.blocker.resolvePBlocker();
        }
        return this;
    }

    public DlCompletionTree resolvePBlocker(DepSet dep) {
        if (!this.isPBlocked()) {
            return this;
        }
        dep.add(this.pDep);
        return this.blocker.resolvePBlocker(dep);
    }

    public boolean isLoopLabelled(int c) {
        assert (this.isDBlocked());
        if (this.blocker.isLabelledBy(c)) {
            return true;
        }
        int n = 1;
        DlCompletionTree p = this.getParentNode();
        while (p.hasParent() && !p.equals(this.blocker)) {
            if (p.isLabelledBy(c)) {
                return true;
            }
            ++n;
            p = p.getParentNode();
        }
        this.options.getLog().print(" loop(").print(n).print(")");
        return false;
    }

    private Restorer setBlocked(@Nullable DlCompletionTree blocker, boolean permanently, boolean directly) {
        UnBlock ret = new UnBlock(this);
        this.setBlocker(blocker);
        this.pBlocked = permanently;
        this.dBlocked = directly;
        this.options.getLog().printTemplate(Templates.LOG_NODE_BLOCKED, this.getBlockingStatusName(), Integer.toString(this.id), blocker == null ? "" : ",", blocker == null ? "" : Integer.toString(blocker.id));
        return ret;
    }

    public Restorer setDBlocked(DlCompletionTree blocker) {
        return this.setBlocked(blocker, false, true);
    }

    public Restorer setIBlocked(DlCompletionTree blocker) {
        return this.setBlocked(blocker, false, false);
    }

    public Restorer setUBlocked() {
        return this.setBlocked(null, true, true);
    }

    public Restorer setPBlocked(@Nullable DlCompletionTree blocker, DepSet dep) {
        UnBlock ret = new UnBlock(this);
        this.setBlocker(blocker);
        if (this.isNominalNode()) {
            this.pDep = DepSet.create(dep);
        }
        this.pBlocked = true;
        this.dBlocked = false;
        this.options.getLog().printTemplate(Templates.LOG_NODE_BLOCKED, this.getBlockingStatusName(), Integer.toString(this.id), blocker == null ? "" : ",", blocker == null ? "" : Integer.toString(blocker.id));
        return ret;
    }

    @Nullable
    public DlCompletionTreeArc getEdgeLabelled(Role r, DlCompletionTree node) {
        return this.neighbour.stream().filter(p -> p.getArcEnd().equals(node) && p.isNeighbour(r)).findAny().orElse(null);
    }

    private boolean isParentArcLabelled(Role r) {
        return this.getEdgeLabelled(r, this.getParentNode()) != null;
    }

    @PortedFrom(file="dlCompletionTree.cpp", name="initIR")
    public boolean initIR(int level, DepSet ds) {
        Reference<DepSet> dummy = new Reference<DepSet>(DepSet.create());
        if (this.inIRwithC(level, ds, dummy)) {
            return true;
        }
        ConceptWDep conceptWDep = new ConceptWDep(level, ds);
        this.inequalityRelation.add(conceptWDep);
        this.inequalityRelationHelper.put(level, (Object)conceptWDep);
        return false;
    }

    @PortedFrom(file="dlCompletionTree.cpp", name="inIRwithC")
    private boolean inIRwithC(int level, DepSet ds, Reference<DepSet> dep) {
        if (this.inequalityRelation.isEmpty()) {
            return false;
        }
        ConceptWDep p = (ConceptWDep)this.inequalityRelationHelper.get(level);
        if (p != null) {
            dep.getReference().add(p.getDep());
            dep.getReference().add(ds);
            return true;
        }
        return false;
    }

    public boolean needSave(int newLevel) {
        return this.curLevel < newLevel;
    }

    public void save(int level) {
        DLCompletionTreeSaveState node = new DLCompletionTreeSaveState();
        this.saves.push(node);
        this.save(node);
        this.curLevel = level;
    }

    public boolean needRestore(int restLevel) {
        return this.curLevel > restLevel;
    }

    public void restore(int level) {
        this.restore(this.saves.pop(level));
    }

    public String logNode() {
        return String.valueOf(this.id) + this.logNodeBStatus();
    }

    private boolean isCommonlyBlockedBy(DLDag dag, DlCompletionTree p) {
        assert (this.hasParent());
        if (!this.label.lesserequal(p.label)) {
            return false;
        }
        ArrayIntMap list = p.complexConceptsMap();
        int size = list.size();
        int i = 0;
        while (i < size) {
            DLVertex v;
            int bp = list.keySet(i);
            if (bp > 0 && (v = dag.get(bp)).getType() == DagTag.FORALL && !this.b2(v, bp)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private boolean isABlockedBy(DLDag dag, DlCompletionTree p) {
        assert (this.hasParent());
        ArrayIntMap list = p.complexConceptsMap();
        int i = 0;
        while (i < list.size()) {
            int bp = list.keySet(i);
            DLVertex v = dag.get(bp);
            if (v.getType() == DagTag.FORALL && bp < 0 ? !this.b4(1, v.getRole(), -v.getConceptIndex()) : v.getType() == DagTag.LE && (bp > 0 ? !this.b3(p, v.getNumberLE(), v.getRole(), v.getConceptIndex()) : !this.b4(v.getNumberGE(), v.getRole(), v.getConceptIndex()))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private boolean isCBlockedBy(DLDag dag, DlCompletionTree t) {
        Stream list = t.complexConcepts().stream();
        if (list.anyMatch(p -> {
            if (p.getConcept() > 0) {
                DLVertex v = dag.get(p.getConcept());
                return v.getType() == DagTag.LE && !this.b5(v.getRole(), v.getConceptIndex());
            }
            return false;
        })) {
            return false;
        }
        list = this.getParentNode().complexConcepts().stream();
        return !list.anyMatch(p -> {
            if (p.getConcept() < 0) {
                DLVertex v = dag.get(p.getConcept());
                return v.getType() == DagTag.LE && !this.b6(v.getRole(), v.getConceptIndex());
            }
            return false;
        });
    }

    @PortedFrom(file="Blocking.cpp", name="B2Simple")
    private boolean b2Simple(RAStateTransitions rst, int c) {
        DlCompletionTree parent = this.getParentNode();
        if (this.neighbour.stream().anyMatch(p -> this.recognise(rst, parent, (DlCompletionTreeArc)p))) {
            return parent.label().contains(c);
        }
        return true;
    }

    @PortedFrom(file="Blocking.cpp", name="B2Complex")
    private boolean b2Complex(RAStateTransitions rst, int c) {
        DlCompletionTree parent = this.getParentNode();
        CGLabel parLab = parent.label();
        return !this.neighbour.stream().filter(p -> this.recognise(rst, parent, (DlCompletionTreeArc)p)).anyMatch(p -> rst.stream().anyMatch(q -> q.applicable(p.getRole()) && !parLab.containsCC(c + q.finalState())));
    }

    protected boolean recognise(RAStateTransitions rst, DlCompletionTree parent, DlCompletionTreeArc p) {
        return !p.isIBlocked() && p.getArcEnd().equals(parent) && rst.recognise(p.getRole());
    }

    @PortedFrom(file="Blocking.cpp", name="B3")
    private boolean b3(DlCompletionTree p, int n, Role t, int c) {
        long m;
        assert (this.hasParent());
        boolean ret = !this.isParentArcLabelled(t) ? true : (this.getParentNode().isLabelledBy(-c) ? true : (!this.getParentNode().isLabelledBy(c) ? false : (m = p.neighbour.stream().filter(q -> q.isSuccEdge() && q.isNeighbour(t) && q.getArcEnd().isLabelledBy(c)).count()) < (long)n));
        return ret;
    }

    @PortedFrom(file="Blocking.cpp", name="B4")
    private boolean b4(int m, Role t, int e) {
        assert (this.hasParent());
        if (this.isParentArcLabelled(t) && m == 1 && this.getParentNode().isLabelledBy(e)) {
            return true;
        }
        AtomicInteger n = new AtomicInteger(0);
        return this.neighbour.stream().anyMatch(q -> q.isSuccEdge() && q.isNeighbour(t) && q.getArcEnd().isLabelledBy(e) && n.incrementAndGet() >= m);
    }

    @PortedFrom(file="Blocking.cpp", name="B5")
    private boolean b5(Role t, int e) {
        assert (this.hasParent());
        if (!this.isParentArcLabelled(t)) {
            return true;
        }
        return this.getParentNode().isLabelledBy(-e);
    }

    @PortedFrom(file="Blocking.cpp", name="B6")
    private boolean b6(Role u, int f) {
        assert (this.hasParent());
        if (!this.isParentArcLabelled(u.inverse())) {
            return true;
        }
        return this.isLabelledBy(-f);
    }

    public void init(int level) {
        this.flagDataNode = false;
        this.nominalLevel = Integer.MAX_VALUE;
        this.curLevel = level;
        this.cached = false;
        this.affected = true;
        this.dBlocked = true;
        this.pBlocked = true;
        this.label.init();
        this.init = 1;
        this.saves.clear();
        this.inequalityRelation.clear();
        this.inequalityRelationHelper.clear();
        this.neighbour.clear();
        this.setBlocker(null);
        this.pDep.clear();
    }

    @Nullable
    private DlCompletionTree isTSuccLabelled(Role r, int c) {
        if (this.isLabelledBy(c)) {
            return this;
        }
        if (this.isNominalNode()) {
            return null;
        }
        for (DlCompletionTreeArc p : this.neighbour) {
            DlCompletionTree ret;
            if (!p.isSuccEdge() || !p.isNeighbour(r) || p.isReflexiveEdge() || (ret = p.getArcEnd().isTSuccLabelled(r, c)) == null) continue;
            return ret;
        }
        return null;
    }

    @Nullable
    private DlCompletionTree isTPredLabelled(Role r, int c, DlCompletionTree from) {
        if (this.isLabelledBy(c)) {
            return this;
        }
        if (this.isNominalNode()) {
            return null;
        }
        for (DlCompletionTreeArc p : this.neighbour) {
            DlCompletionTree ret;
            if (!p.isSuccEdge() || !p.isNeighbour(r) || p.getArcEnd().equals(from) || (ret = p.getArcEnd().isTSuccLabelled(r, c)) == null) continue;
            return ret;
        }
        if (this.hasParent() && this.isParentArcLabelled(r)) {
            return this.getParentNode().isTPredLabelled(r, c, this);
        }
        return null;
    }

    @Nullable
    private DlCompletionTree isNSomeApplicable(Role r, int c) {
        Optional<DlCompletionTreeArc> findAny = this.neighbour.stream().filter(p -> p.isNeighbour(r) && p.getArcEnd().isLabelledBy(c)).findAny();
        if (findAny.isPresent()) {
            return findAny.get().getArcEnd();
        }
        return null;
    }

    @Nullable
    private DlCompletionTree isTSomeApplicable(Role r, int c) {
        for (DlCompletionTreeArc p : this.neighbour) {
            DlCompletionTree ret;
            if (!p.isNeighbour(r) || (ret = p.isPredEdge() ? p.getArcEnd().isTPredLabelled(r, c, this) : p.getArcEnd().isTSuccLabelled(r, c)) == null) continue;
            return ret;
        }
        return null;
    }

    private void save(DLCompletionTreeSaveState nss) {
        nss.setCurLevel(this.curLevel);
        nss.setnNeighbours(this.neighbour.size());
        this.label.save(nss.getLab());
        this.logSRNode("SaveNode");
    }

    private void restore(@Nullable DLCompletionTreeSaveState nss) {
        if (nss == null) {
            return;
        }
        this.curLevel = nss.getCurLevel();
        this.label.restore(nss.getLab(), this.curLevel);
        if (!this.options.isUseDynamicBackjumping()) {
            Helper.resize(this.neighbour, nss.getnNeighbours(), null);
        } else {
            int j = this.neighbour.size() - 1;
            while (j >= 0) {
                if (this.neighbour.get((int)j).getArcEnd().curLevel <= this.curLevel) {
                    Helper.resize(this.neighbour, j + 1, null);
                    break;
                }
                --j;
            }
        }
        this.affected = true;
        this.logSRNode("RestNode");
    }

    public void printBody(LogAdapter o) {
        o.print(this.id);
        if (this.isNominalNode()) {
            o.print("o").print(this.nominalLevel);
        }
        o.print("(").print(this.curLevel).print(")");
        if (this.isDataNode()) {
            o.print("d");
        }
        o.print((Object)this.label).print(this.logNodeBStatus());
    }

    public String toString() {
        StringBuilder o = new StringBuilder();
        o.append(this.id);
        if (this.isNominalNode()) {
            o.append('o').append(this.nominalLevel);
        }
        o.append('(').append(this.curLevel).append(')');
        if (this.isDataNode()) {
            o.append('d');
        }
        o.append(this.label).append(this.logNodeBStatus());
        return o.toString();
    }

    @PortedFrom(file="dlCompletionTree.cpp", name="nonMergable")
    public boolean nonMergable(DlCompletionTree node, Reference<DepSet> dep) {
        if (this.inequalityRelation.isEmpty() || node.inequalityRelation.isEmpty()) {
            return false;
        }
        for (ConceptWDep p : node.inequalityRelation) {
            if (!this.inIRwithC(p.getConcept(), p.getDep(), dep)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    @PortedFrom(file="dlCompletionTree.cpp", name="updateIR")
    public Restorer updateIR(DlCompletionTree node, DepSet toAdd) {
        if (node.inequalityRelation.isEmpty()) {
            return null;
        }
        IRRestorer ret = new IRRestorer();
        for (ConceptWDep p : node.inequalityRelation) {
            if (this.inequalityRelationHelper.containsKey(p.getConcept())) continue;
            ConceptWDep conceptWDep = new ConceptWDep(p.getConcept(), toAdd);
            this.inequalityRelation.add(conceptWDep);
            this.inequalityRelationHelper.put(p.getConcept(), (Object)conceptWDep);
        }
        return ret;
    }

    @Override
    public int compareTo(@Nullable DlCompletionTree o) {
        if (this.nominalLevel == o.nominalLevel) {
            return this.id - o.id;
        }
        return this.nominalLevel - o.nominalLevel;
    }

    public boolean equals(@Nullable Object arg0) {
        if (arg0 == null) {
            return false;
        }
        if (this == arg0) {
            return true;
        }
        if (arg0 instanceof DlCompletionTree) {
            DlCompletionTree arg02 = (DlCompletionTree)arg0;
            return this.nominalLevel == arg02.nominalLevel && this.id == arg02.id;
        }
        return false;
    }

    public int hashCode() {
        return this.nominalLevel * this.id;
    }

    public void setBlocker(@Nullable DlCompletionTree blocker) {
        this.blocker = blocker;
    }

    static class CacheRestorer
    extends Restorer {
        private final DlCompletionTree p;
        private final boolean isCached;

        public CacheRestorer(DlCompletionTree q) {
            this.p = q;
            this.isCached = q.cached;
        }

        @Override
        public void restore() {
            this.p.cached = this.isCached;
        }
    }

    class IRRestorer
    extends Restorer {
        private final int n;

        public IRRestorer() {
            this.n = DlCompletionTree.this.inequalityRelation.size();
        }

        @Override
        public void restore() {
            Helper.resize(DlCompletionTree.this.inequalityRelation, this.n, null);
            DlCompletionTree.this.inequalityRelationHelper.clear();
            DlCompletionTree.this.inequalityRelation.stream().filter(p -> p != null).forEach(p -> {
                Object object = DlCompletionTree.this.inequalityRelationHelper.put(p.getConcept(), p);
            });
        }
    }

    static class UnBlock
    extends Restorer {
        private final DlCompletionTree p;
        private final DlCompletionTree unblockBlocker;
        private final DepSet dep;
        private final boolean pBlocked;
        private final boolean dBlocked;

        public UnBlock(DlCompletionTree q) {
            this.p = q;
            this.unblockBlocker = q.blocker;
            this.dep = DepSet.create(q.pDep);
            this.pBlocked = q.pBlocked;
            this.dBlocked = q.dBlocked;
        }

        @Override
        public void restore() {
            this.p.setBlocker(this.unblockBlocker);
            this.p.pDep = DepSet.create(this.dep);
            this.p.pBlocked = this.pBlocked;
            this.p.dBlocked = this.dBlocked;
        }
    }
}

