/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.jfact.kernel;

import conformance.PortedFrom;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import uk.ac.manchester.cs.chainsaw.FastSet;
import uk.ac.manchester.cs.chainsaw.FastSetFactory;
import uk.ac.manchester.cs.jfact.helpers.DLVertex;
import uk.ac.manchester.cs.jfact.kernel.DLDag;

@PortedFrom(file="dlVHash.h", name="dlVHashTable")
class DLVTable
implements Serializable {
    private final DLDag host;
    private final Map<DLVertex, FastSet> table = new HashMap<DLVertex, FastSet>();

    protected DLVTable(DLDag dag) {
        this.host = dag;
    }

    private int locate(FastSet leaf, DLVertex v) {
        int i = 0;
        while (i < leaf.size()) {
            int p = leaf.get(i);
            if (v.equals(this.host.get(p))) {
                return p;
            }
            ++i;
        }
        return 0;
    }

    protected int locate(DLVertex v) {
        FastSet p = this.table.get(v);
        return p == null ? 0 : this.locate(p, v);
    }

    protected void addElement(int pos) {
        FastSet leaf = this.table.get(this.host.get(pos));
        if (leaf == null) {
            leaf = FastSetFactory.create();
            this.table.put(this.host.get(pos), leaf);
        }
        leaf.add(pos);
    }

    public String toString() {
        return String.valueOf(this.table.toString()) + '\n' + this.host.toString();
    }
}

