/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.jfact.kernel;

import conformance.PortedFrom;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nullable;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapitools.decomposition.Signature;
import uk.ac.manchester.cs.jfact.helpers.Templates;
import uk.ac.manchester.cs.jfact.kernel.ClassifiableEntry;
import uk.ac.manchester.cs.jfact.kernel.Concept;
import uk.ac.manchester.cs.jfact.kernel.Individual;
import uk.ac.manchester.cs.jfact.kernel.KBFlags;
import uk.ac.manchester.cs.jfact.kernel.KnownSubsumers;
import uk.ac.manchester.cs.jfact.kernel.TBox;
import uk.ac.manchester.cs.jfact.kernel.Taxonomy;
import uk.ac.manchester.cs.jfact.kernel.TaxonomyCreator;
import uk.ac.manchester.cs.jfact.kernel.TaxonomyVertex;
import uk.ac.manchester.cs.jfact.kernel.dl.interfaces.NamedEntity;
import uk.ac.manchester.cs.jfact.kernel.modelcaches.ModelCacheInterface;
import uk.ac.manchester.cs.jfact.kernel.modelcaches.ModelCacheState;

@PortedFrom(file="DLConceptTaxonomy.h", name="DLConceptTaxonomy")
public class DLConceptTaxonomy
extends TaxonomyCreator {
    @PortedFrom(file="DLConceptTaxonomy.h", name="tBox")
    private final TBox tBox;
    @PortedFrom(file="DLConceptTaxonomy.h", name="Common")
    private final List<TaxonomyVertex> common = new ArrayList<TaxonomyVertex>();
    @PortedFrom(file="DLConceptTaxonomy.h", name="nConcepts")
    private long nConcepts = 0L;
    @PortedFrom(file="DLConceptTaxonomy.h", name="nTries")
    private long nTries = 0L;
    @PortedFrom(file="DLConceptTaxonomy.h", name="nPositives")
    private long nPositives = 0L;
    @PortedFrom(file="DLConceptTaxonomy.h", name="nNegatives")
    private long nNegatives = 0L;
    @PortedFrom(file="DLConceptTaxonomy.h", name="nSearchCalls")
    private long nSearchCalls = 0L;
    @PortedFrom(file="DLConceptTaxonomy.h", name="nSubCalls")
    private long nSubCalls = 0L;
    @PortedFrom(file="DLConceptTaxonomy.h", name="nNonTrivialSubCalls")
    private long nNonTrivialSubCalls = 0L;
    @PortedFrom(file="DLConceptTaxonomy.h", name="nCachedPositive")
    private long nCachedPositive = 0L;
    @PortedFrom(file="DLConceptTaxonomy.h", name="nCachedNegative")
    private long nCachedNegative = 0L;
    @PortedFrom(file="DLConceptTaxonomy.h", name="nSortedNegative")
    private long nSortedNegative = 0L;
    @PortedFrom(file="DLConceptTaxonomy.h", name="nModuleNegative")
    private long nModuleNegative = 0L;
    @PortedFrom(file="DLConceptTaxonomy.h", name="flagNeedBottomUp")
    private boolean flagNeedBottomUp;
    @PortedFrom(file="DLConceptTaxonomy.h", name="nCommon")
    protected int nCommon = 1;
    protected final Set<TaxonomyVertex> candidates = new HashSet<TaxonomyVertex>();
    protected boolean useCandidates = false;
    protected Set<OWLEntity> mPlus;
    protected Set<OWLEntity> mMinus;

    public DLConceptTaxonomy(Taxonomy pTax, TBox tbox) {
        super(pTax);
        this.tBox = tbox;
    }

    @PortedFrom(file="DLConceptTaxonomy.h", name="curConcept")
    private Concept curConcept() {
        return (Concept)this.curEntry;
    }

    @PortedFrom(file="DLConceptTaxonomy.h", name="enhancedSubs")
    private boolean enhancedSubs(TaxonomyVertex cur) {
        ++this.nSubCalls;
        if (this.isValued(cur)) {
            return this.getValue(cur);
        }
        return this.setValue(cur, this.enhancedSubs2(cur));
    }

    @Override
    @PortedFrom(file="DLConceptTaxonomy.h", name="runTopDown")
    public void runTopDown() {
        this.searchBaader(this.pTax.getTopVertex());
    }

    @Override
    @PortedFrom(file="DLConceptTaxonomy.h", name="runBottomUp")
    public void runBottomUp() {
        try {
            if (this.propagateUp()) {
                return;
            }
            if (this.isEqualToTop()) {
                return;
            }
            if (this.pTax.queryMode()) {
                this.searchBaader(this.pTax.getBottomVertex());
                return;
            }
            this.common.stream().filter(p -> p.noNeighbours(false)).forEach(this::searchBaader);
        }
        finally {
            this.clearCommon();
        }
    }

    @Override
    @PortedFrom(file="DLConceptTaxonomy.h", name="preClassificationActions")
    public void preClassificationActions() {
        ++this.nConcepts;
        this.tBox.getOptions().getProgressMonitor().reasonerTaskProgressChanged((int)this.nConcepts, this.tBox.getNItems());
    }

    @PortedFrom(file="DLConceptTaxonomy.h", name="setBottomUp")
    public void setBottomUp(KBFlags gcis) {
        this.flagNeedBottomUp = gcis.isGCI() || gcis.isReflexive() && gcis.isRnD();
    }

    @PortedFrom(file="DLConceptTaxonomy.h", name="isUnsatisfiable")
    private boolean isUnsatisfiable() {
        Concept p = this.curConcept();
        if (this.tBox.isSatisfiable(p)) {
            return false;
        }
        this.pTax.addCurrentToSynonym(this.pTax.getBottomVertex());
        return true;
    }

    @Override
    @Nullable
    @PortedFrom(file="DLConceptTaxonomy.h", name="buildSignature")
    public Signature buildSignature(ClassifiableEntry p) {
        return this.tBox.getSignature(p);
    }

    @Override
    @PortedFrom(file="DLConceptTaxonomy.h", name="immediatelyClassified")
    protected boolean immediatelyClassified() {
        if (this.classifySynonym()) {
            return true;
        }
        if (this.curConcept().getClassTagPlain() == Concept.CTTag.COMPLETELYDEFINED) {
            return false;
        }
        this.tBox.initCache(this.curConcept(), false);
        return this.isUnsatisfiable();
    }

    @Override
    @PortedFrom(file="DLConceptTaxonomy.h", name="needTopDown")
    protected boolean needTopDown() {
        return !this.useCompletelyDefined || !this.curEntry.isCompletelyDefined();
    }

    @Override
    @PortedFrom(file="DLConceptTaxonomy.h", name="needBottomUp")
    protected boolean needBottomUp() {
        return this.flagNeedBottomUp || !this.useCompletelyDefined || !this.curConcept().isPrimitive();
    }

    @PortedFrom(file="DLConceptTaxonomy.h", name="testSub")
    private boolean testSub(Concept p, Concept q) {
        assert (p != null);
        assert (q != null);
        if (q.isSingleton() && q.isPrimitive() && !q.isNominal()) {
            return false;
        }
        this.tBox.getOptions().getLog().printTemplate(Templates.TAX_TRYING, p.getIRI(), q.getIRI());
        if (this.tBox.testSortedNonSubsumption(p, q)) {
            this.tBox.getOptions().getLog().print("NOT holds (sorted result)");
            ++this.nSortedNegative;
            return false;
        }
        if (this.isNotInModule(q.getEntity())) {
            this.tBox.getOptions().getLog().print("NOT holds (module result)");
            ++this.nModuleNegative;
            return false;
        }
        switch (this.tBox.testCachedNonSubsumption(p, q)) {
            case VALID: {
                this.tBox.getOptions().getLog().print("NOT holds (cached result)");
                ++this.nCachedNegative;
                return false;
            }
            case INVALID: {
                this.tBox.getOptions().getLog().print("holds (cached result)");
                ++this.nCachedPositive;
                return true;
            }
        }
        this.tBox.getOptions().getLog().print("wasted cache test");
        return this.testSubTBox(p, q);
    }

    @PortedFrom(file="DLConceptTaxonomy.h", name="isNotInModule")
    private boolean isNotInModule(@Nullable NamedEntity entity) {
        if (this.upDirection) {
            return false;
        }
        Signature sig = (Signature)this.sigStack.peek();
        return sig != null && entity != null && !sig.contains(entity.getEntity());
    }

    @PortedFrom(file="DLConceptTaxonomy.h", name="testSubTBox")
    private boolean testSubTBox(Concept p, Concept q) {
        boolean res = this.tBox.isSubHolds(p, q);
        ++this.nTries;
        if (res) {
            ++this.nPositives;
        } else {
            ++this.nNegatives;
        }
        return res;
    }

    @Override
    public String toString() {
        StringBuilder o = new StringBuilder();
        o.append(String.format(Templates.DLCONCEPTTAXONOMY.getTemplate(), Long.toString(this.nTries), Long.toString(this.nPositives), Long.toString(this.nPositives * 100L / Math.max(1L, this.nTries)), Long.toString(this.nCachedPositive), Long.toString(this.nCachedNegative), this.nSortedNegative > 0L ? String.format("Sorted reasoning deals with %s non-subsumptions%n", Long.toString(this.nSortedNegative)) : "", this.nModuleNegative > 0L ? "Modular reasoning deals with " + this.nModuleNegative + " non-subsumptions\n" : "", Long.toString(this.nSearchCalls), Long.toString(this.nSubCalls), Long.toString(this.nNonTrivialSubCalls), Long.toString((long)(this.nEntries * (this.nEntries - 1)) / Math.max(1L, this.nTries))));
        o.append(super.toString());
        return o.toString();
    }

    @PortedFrom(file="DLConceptTaxonomy.h", name="searchBaader")
    private void searchBaader(TaxonomyVertex cur) {
        this.pTax.setVisited(cur);
        ++this.nSearchCalls;
        AtomicBoolean noPosSucc = new AtomicBoolean(true);
        cur.neigh(this.upDirection).filter(this::enhancedSubs).forEach(p -> {
            if (!this.pTax.isVisited((TaxonomyVertex)p)) {
                this.searchBaader((TaxonomyVertex)p);
            }
            noPosSucc.set(false);
        });
        if (!this.isValued(cur)) {
            this.setValue(cur, this.testSubsumption(cur));
        }
        if (noPosSucc.get() && cur.getValue()) {
            this.pTax.getCurrent().addNeighbour(!this.upDirection, cur);
        }
    }

    @PortedFrom(file="DLConceptTaxonomy.h", name="enhancedSubs1")
    private boolean enhancedSubs1(TaxonomyVertex cur) {
        ++this.nNonTrivialSubCalls;
        if (cur.neigh(!this.upDirection).anyMatch(n -> !this.enhancedSubs((TaxonomyVertex)n))) {
            return false;
        }
        return this.testSubsumption(cur);
    }

    @PortedFrom(file="DLConceptTaxonomy.h", name="enhancedSubs2")
    private boolean enhancedSubs2(TaxonomyVertex cur) {
        if (this.upDirection && !cur.isCommon()) {
            return false;
        }
        if (this.useCandidates && this.candidates.contains(cur)) {
            return false;
        }
        return this.enhancedSubs1(cur);
    }

    @PortedFrom(file="DLConceptTaxonomy.h", name="possibleSub")
    private boolean possibleSub(TaxonomyVertex v) {
        Concept c = (Concept)v.getPrimer();
        if (!c.isPrimitive()) {
            return true;
        }
        return ((KnownSubsumers)this.ksStack.peek()).isPossibleSub(c);
    }

    @PortedFrom(file="DLConceptTaxonomy.h", name="testSubsumption")
    private boolean testSubsumption(TaxonomyVertex cur) {
        Concept testC = (Concept)cur.getPrimer();
        if (this.upDirection) {
            return this.testSub(testC, this.curConcept());
        }
        return this.testSub(this.curConcept(), testC);
    }

    @PortedFrom(file="DLConceptTaxonomy.h", name="propagateOneCommon")
    private void propagateOneCommon(TaxonomyVertex node) {
        if (this.pTax.isVisited(node)) {
            return;
        }
        this.pTax.setVisited(node);
        node.setCommon();
        if (node.correctCommon(this.nCommon)) {
            this.common.add(node);
        }
        node.neigh(false).forEach(this::propagateOneCommon);
    }

    @PortedFrom(file="DLConceptTaxonomy.h", name="propagateUp")
    private boolean propagateUp() {
        this.nCommon = 1;
        Iterator list = this.pTax.getCurrent().neigh(this.upDirection).iterator();
        assert (list.hasNext());
        TaxonomyVertex p = (TaxonomyVertex)list.next();
        this.propagateOneCommon(p);
        this.pTax.clearVisited();
        while (list.hasNext()) {
            p = (TaxonomyVertex)list.next();
            if (p.noNeighbours(!this.upDirection)) {
                return true;
            }
            if (this.common.isEmpty()) {
                return true;
            }
            ++this.nCommon;
            ArrayList<TaxonomyVertex> aux = new ArrayList<TaxonomyVertex>(this.common);
            this.common.clear();
            this.propagateOneCommon(p);
            this.pTax.clearVisited();
            aux.forEach(q -> {
                boolean bl = q.correctCommon(this.nCommon);
            });
        }
        return false;
    }

    @PortedFrom(file="DLConceptTaxonomy.h", name="clearCommon")
    private void clearCommon() {
        this.common.forEach(p -> p.clearCommon());
        this.common.clear();
    }

    @PortedFrom(file="DLConceptTaxonomy.h", name="isEqualToTop")
    private boolean isEqualToTop() {
        ModelCacheInterface cache = this.tBox.initCache(this.curConcept(), true);
        if (cache.getState() != ModelCacheState.INVALID) {
            return false;
        }
        this.pTax.current.addNeighbour(false, this.pTax.getTopVertex());
        return true;
    }

    @Override
    @PortedFrom(file="DLConceptTaxonomy.h", name="classifySynonym")
    protected boolean classifySynonym() {
        Individual curI;
        if (super.classifySynonym()) {
            return true;
        }
        if (this.curConcept().isSingleton() && this.tBox.isBlockedInd(curI = (Individual)this.curConcept())) {
            Individual syn = this.tBox.getBlockingInd(curI);
            assert (syn.isClassified());
            TaxonomyVertex taxVertex = syn.getTaxVertex();
            assert (taxVertex != null);
            if (this.tBox.isBlockingDet(curI)) {
                this.pTax.addCurrentToSynonym(taxVertex);
                return true;
            }
            this.tBox.getOptions().getLog().print((Object)"\nTAX: trying '", (Object)curI.getIRI(), (Object)"' = '", (Object)syn.getIRI(), (Object)"'... ");
            if (this.testSubTBox(curI, syn)) {
                this.pTax.addCurrentToSynonym(taxVertex);
                return true;
            }
        }
        return false;
    }

    @PortedFrom(file="DLConceptTaxonomy.h", name="checkExtraParents")
    private void checkExtraParents() {
        this.pTax.current.neigh(true).forEach(this::propagateTrueUp);
        this.pTax.current.clearLinks(true);
        this.runTopDown();
        this.pTax.current.neigh(true).filter(p -> !this.isDirectParent((TaxonomyVertex)p)).forEach(p -> {
            p.removeLink(false, this.pTax.current);
            this.pTax.current.removeLink(true, (TaxonomyVertex)p);
        });
        this.clearLabels();
    }

    @PortedFrom(file="DLConceptTaxonomy.h", name="mergeVertex")
    private void mergeVertex(TaxonomyVertex cur, TaxonomyVertex v, Set<TaxonomyVertex> excludes) {
        if (!cur.equals(v)) {
            cur.mergeIndepNode(v, excludes, this.curEntry);
            this.pTax.removeNode(v);
        }
    }

    public void fillCandidates(TaxonomyVertex cur) {
        if (this.isValued(cur)) {
            if (this.getValue(cur)) {
                return;
            }
        } else {
            this.candidates.add(cur);
        }
        cur.neigh(true).forEach(this::fillCandidates);
    }

    public void reclassify(Set<OWLEntity> plus, Set<OWLEntity> minus) {
        this.mPlus = plus;
        this.mMinus = minus;
        this.pTax.deFinalise();
        LinkedList<TaxonomyVertex> queue = new LinkedList<TaxonomyVertex>();
        ArrayList<ClassifiableEntry> toProcess = new ArrayList<ClassifiableEntry>();
        queue.add(this.pTax.getTopVertex());
        while (!queue.isEmpty()) {
            TaxonomyVertex cur = (TaxonomyVertex)queue.remove(0);
            if (this.pTax.isVisited(cur)) continue;
            this.pTax.setVisited(cur);
            ClassifiableEntry entry = cur.getPrimer();
            if (this.mPlus.contains(entry.getEntity().getEntity()) || this.mMinus.contains(entry.getEntity().getEntity())) {
                toProcess.add(entry);
            }
            cur.neigh(false).forEach(queue::add);
        }
        this.pTax.clearVisited();
        toProcess.forEach(p -> this.reclassify(p.getTaxVertex(), this.tBox.getSignature((ClassifiableEntry)p)));
        this.pTax.finalise();
    }

    public void reclassify(TaxonomyVertex node, @Nullable Signature s) {
        this.upDirection = false;
        this.sigStack.add(s);
        this.curEntry = node.getPrimer();
        TaxonomyVertex oldCur = this.pTax.getCurrent();
        this.pTax.setCurrent(node);
        boolean added = this.mPlus.contains(this.curEntry.getEntity().getEntity());
        boolean removed = this.mMinus.contains(this.curEntry.getEntity().getEntity());
        assert (added || removed);
        this.clearLabels();
        this.setValue(this.pTax.getTopVertex(), true);
        if (node.noNeighbours(true)) {
            node.addNeighbour(true, this.pTax.getTopVertex());
        }
        this.useCandidates = !added;
        this.candidates.clear();
        if (removed) {
            ArrayList neg = new ArrayList();
            node.neigh(true).forEach(p -> {
                if (!this.isValued((TaxonomyVertex)p) || !this.getValue((TaxonomyVertex)p)) {
                    if (this.testSubsumption((TaxonomyVertex)p)) {
                        this.propagateTrueUp((TaxonomyVertex)p);
                    } else {
                        this.setValue((TaxonomyVertex)p, false);
                        neg.add(p);
                    }
                }
            });
            node.removeLinks(true);
            if (this.useCandidates) {
                neg.forEach(this::fillCandidates);
            }
        } else {
            node.neigh(true).forEach(this::propagateTrueUp);
            node.removeLinks(true);
        }
        this.setValue(node, true);
        this.searchBaader(this.pTax.getTopVertex());
        node.incorporate(this.pTax.getOptions());
        this.clearLabels();
        this.sigStack.pop();
        this.pTax.setCurrent(oldCur);
    }
}

