/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.jfact.kernel;

import conformance.Original;
import conformance.PortedFrom;
import gnu.trove.set.TIntSet;
import gnu.trove.set.hash.TIntHashSet;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import uk.ac.manchester.cs.jfact.helpers.ArrayIntMap;
import uk.ac.manchester.cs.jfact.helpers.Helper;
import uk.ac.manchester.cs.jfact.kernel.CWDArray;
import uk.ac.manchester.cs.jfact.kernel.ConceptWDep;
import uk.ac.manchester.cs.jfact.kernel.options.JFactReasonerConfiguration;
import uk.ac.manchester.cs.jfact.kernel.state.SaveState;

@PortedFrom(file="CGLabel.h", name="CGLabel")
public class CGLabel
implements Serializable {
    @Original
    private static int idcounter = 0;
    @PortedFrom(file="CGLabel.h", name="scLabel")
    private final CWDArray scLabel;
    @PortedFrom(file="CGLabel.h", name="ccLabel")
    private final CWDArray ccLabel;
    @Original
    private final int id;
    @Original
    private TIntSet lesserIndex = new TIntHashSet();
    @Original
    private final List<CGLabel> lesserEqualsList = new ArrayList<CGLabel>();

    public CGLabel(JFactReasonerConfiguration config) {
        this.scLabel = new CWDArray(config, 8);
        this.ccLabel = new CWDArray(config, 4);
        this.id = CGLabel.getnewId();
    }

    @Original
    private static int getnewId() {
        return idcounter++;
    }

    @Original
    public List<ConceptWDep> getSimpleConcepts() {
        return this.scLabel.getBase();
    }

    @Original
    public List<ConceptWDep> getComplexConcepts() {
        return this.ccLabel.getBase();
    }

    @Original
    public ArrayIntMap getSimpleConceptsMap() {
        return this.scLabel.getContainedConcepts();
    }

    @Original
    public ArrayIntMap getComplexConceptsMap() {
        return this.ccLabel.getContainedConcepts();
    }

    @PortedFrom(file="CGLabel.h", name="getLabel")
    public CWDArray getLabel(boolean complex) {
        return complex ? this.ccLabel : this.scLabel;
    }

    @Original
    public void add(boolean complex, ConceptWDep p) {
        this.getLabel(complex).privateAdd(p);
        this.clearMyCache();
    }

    @Original
    protected void clearMyCache() {
        this.lesserEqualsList.clear();
        this.lesserIndex.clear();
    }

    @Original
    protected void clearOthersCache() {
        this.lesserEqualsList.forEach(c -> {
            boolean bl = c.lesserEqualsList.remove(this);
        });
        this.lesserEqualsList.forEach(c -> {
            boolean bl = c.lesserIndex.remove(this.id);
        });
    }

    @PortedFrom(file="CGLabel.h", name="containsCC")
    public boolean containsCC(int p) {
        return this.ccLabel.contains(p);
    }

    public int hashCode() {
        return this.id;
    }

    @PortedFrom(file="CGLabel.h", name="<=")
    public boolean lesserequal(CGLabel label) {
        boolean toReturn;
        if (this == label) {
            return true;
        }
        if (this.lesserIndex.contains(label.id)) {
            return true;
        }
        boolean bl = toReturn = this.scLabel.lesserequal(label.scLabel) && this.ccLabel.lesserequal(label.ccLabel);
        if (toReturn) {
            this.lesserEqualsList.add(label);
            this.lesserIndex.add(label.id);
        }
        return toReturn;
    }

    public boolean equals(@Nullable Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (obj instanceof CGLabel) {
            CGLabel obj2 = (CGLabel)obj;
            return this.scLabel.equals(obj2.scLabel) && this.ccLabel.equals(obj2.ccLabel);
        }
        return false;
    }

    @PortedFrom(file="CGLabel.h", name="save")
    public void save(SaveState ss) {
        ss.setSc(this.scLabel.save());
        ss.setCc(this.ccLabel.save());
    }

    @PortedFrom(file="CGLabel.h", name="restore")
    public void restore(SaveState ss, int level) {
        this.scLabel.restore(ss.getSc(), level);
        this.ccLabel.restore(ss.getCc(), level);
        this.clearOthersCache();
    }

    public String toString() {
        return String.valueOf(this.scLabel.toString()) + this.ccLabel.toString();
    }

    @PortedFrom(file="CGLabel.h", name="init")
    public void init() {
        this.clearOthersCache();
        this.clearMyCache();
        this.scLabel.init();
        this.ccLabel.init();
    }

    @PortedFrom(file="CGLabel.h", name="contains")
    public boolean contains(int p) {
        assert (Helper.isCorrect(p));
        if (p == 1) {
            return true;
        }
        if (p == -1) {
            return false;
        }
        return this.scLabel.contains(p) || this.ccLabel.contains(p);
    }

    @PortedFrom(file="CGLabel.h", name="getConcept")
    public ConceptWDep getConceptWithBP(int bp) {
        ConceptWDep toReturn = this.getSCConceptWithBP(bp);
        if (toReturn != null) {
            return toReturn;
        }
        return this.getCCConceptWithBP(bp);
    }

    @Nullable
    @PortedFrom(file="CGLabel.h", name="getConcept")
    public ConceptWDep getSCConceptWithBP(int bp) {
        return this.scLabel.getConceptWithBP(bp);
    }

    @Nullable
    @PortedFrom(file="CGLabel.h", name="getConcept")
    public ConceptWDep getCCConceptWithBP(int bp) {
        return this.ccLabel.getConceptWithBP(bp);
    }
}

