/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.jfact.helpers;

import conformance.Original;
import java.util.ArrayList;
import java.util.Collection;
import javax.annotation.Nullable;
import org.semanticweb.owlapi.reasoner.ReasonerInternalException;
import uk.ac.manchester.cs.jfact.helpers.DLTree;
import uk.ac.manchester.cs.jfact.helpers.DLTreeVisitor;
import uk.ac.manchester.cs.jfact.helpers.DLTreeVisitorEx;
import uk.ac.manchester.cs.jfact.kernel.Lexeme;

@Original
class NDLTree
extends DLTree {
    public NDLTree(Lexeme l, Collection<DLTree> trees) {
        super(l);
        if (trees.size() < 2) {
            throw new ReasonerInternalException("not enough elements in the n-ary element: " + trees);
        }
        this.children = new ArrayList();
        trees.forEach(this::addChild);
    }

    public NDLTree(Lexeme l, @Nullable DLTree c, @Nullable DLTree d) {
        super(l);
        if (c == null || d == null) {
            throw new ReasonerInternalException("not enough elements in the n-ary element: " + c + " " + d);
        }
        this.children = new ArrayList();
        this.addChild(c);
        this.addChild(d);
    }

    @Override
    public DLTree getChild() {
        throw new UnsupportedOperationException();
    }

    @Override
    public DLTree getLeft() {
        throw new UnsupportedOperationException();
    }

    @Override
    public DLTree getRight() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void accept(DLTreeVisitor v) {
        v.visit(this);
    }

    @Override
    public <O> O accept(DLTreeVisitorEx<O> v) {
        return v.visit(this);
    }

    @Override
    public void replace(DLTree toReplace, @Nullable DLTree replacement) {
        if (this.children.contains(toReplace)) {
            this.children.remove(toReplace);
            if (replacement != null) {
                this.children.add(replacement);
                replacement.ancestor = this;
            }
        }
    }
}

