/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.jfact.helpers;

import java.io.Serializable;
import java.util.Arrays;
import javax.annotation.Nullable;

public class ArrayIntMap
implements Serializable {
    private int[][] values;
    private int size = 0;
    private static final int DEFAULTSIZE = 16;

    private int insertionIndex(int key) {
        if (this.size == 0) {
            return -1;
        }
        if (key < this.values[0][0]) {
            return -1;
        }
        if (key > this.values[0][this.size - 1]) {
            return -this.size - 1;
        }
        int lowerbound = 0;
        if (this.size < 5) {
            while (lowerbound < this.size) {
                if (this.values[0][lowerbound] == key) {
                    return lowerbound;
                }
                if (this.values[0][lowerbound] > key) {
                    return -lowerbound - 1;
                }
                ++lowerbound;
            }
            return -lowerbound - 1;
        }
        int upperbound = this.size - 1;
        while (lowerbound <= upperbound) {
            int intermediate = lowerbound + (upperbound - lowerbound) / 2;
            if (this.values[0][intermediate] == key) {
                return intermediate;
            }
            if (this.values[0][intermediate] < key) {
                lowerbound = intermediate + 1;
                continue;
            }
            upperbound = intermediate - 1;
        }
        return -lowerbound - 1;
    }

    private void init() {
        this.values = new int[2][16];
        this.size = 0;
    }

    public void put(int e, int v) {
        int pos = -1;
        if (this.values == null) {
            this.init();
        } else {
            pos = this.insertionIndex(e);
        }
        if (pos > -1) {
            return;
        }
        int i = -pos - 1;
        if (i >= this.values[0].length || this.size >= this.values[0].length) {
            int[][] replacementvalues = new int[2][this.values[0].length + 16];
            int j = 0;
            while (j < this.values[0].length) {
                replacementvalues[0][j] = this.values[0][j];
                replacementvalues[1][j] = this.values[1][j];
                ++j;
            }
            this.values = replacementvalues;
        }
        int j = this.size - 1;
        while (j >= i) {
            this.values[0][j + 1] = this.values[0][j];
            this.values[1][j + 1] = this.values[1][j];
            --j;
        }
        this.values[0][i] = e;
        this.values[1][i] = v;
        ++this.size;
    }

    public void clear() {
        this.values = null;
        this.size = 0;
    }

    public boolean containsKey(int o) {
        if (this.values != null) {
            return this.insertionIndex(o) > -1;
        }
        return false;
    }

    public boolean containsAll(ArrayIntMap c) {
        if (c.size == 0) {
            return true;
        }
        if (this.size == 0) {
            return false;
        }
        if (c.size > this.size) {
            return false;
        }
        if (this.size == c.size) {
            int i = 0;
            while (i < this.size) {
                if (this.values[0][i] != c.values[0][i]) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        if (this.values[0][0] > c.values[0][0] || this.values[0][this.size - 1] < c.values[0][c.size() - 1]) {
            return false;
        }
        int i = 0;
        int j = 0;
        while (j < c.size()) {
            int currentValue = c.values[0][j];
            boolean found = false;
            while (i < this.size) {
                if (this.values[0][i] == currentValue) {
                    found = true;
                    break;
                }
                if (this.values[0][i] > currentValue) {
                    return false;
                }
                ++i;
            }
            if (!found) {
                return false;
            }
            ++j;
        }
        return true;
    }

    public int remove(int o) {
        if (this.values == null) {
            return -1;
        }
        int i = this.insertionIndex(o);
        return this.removeAt(i);
    }

    public int size() {
        return this.size;
    }

    public int removeAt(int i) {
        int toReturn = -1;
        if (this.values == null) {
            return toReturn;
        }
        if (i > -1 && i < this.size) {
            toReturn = this.values[1][i];
            if (this.size == 1) {
                this.values = null;
                this.size = 0;
                return toReturn;
            }
            int j = i;
            while (j < this.size - 1) {
                this.values[0][j] = this.values[0][j + 1];
                this.values[1][j] = this.values[1][j + 1];
                ++j;
            }
            --this.size;
        }
        if (this.size == 0) {
            this.values = null;
        }
        return toReturn;
    }

    public int get(int key) {
        int index = this.insertionIndex(key);
        if (index < 0) {
            return Integer.MIN_VALUE;
        }
        return this.values[1][index];
    }

    public int keySet(int i) {
        return this.values[0][i];
    }

    public int hashCode() {
        int sum = 0;
        int i = 0;
        while (i < this.size) {
            sum += this.values[0][i];
            ++i;
        }
        return sum;
    }

    public boolean equals(@Nullable Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (obj instanceof ArrayIntMap) {
            ArrayIntMap o = (ArrayIntMap)obj;
            if (this.size != o.size) {
                return false;
            }
            if (this.size == 0) {
                return true;
            }
            int i = 0;
            while (i < this.size) {
                if (this.values[0][i] != o.values[0][i]) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    public String toString() {
        if (this.values != null) {
            return String.valueOf(Arrays.toString(Arrays.copyOf(this.values[0], this.size))) + '\n' + Arrays.toString(Arrays.copyOf(this.values[1], this.size));
        }
        return "[]";
    }
}

