/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.jfact.datatypes;

import java.math.BigDecimal;
import java.util.Set;
import org.semanticweb.owlapi.model.HasIRI;
import org.semanticweb.owlapi.vocab.XSDVocabulary;
import uk.ac.manchester.cs.jfact.datatypes.Datatype;
import uk.ac.manchester.cs.jfact.datatypes.DatatypeFactory;
import uk.ac.manchester.cs.jfact.datatypes.Facets;
import uk.ac.manchester.cs.jfact.datatypes.UNSIGNEDLONGDatatype;
import uk.ac.manchester.cs.jfact.datatypes.Utils;

class UNSIGNEDINTDatatype<R extends Comparable<R>>
extends UNSIGNEDLONGDatatype<R> {
    protected UNSIGNEDINTDatatype() {
        this((HasIRI)XSDVocabulary.UNSIGNED_INT, Utils.generateAncestors(DatatypeFactory.UNSIGNEDLONG));
    }

    protected UNSIGNEDINTDatatype(HasIRI uri, Set<Datatype<?>> ancestors) {
        super(uri, ancestors);
        this.knownNonNumericFacetValues.putAll(super.getKnownNonNumericFacetValues());
        this.knownNumericFacetValues.putAll(super.getKnownNumericFacetValues());
        this.knownNonNumericFacetValues.put(Facets.whiteSpace, DatatypeFactory.WHITESPACE);
        this.knownNonNumericFacetValues.put(Facets.pattern, DatatypeFactory.NUMBER_EXPRESSION);
        this.knownNumericFacetValues.put(Facets.minInclusive, new BigDecimal(0L));
        this.knownNumericFacetValues.put(Facets.maxInclusive, new BigDecimal(0xFFFFFFFFL));
    }

    @Override
    public R parseValue(String s) {
        Long parseInt = Long.valueOf(s);
        if (parseInt < 0L) {
            throw new ArithmeticException("Unsigned int required, but found: " + s);
        }
        return (R)parseInt;
    }
}

