/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.jfact.datatypes;

import java.math.BigDecimal;
import java.util.Set;
import org.semanticweb.owlapi.model.HasIRI;
import org.semanticweb.owlapi.vocab.XSDVocabulary;
import uk.ac.manchester.cs.jfact.datatypes.Datatype;
import uk.ac.manchester.cs.jfact.datatypes.DatatypeFactory;
import uk.ac.manchester.cs.jfact.datatypes.Facets;
import uk.ac.manchester.cs.jfact.datatypes.INTDatatype;
import uk.ac.manchester.cs.jfact.datatypes.Utils;

class SHORTDatatype<R extends Comparable<R>>
extends INTDatatype<R> {
    protected SHORTDatatype() {
        this((HasIRI)XSDVocabulary.SHORT, Utils.generateAncestors(DatatypeFactory.INT));
    }

    protected SHORTDatatype(HasIRI uri, Set<Datatype<?>> ancestors) {
        super(uri, ancestors);
        this.knownNonNumericFacetValues.putAll(super.getKnownNonNumericFacetValues());
        this.knownNumericFacetValues.putAll(super.getKnownNumericFacetValues());
        this.knownNonNumericFacetValues.put(Facets.whiteSpace, DatatypeFactory.WHITESPACE);
        this.knownNonNumericFacetValues.put(Facets.pattern, DatatypeFactory.NUMBER_EXPRESSION);
        this.knownNumericFacetValues.put(Facets.minInclusive, new BigDecimal(Short.MIN_VALUE));
        this.knownNumericFacetValues.put(Facets.maxInclusive, new BigDecimal(Short.MAX_VALUE));
    }

    @Override
    public R parseValue(String s) {
        return (R)Short.valueOf(s);
    }
}

